/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.webwork;

import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.util.FakeHttpServletResponse;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;
import org.directwebremoting.webwork.ActionDefinition;
import org.directwebremoting.webwork.AjaxResult;
import org.directwebremoting.webwork.AjaxTextResult;
import org.directwebremoting.webwork.DefaultAjaxDataResult;
import org.directwebremoting.webwork.DefaultAjaxTextResult;
import org.directwebremoting.webwork.IDWRActionProcessor;

public class DWRAction {
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$webwork$DWRAction == null ? (class$org$directwebremoting$webwork$DWRAction = DWRAction.class$("org.directwebremoting.webwork.DWRAction")) : class$org$directwebremoting$webwork$DWRAction);
    private static final String DWRACTIONPROCESSOR_INIT_PARAM = "dwrActionProcessor";
    private static DWRAction s_instance;
    private DispatcherUtils m_wwDispatcher;
    private IDWRActionProcessor m_actionProcessor;
    static /* synthetic */ Class class$org$directwebremoting$webwork$DWRAction;

    private DWRAction(ServletContext servletContext) throws ServletException {
        DispatcherUtils.initialize((ServletContext)servletContext);
        this.m_wwDispatcher = DispatcherUtils.getInstance();
        this.m_actionProcessor = DWRAction.loadActionProcessor(servletContext.getInitParameter(DWRACTIONPROCESSOR_INIT_PARAM));
    }

    public static AjaxResult execute(ActionDefinition actionDefinition, Map params, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException {
        DWRAction.initialize(servletContext);
        return s_instance.doExecute(actionDefinition, params, request, response, servletContext);
    }

    protected AjaxResult doExecute(ActionDefinition actionDefinition, Map params, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException {
        FakeHttpServletResponse actionResponse = new FakeHttpServletResponse();
        if (null != this.m_actionProcessor) {
            this.m_actionProcessor.preProcess(request, response, actionResponse, params);
        }
        this.m_wwDispatcher.prepare(request, (HttpServletResponse)actionResponse);
        ActionInvocation invocation = this.invokeAction(this.m_wwDispatcher, request, actionResponse, servletContext, actionDefinition, params);
        AjaxResult result = null;
        result = actionDefinition.isExecuteResult() ? this.getTextResult(actionResponse) : new DefaultAjaxDataResult(invocation.getAction());
        if (null != this.m_actionProcessor) {
            this.m_actionProcessor.postProcess(request, response, actionResponse, result);
        }
        return result;
    }

    protected ActionInvocation invokeAction(DispatcherUtils du, HttpServletRequest request, HttpServletResponse response, ServletContext context, ActionDefinition actionDefinition, Map params) throws ServletException {
        ActionMapping mapping = this.getActionMapping(actionDefinition, params);
        Map extraContext = du.createContextMap(request, response, mapping, context);
        OgnlValueStack stack = (OgnlValueStack)request.getAttribute("webwork.valueStack");
        if (null != stack) {
            extraContext.put("com.opensymphony.xwork.util.OgnlValueStack.ValueStack", new OgnlValueStack(stack));
        }
        try {
            this.prepareContinuationAction(request, extraContext);
            ActionProxy proxy = ActionProxyFactory.getFactory().createActionProxy(actionDefinition.getNamespace(), actionDefinition.getAction(), extraContext, actionDefinition.isExecuteResult(), false);
            proxy.setMethod(actionDefinition.getMethod());
            request.setAttribute("webwork.valueStack", (Object)proxy.getInvocation().getStack());
            if (mapping.getResult() != null) {
                Result result = mapping.getResult();
                result.execute(proxy.getInvocation());
            } else {
                proxy.execute();
            }
            ActionInvocation actionInvocation = proxy.getInvocation();
            return actionInvocation;
        }
        catch (ConfigurationException ce) {
            throw new ServletException("Cannot invoke action '" + actionDefinition.getAction() + "' in namespace '" + actionDefinition.getNamespace() + "'", (Throwable)ce);
        }
        catch (Exception e) {
            throw new ServletException("Cannot invoke action '" + actionDefinition.getAction() + "' in namespace '" + actionDefinition.getNamespace() + "'", (Throwable)e);
        }
        finally {
            if (null != stack) {
                request.setAttribute("webwork.valueStack", (Object)stack);
            }
        }
    }

    protected void prepareContinuationAction(HttpServletRequest request, Map extraContext) {
        String id = request.getParameter("__continue");
        if (null != id) {
            Map params = (Map)extraContext.get("com.opensymphony.xwork.ActionContext.parameters");
            params.remove("__continue");
            extraContext.put("__continue", id);
        }
    }

    protected ActionMapping getActionMapping(ActionDefinition actionDefinition, Map params) {
        ActionMapping actionMapping = new ActionMapping(actionDefinition.getAction(), actionDefinition.getNamespace(), actionDefinition.getMethod(), params);
        return actionMapping;
    }

    protected AjaxTextResult getTextResult(FakeHttpServletResponse response) {
        DefaultAjaxTextResult result = new DefaultAjaxTextResult();
        String text = null;
        try {
            text = response.getContentAsString();
        }
        catch (UnsupportedEncodingException uee) {
            log.warn("Cannot retrieve text output as string", uee);
        }
        if (null == text) {
            try {
                text = response.getCharacterEncoding() != null ? new String(response.getContentAsByteArray(), response.getCharacterEncoding()) : new String(response.getContentAsByteArray());
            }
            catch (UnsupportedEncodingException uee) {
                log.warn("Cannot retrieve text output as encoded byte array", uee);
                text = new String(response.getContentAsByteArray());
            }
        }
        result.setText(text);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(ServletContext servletContext) throws ServletException {
        Class clazz = class$org$directwebremoting$webwork$DWRAction == null ? (class$org$directwebremoting$webwork$DWRAction = DWRAction.class$("org.directwebremoting.webwork.DWRAction")) : class$org$directwebremoting$webwork$DWRAction;
        synchronized (clazz) {
            if (null == s_instance) {
                s_instance = new DWRAction(servletContext);
            }
        }
    }

    private static IDWRActionProcessor loadActionProcessor(String actionProcessorClassName) throws ServletException {
        if (null == actionProcessorClassName || "".equals(actionProcessorClassName)) {
            return null;
        }
        try {
            Class actionProcessorClass = LocalUtil.classForName(actionProcessorClassName);
            return (IDWRActionProcessor)actionProcessorClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServletException("Cannot load DWRActionProcessor class '" + actionProcessorClassName + "'", (Throwable)cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new ServletException("Cannot instantiate DWRActionProcessor class '" + actionProcessorClassName + "'. Default constructor is not visible", (Throwable)iae);
        }
        catch (InstantiationException ie) {
            throw new ServletException("Cannot instantiate DWRActionProcessor class '" + actionProcessorClassName + "'. No default constructor found", (Throwable)ie);
        }
        catch (Throwable cause) {
            throw new ServletException("Cannot instantiate DWRActionProcessor class '" + actionProcessorClassName + "'", cause);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

