/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.dwrp.Alarm;
import org.directwebremoting.dwrp.BasicAlarm;
import org.directwebremoting.dwrp.Sleeper;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.util.StaticTimer;

public class OutputAlarm
extends BasicAlarm
implements Alarm {
    protected ScriptConduit conduit = new AlarmScriptConduit();
    protected int maxWaitAfterWrite;
    protected RealScriptSession scriptSession;
    protected TimerTask task;
    protected static final Log log = LogFactory.getLog((Class)(class$org$directwebremoting$dwrp$OutputAlarm == null ? (class$org$directwebremoting$dwrp$OutputAlarm = OutputAlarm.class$("org.directwebremoting.dwrp.OutputAlarm")) : class$org$directwebremoting$dwrp$OutputAlarm));
    static /* synthetic */ Class class$org$directwebremoting$dwrp$OutputAlarm;

    public OutputAlarm(RealScriptSession scriptSession, int maxWaitAfterWrite) {
        this.maxWaitAfterWrite = maxWaitAfterWrite;
        this.scriptSession = scriptSession;
    }

    public void setAlarmAction(Sleeper sleeper) {
        try {
            this.scriptSession.addScriptConduit(this.conduit);
        }
        catch (IOException ex) {
            log.warn((Object)"Error adding monitor to script session", (Throwable)ex);
        }
        super.setAlarmAction(sleeper);
    }

    public void cancel() {
        this.scriptSession.removeScriptConduit(this.conduit);
        if (this.task != null) {
            this.task.cancel();
        }
        super.cancel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class AlarmScriptConduit
    extends ScriptConduit {
        protected AlarmScriptConduit() {
            super(10);
        }

        public boolean addScript(ScriptBuffer script) {
            if (OutputAlarm.this.maxWaitAfterWrite <= 0) {
                OutputAlarm.this.raiseAlarm();
            } else {
                OutputAlarm.this.task = new TimerTask(){

                    public void run() {
                        try {
                            OutputAlarm.this.raiseAlarm();
                        }
                        catch (Exception ex) {
                            log.warn((Object)"Unexpected error raising alarm", (Throwable)ex);
                        }
                    }
                };
                StaticTimer.schedule(OutputAlarm.this.task, OutputAlarm.this.maxWaitAfterWrite);
            }
            return false;
        }
    }
}

