/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.javaParser;

import com.tombrus.javaParser.ParserException;
import com.tombrus.javaParser.SimpleStreamTokenizer;
import com.tombrus.javaParser.Span;
import com.tombrus.javaParser.Token;
import com.tombrus.util.DB;
import com.tombrus.util.FileAndCRC;
import java.io.File;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;

public class SpanDoctor {
    public boolean DEBUG;
    private int tabSize;
    private BugCorrector bugCorrector;
    private String fileName;
    private long crc;
    private TokenList tokenList;

    public SpanDoctor(int n, String string) {
        this(n, string, null);
    }

    public SpanDoctor(int n, String string, BugCorrector bugCorrector) {
        this.DEBUG = DB.ONE(string);
        String string2 = FileAndCRC.readStringFromFile(string);
        this.tabSize = n;
        this.fileName = string;
        this.bugCorrector = bugCorrector;
        this.crc = FileAndCRC.getCRC(string2);
        this.tokenList = new TokenList(new BufferTokenizer(n, string2));
    }

    public long getCRC() {
        return this.crc;
    }

    public Span getImportInsertSpan() {
        Span span = new Span(this.fileName);
        span.crc = this.getCRC();
        Token.Iterator iterator = this.tokenList.iterator();
        SpanDoctor.copyTokenBeginToSpanBegin(iterator, span);
        SpanDoctor.copyTokenBeginToSpanEnd(iterator, span);
        Token token = iterator.getNextRelevantToken();
        while (token.value.equals("package") || token.value.equals("import")) {
            do {
                token = iterator.getNextRelevantToken();
            } while (token.type != 799 && !token.value.equals(";"));
            int n = token.from.line;
            do {
                token = iterator.getNextToken();
            } while (token.from.line == n && (token.type == 750 || token.type == 751));
            SpanDoctor.copyTokenBeginToSpanBegin(iterator, span);
            SpanDoctor.copyTokenBeginToSpanEnd(iterator, span);
            if (token.type != 750 && token.type != 751) continue;
            token = iterator.getNextRelevantToken();
        }
        return span;
    }

    public static Span makeInsertBeforeSpan(Span span) {
        if (span != null) {
            span.toColumn = span.fromColumn;
            span.toLine = span.fromLine;
            span.toFileIndex = span.fromFileIndex;
        }
        return span;
    }

    public static Span makeInsertAfterSpan(Span span) {
        if (span != null) {
            span.fromColumn = span.toColumn;
            span.fromLine = span.toLine;
            span.fromFileIndex = span.toFileIndex;
        }
        return span;
    }

    public Span getSpan(int n, int n2, String string) {
        Token token;
        Token token2;
        Span span = new Span(this.fileName);
        span.crc = this.crc;
        Token.Iterator iterator = this.tokenList.iterator(n, n2);
        BufferTokenizer bufferTokenizer = new BufferTokenizer(this.tabSize, string);
        SpanDoctor.copyTokenBeginToSpanBegin(iterator, span);
        block0: do {
            SpanDoctor.copyTokenEndToSpanEnd(iterator, span);
            token = bufferTokenizer.getNextRelevantToken();
            if (token.value.equals("#")) {
                token2 = iterator.getNextRelevantToken();
                token = bufferTokenizer.getNextRelevantToken();
                SpanDoctor.copyTokenBeginToSpanBegin(iterator, span);
                SpanDoctor.copyTokenEndToSpanEnd(iterator, span);
                continue;
            }
            if (token.value.equals("@")) {
                token = bufferTokenizer.getNextRelevantToken();
                do {
                    token2 = iterator.getNextToken();
                    if (token2.type != 750 && token2.type != 751) continue block0;
                    SpanDoctor.copyTokenEndToSpanEnd(iterator, span);
                } while (!SpanDoctor.containsEOL(token2));
                continue;
            }
            token2 = iterator.getNextRelevantToken();
        } while (token2.type != 799 && token.type != 799 && token2.type == token.type && token2.value.equals(token.value));
        if (token.type != 799) {
            throw new ParserException("Problem: inconsistent source: \n         found         = " + token2 + "\n         expected      = " + token + "\n         looking for   = " + string + "\n         span till now = " + span, this.fileName);
        }
        return span;
    }

    private static boolean containsEOL(Token token) {
        return token.value.indexOf("\n") != -1 || token.value.indexOf("\r") != -1;
    }

    static void copyTokenBeginToSpanBegin(Token.Iterator iterator, Span span) {
        Token token = iterator.getCurrentToken();
        span.fromLine = token.from.line;
        span.fromColumn = token.from.column;
        span.fromFileIndex = token.fromIndex;
    }

    static void copyTokenBeginToSpanEnd(Token.Iterator iterator, Span span) {
        Token token = iterator.getCurrentToken();
        span.toLine = token.from.line;
        span.toColumn = token.from.column;
        span.toFileIndex = token.fromIndex;
    }

    static void copyTokenEndToSpanBegin(Token.Iterator iterator, Span span) {
        Token token = iterator.getCurrentToken();
        span.fromLine = token.to.line;
        span.fromColumn = token.to.column;
        span.fromFileIndex = token.toIndex;
    }

    static void copyTokenEndToSpanEnd(Token.Iterator iterator, Span span) {
        Token token = iterator.getCurrentToken();
        span.toLine = token.to.line;
        span.toColumn = token.to.column;
        span.toFileIndex = token.toIndex;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("D:/Projects/Pasta-tomHome/Pasta/testenv/source/NorthPole.java");
            file = file.exists() ? file : new File("D:/Projects/Optidev-tomWerk3/Optidev/Pasta/testenv/source/NorthPole.java");
            SpanDoctor spanDoctor = new SpanDoctor(4, file.getPath());
            Token.Iterator iterator = spanDoctor.tokenList.iterator(1, 1);
            while (iterator.getCurrentToken().type != 799) {
                System.err.println("TEST +++ " + iterator.getNextRelevantToken());
            }
            System.err.println("TEST *** importspan=" + spanDoctor.getImportInsertSpan());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class TokenList {
        private HashMap tokenMap = new HashMap();

        TokenList(Token.Iterator iterator) {
            Token token = null;
            while (token == null || token.type != 799) {
                token = iterator.getNextToken();
                this.tokenMap.put(token.from, token);
            }
        }

        Token.Iterator iterator() {
            return this.iterator(1, 1);
        }

        Token.Iterator iterator(int n, int n2) {
            Token.Position position = new Token.Position(n, n2);
            Token token = (Token)this.tokenMap.get(position);
            if (token == null) {
                if (SpanDoctor.this.DEBUG) {
                    System.err.println("no token at " + position + ", tokens in this line:");
                    Token.Position position2 = null;
                    Iterator iterator = this.tokenMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        Token.Position position3 = (Token.Position)iterator.next();
                        if (n != position3.line || position2 != null && position2.column <= position3.column) continue;
                        position2 = position3;
                    }
                    if (position2 != null) {
                        token = (Token)this.tokenMap.get(position2);
                        do {
                            System.err.println("  -- " + token);
                            token = token.next;
                        } while (token.type != 799 && token.from.line == n);
                    }
                }
                throw new ParserException("no token at " + position, SpanDoctor.this.fileName);
            }
            return new Token.ListIterator(token);
        }
    }

    private class BufferTokenizer
    extends SimpleStreamTokenizer {
        BufferTokenizer(int n, String string) {
            super(n, new StringReader(string));
        }

        public Token getNextToken() {
            Token token = super.getNextToken();
            if (SpanDoctor.this.bugCorrector != null) {
                int n = token.to.column - token.from.column;
                SpanDoctor.this.bugCorrector.correctForCompilerBug(token);
                int n2 = token.to.column - token.from.column;
                if (n != n2) {
                    if (SimpleStreamTokenizer.DEBUG) {
                        System.err.println("^^^ corrected column from " + this.column + " to " + token.to.column + " for " + token);
                    }
                    this.column = token.to.column;
                }
            }
            return token;
        }
    }

    public static interface BugCorrector {
        public void correctForCompilerBug(Token var1);
    }
}

