/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.javaParser;

import com.tombrus.javaParser.CompilerCallerCreator;
import com.tombrus.javaParser.CompilerCallerInterface;
import com.tombrus.javaParser.Examiner;
import com.tombrus.javaParser.ParserException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class Analyzer {
    protected String classPathString;
    protected HashMap extraArgs;

    public Analyzer(String[] stringArray) {
        this(stringArray, null);
    }

    public Analyzer(String[] stringArray, HashMap hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]).append(System.getProperty("path.separator", ";"));
            ++n;
        }
        this.classPathString = stringBuffer.toString();
        this.extraArgs = hashMap;
    }

    public void analyzeFiles(String[] stringArray, Examiner examiner) throws IOException {
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(stringArray[n]);
            ++n;
        }
        this.analyzeFiles(fileArray, examiner);
    }

    public void analyzeFiles(File[] fileArray, Examiner examiner) throws IOException {
        try {
            this.getCompilerCaller().compile(this.classPathString, fileArray, examiner, this.extraArgs);
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
            throw new IOException("Could not compile sources: " + parserException.getMessage());
        }
    }

    protected CompilerCallerInterface getCompilerCaller() {
        return CompilerCallerCreator.getCompilerCaller();
    }

    public static boolean isCompilerAvailable() {
        return CompilerCallerCreator.getCompilerCallerOrNull() != null;
    }
}

