/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.clustering.state.StateClusteringCommandFactory;
import org.apache.axis2.clustering.state.StateManager;
import org.apache.axis2.clustering.state.commands.StateClusteringCommandCollection;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.Parameter;

public class DefaultStateManager
implements StateManager {
    private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();
    private ChannelSender sender;
    private final Map<String, List> excludedReplicationPatterns = new HashMap<String, List>();

    public void setSender(ChannelSender sender) {
        this.sender = sender;
    }

    public void updateContext(AbstractContext context) throws ClusteringFault {
        StateClusteringCommand cmd = StateClusteringCommandFactory.getUpdateCommand(context, this.excludedReplicationPatterns, false);
        if (cmd != null) {
            this.sender.sendToGroup((ClusteringCommand)cmd);
        }
    }

    public void updateContext(AbstractContext context, String[] propertyNames) throws ClusteringFault {
        StateClusteringCommand cmd = StateClusteringCommandFactory.getUpdateCommand(context, propertyNames);
        if (cmd != null) {
            this.sender.sendToGroup((ClusteringCommand)cmd);
        }
    }

    public void updateContexts(AbstractContext[] contexts) throws ClusteringFault {
        StateClusteringCommandCollection cmd = StateClusteringCommandFactory.getCommandCollection(contexts, this.excludedReplicationPatterns);
        this.sender.sendToGroup((ClusteringCommand)cmd);
    }

    public void removeContext(AbstractContext context) throws ClusteringFault {
        StateClusteringCommand cmd = StateClusteringCommandFactory.getRemoveCommand(context);
        this.sender.sendToGroup((ClusteringCommand)cmd);
    }

    public boolean isContextClusterable(AbstractContext context) {
        return context instanceof ConfigurationContext || context instanceof ServiceContext || context instanceof ServiceGroupContext;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
    }

    public void setReplicationExcludePatterns(String contextType, List patterns) {
        this.excludedReplicationPatterns.put(contextType, patterns);
    }

    public Map getReplicationExcludePatterns() {
        return this.excludedReplicationPatterns;
    }

    public void addParameter(Parameter param) throws AxisFault {
        this.parameters.put(param.getName(), param);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public ArrayList getParameters() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (String msg : this.parameters.keySet()) {
            list.add(this.parameters.get(msg));
        }
        return list;
    }

    public boolean isParameterLocked(String parameterName) {
        return this.getParameter(parameterName).isLocked();
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        throw new UnsupportedOperationException();
    }
}

