/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.OperationHelper;
import com.mongodb.session.SessionContext;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

final class CommandOperationHelper {
    private static final List<Integer> RETRYABLE_ERROR_CODES = Arrays.asList(6, 7, 89, 91, 189, 9001, 13436, 13435, 11602, 11600, 10107);

    static CommandTransformer<BsonDocument, Void> writeConcernErrorTransformer() {
        return new CommandTransformer<BsonDocument, Void>(){

            @Override
            public Void apply(BsonDocument result, ServerAddress serverAddress) {
                WriteConcernHelper.throwOnWriteConcernError(result, serverAddress);
                return null;
            }
        };
    }

    static BsonDocument executeWrappedCommandProtocol(ReadBinding binding, String database, BsonDocument command) {
        return CommandOperationHelper.executeWrappedCommandProtocol(binding, database, command, new BsonDocumentCodec());
    }

    static <T> T executeWrappedCommandProtocol(ReadBinding binding, String database, BsonDocument command, CommandTransformer<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(binding, database, command, new BsonDocumentCodec(), transformer);
    }

    static <T> T executeWrappedCommandProtocol(ReadBinding binding, String database, BsonDocument command, Decoder<T> decoder) {
        return CommandOperationHelper.executeWrappedCommandProtocol(binding, database, command, decoder, new IdentityTransformer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <D, T> T executeWrappedCommandProtocol(ReadBinding binding, String database, BsonDocument command, Decoder<D> decoder, CommandTransformer<D, T> transformer) {
        ConnectionSource source = binding.getReadConnectionSource();
        try {
            T t = transformer.apply(CommandOperationHelper.executeWrappedCommandProtocol(database, command, decoder, source, binding.getReadPreference()), source.getServerDescription().getAddress());
            return t;
        }
        finally {
            source.release();
        }
    }

    static BsonDocument executeWrappedCommandProtocol(ReadBinding binding, String database, BsonDocument command, Connection connection) {
        return (BsonDocument)CommandOperationHelper.executeWrappedCommandProtocol(binding, database, command, connection, new IdentityTransformer());
    }

    static <T> T executeWrappedCommandProtocol(ReadBinding binding, String database, BsonDocument command, Connection connection, CommandTransformer<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(binding, database, command, (Decoder<BsonDocument>)new BsonDocumentCodec(), connection, transformer);
    }

    static <T> T executeWrappedCommandProtocol(ReadBinding binding, String database, BsonDocument command, Decoder<BsonDocument> decoder, Connection connection, CommandTransformer<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, decoder, connection, binding.getReadPreference(), transformer, binding.getSessionContext());
    }

    static BsonDocument executeWrappedCommandProtocol(WriteBinding binding, String database, BsonDocument command) {
        return (BsonDocument)CommandOperationHelper.executeWrappedCommandProtocol(binding, database, command, new IdentityTransformer());
    }

    static <T> T executeWrappedCommandProtocol(WriteBinding binding, String database, BsonDocument command, Decoder<T> decoder) {
        return CommandOperationHelper.executeWrappedCommandProtocol(binding, database, command, decoder, new IdentityTransformer());
    }

    static <T> T executeWrappedCommandProtocol(WriteBinding binding, String database, BsonDocument command, CommandTransformer<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(binding, database, command, new BsonDocumentCodec(), transformer);
    }

    static <D, T> T executeWrappedCommandProtocol(WriteBinding binding, String database, BsonDocument command, Decoder<D> decoder, CommandTransformer<D, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(binding, database, command, new NoOpFieldNameValidator(), decoder, transformer);
    }

    static <T> T executeWrappedCommandProtocol(WriteBinding binding, String database, BsonDocument command, Connection connection, CommandTransformer<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(binding, database, command, (Decoder<BsonDocument>)new BsonDocumentCodec(), connection, transformer);
    }

    static <T> T executeWrappedCommandProtocol(WriteBinding binding, String database, BsonDocument command, Decoder<BsonDocument> decoder, Connection connection, CommandTransformer<BsonDocument, T> transformer) {
        Assertions.notNull("binding", binding);
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, decoder, connection, ReadPreference.primary(), transformer, binding.getSessionContext());
    }

    static <T> T executeWrappedCommandProtocol(WriteBinding binding, String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<BsonDocument> decoder, Connection connection, CommandTransformer<BsonDocument, T> transformer) {
        Assertions.notNull("binding", binding);
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, fieldNameValidator, decoder, connection, ReadPreference.primary(), transformer, binding.getSessionContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <D, T> T executeWrappedCommandProtocol(WriteBinding binding, String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, CommandTransformer<D, T> transformer) {
        ConnectionSource source = binding.getWriteConnectionSource();
        try {
            T t = transformer.apply(CommandOperationHelper.executeWrappedCommandProtocol(database, command, fieldNameValidator, decoder, source, ReadPreference.primary()), source.getServerDescription().getAddress());
            return t;
        }
        finally {
            source.release();
        }
    }

    static BsonDocument executeWrappedCommandProtocol(WriteBinding binding, String database, BsonDocument command, Connection connection) {
        Assertions.notNull("binding", binding);
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, new BsonDocumentCodec(), connection, ReadPreference.primary(), binding.getSessionContext());
    }

    private static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<T> decoder, ConnectionSource source, ReadPreference readPreference) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, new NoOpFieldNameValidator(), decoder, source, readPreference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<T> decoder, ConnectionSource source, ReadPreference readPreference) {
        Connection connection = source.getConnection();
        try {
            T t = CommandOperationHelper.executeWrappedCommandProtocol(database, command, fieldNameValidator, decoder, connection, readPreference, new IdentityTransformer(), source.getSessionContext());
            return t;
        }
        finally {
            connection.release();
        }
    }

    private static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<T> decoder, Connection connection, ReadPreference readPreference, SessionContext sessionContext) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, new NoOpFieldNameValidator(), decoder, connection, readPreference, new IdentityTransformer(), sessionContext);
    }

    private static <D, T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<D> decoder, Connection connection, ReadPreference readPreference, CommandTransformer<D, T> transformer, SessionContext sessionContext) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, new NoOpFieldNameValidator(), decoder, connection, readPreference, transformer, sessionContext);
    }

    private static <D, T> T executeWrappedCommandProtocol(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, Connection connection, ReadPreference readPreference, CommandTransformer<D, T> transformer, SessionContext sessionContext) {
        return transformer.apply(connection.command(database, command, fieldNameValidator, readPreference, decoder, sessionContext), connection.getDescription().getServerAddress());
    }

    static void executeWrappedCommandProtocolAsync(AsyncReadBinding binding, String database, BsonDocument command, SingleResultCallback<BsonDocument> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, database, command, new BsonDocumentCodec(), callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(AsyncReadBinding binding, String database, BsonDocument command, Decoder<T> decoder, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, database, command, decoder, new IdentityTransformer(), callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(AsyncReadBinding binding, String database, BsonDocument command, CommandTransformer<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, database, command, new BsonDocumentCodec(), transformer, callback);
    }

    static <D, T> void executeWrappedCommandProtocolAsync(AsyncReadBinding binding, String database, BsonDocument command, Decoder<D> decoder, CommandTransformer<D, T> transformer, SingleResultCallback<T> callback) {
        binding.getReadConnectionSource(new CommandProtocolExecutingCallback<D, T>(database, command, new NoOpFieldNameValidator(), decoder, binding.getReadPreference(), transformer, binding.getSessionContext(), ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER)));
    }

    static <T> void executeWrappedCommandProtocolAsync(AsyncReadBinding binding, String database, BsonDocument command, AsyncConnection connection, CommandTransformer<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, database, command, (Decoder<BsonDocument>)new BsonDocumentCodec(), connection, transformer, callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(AsyncReadBinding binding, String database, BsonDocument command, Decoder<BsonDocument> decoder, AsyncConnection connection, CommandTransformer<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        Assertions.notNull("binding", binding);
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, decoder, connection, binding.getReadPreference(), transformer, binding.getSessionContext(), callback);
    }

    static void executeWrappedCommandProtocolAsync(AsyncWriteBinding binding, String database, BsonDocument command, SingleResultCallback<BsonDocument> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, database, command, new BsonDocumentCodec(), callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(AsyncWriteBinding binding, String database, BsonDocument command, Decoder<T> decoder, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, database, command, decoder, new IdentityTransformer(), callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(AsyncWriteBinding binding, String database, BsonDocument command, CommandTransformer<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, database, command, new BsonDocumentCodec(), transformer, callback);
    }

    static <D, T> void executeWrappedCommandProtocolAsync(AsyncWriteBinding binding, String database, BsonDocument command, Decoder<D> decoder, CommandTransformer<D, T> transformer, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, database, command, new NoOpFieldNameValidator(), decoder, transformer, callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(AsyncWriteBinding binding, String database, BsonDocument command, Decoder<BsonDocument> decoder, AsyncConnection connection, CommandTransformer<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        Assertions.notNull("binding", binding);
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, decoder, connection, ReadPreference.primary(), transformer, binding.getSessionContext(), callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(AsyncWriteBinding binding, String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<BsonDocument> decoder, AsyncConnection connection, CommandTransformer<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        Assertions.notNull("binding", binding);
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, fieldNameValidator, decoder, connection, ReadPreference.primary(), transformer, binding.getSessionContext(), callback);
    }

    static <D, T> void executeWrappedCommandProtocolAsync(AsyncWriteBinding binding, String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, CommandTransformer<D, T> transformer, SingleResultCallback<T> callback) {
        binding.getWriteConnectionSource(new CommandProtocolExecutingCallback<D, T>(database, command, fieldNameValidator, decoder, ReadPreference.primary(), transformer, binding.getSessionContext(), ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER)));
    }

    static void executeWrappedCommandProtocolAsync(AsyncWriteBinding binding, String database, BsonDocument command, AsyncConnection connection, SingleResultCallback<BsonDocument> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, database, command, connection, new IdentityTransformer(), callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(AsyncWriteBinding binding, String database, BsonDocument command, AsyncConnection connection, CommandTransformer<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        Assertions.notNull("binding", binding);
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, new BsonDocumentCodec(), connection, ReadPreference.primary(), transformer, binding.getSessionContext(), callback);
    }

    private static <D, T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, Decoder<D> decoder, final AsyncConnection connection, ReadPreference readPreference, final CommandTransformer<D, T> transformer, SessionContext sessionContext, final SingleResultCallback<T> callback) {
        connection.commandAsync(database, command, new NoOpFieldNameValidator(), readPreference, decoder, sessionContext, new SingleResultCallback<D>(){

            @Override
            public void onResult(D result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    try {
                        Object transformedResult = transformer.apply(result, connection.getDescription().getServerAddress());
                        callback.onResult(transformedResult, null);
                    }
                    catch (Exception e) {
                        callback.onResult(null, e);
                    }
                }
            }
        });
    }

    private static <D, T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, final AsyncConnection connection, ReadPreference readPreference, final CommandTransformer<D, T> transformer, SessionContext sessionContext, final SingleResultCallback<T> callback) {
        connection.commandAsync(database, command, fieldNameValidator, readPreference, decoder, sessionContext, true, null, null, new SingleResultCallback<D>(){

            @Override
            public void onResult(D result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    try {
                        Object transformedResult = transformer.apply(result, connection.getDescription().getServerAddress());
                        callback.onResult(transformedResult, null);
                    }
                    catch (Exception e) {
                        callback.onResult(null, e);
                    }
                }
            }
        });
    }

    static <T, R> R executeRetryableCommand(final WriteBinding binding, final String database, final ReadPreference readPreference, final FieldNameValidator fieldNameValidator, final Decoder<T> commandResultDecoder, final CommandCreator commandCreator, final CommandTransformer<T, R> transformer) {
        return (R)OperationHelper.withReleasableConnection(binding, new OperationHelper.CallableWithConnectionAndSource<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R call(ConnectionSource source, Connection connection) {
                MongoException exception;
                BsonDocument command = null;
                try {
                    command = commandCreator.create(source.getServerDescription(), connection.getDescription());
                    Object r = transformer.apply(connection.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext()), connection.getDescription().getServerAddress());
                    return r;
                }
                catch (MongoException e) {
                    exception = e;
                    if (!CommandOperationHelper.shouldAttemptToRetry(command, e)) {
                        if (CommandOperationHelper.isRetryWritesEnabled(command)) {
                            CommandOperationHelper.logUnableToRetry(command.getFirstKey(), e);
                        }
                        throw exception;
                    }
                }
                finally {
                    connection.release();
                }
                final BsonDocument originalCommand = command;
                final MongoException originalException = exception;
                return OperationHelper.withReleasableConnection(binding, originalException, new OperationHelper.CallableWithConnectionAndSource<R>(){

                    @Override
                    public R call(ConnectionSource source, Connection connection) {
                        try {
                            if (!OperationHelper.canRetryWrite(source.getServerDescription(), connection.getDescription(), binding.getSessionContext())) {
                                throw originalException;
                            }
                            CommandOperationHelper.logRetryExecute(originalCommand.getFirstKey(), originalException);
                            Object r = transformer.apply(connection.command(database, originalCommand, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext()), connection.getDescription().getServerAddress());
                            return r;
                        }
                        catch (MongoException e) {
                            throw originalException;
                        }
                        finally {
                            connection.release();
                        }
                    }
                });
            }
        });
    }

    static <T, R> void executeRetryableCommand(final AsyncWriteBinding binding, final String database, final ReadPreference readPreference, final FieldNameValidator fieldNameValidator, final Decoder<T> commandResultDecoder, final CommandCreator commandCreator, final CommandTransformer<T, R> transformer, SingleResultCallback<R> originalCallback) {
        final SingleResultCallback<R> errorHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(originalCallback, OperationHelper.LOGGER);
        binding.getWriteConnectionSource(new SingleResultCallback<AsyncConnectionSource>(){

            @Override
            public void onResult(final AsyncConnectionSource source, Throwable t) {
                if (t != null) {
                    errorHandlingCallback.onResult(null, t);
                } else {
                    source.getConnection(new SingleResultCallback<AsyncConnection>(){

                        @Override
                        public void onResult(AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                OperationHelper.releasingCallback(errorHandlingCallback, source).onResult(null, t);
                            } else {
                                try {
                                    BsonDocument command = commandCreator.create(source.getServerDescription(), connection.getDescription());
                                    connection.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext(), CommandOperationHelper.createCommandCallback(binding, source, connection, database, readPreference, command, fieldNameValidator, commandResultDecoder, transformer, errorHandlingCallback));
                                }
                                catch (Throwable t1) {
                                    OperationHelper.releasingCallback(errorHandlingCallback, source, connection).onResult(null, t1);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private static <T, R> SingleResultCallback<T> createCommandCallback(final AsyncWriteBinding binding, final AsyncConnectionSource oldSource, final AsyncConnection oldConnection, final String database, final ReadPreference readPreference, final BsonDocument command, final FieldNameValidator fieldNameValidator, final Decoder<T> commandResultDecoder, final CommandTransformer<T, R> transformer, final SingleResultCallback<R> callback) {
        return new SingleResultCallback<T>(){

            @Override
            public void onResult(T result, Throwable originalError) {
                SingleResultCallback releasingCallback = OperationHelper.releasingCallback(callback, oldSource, oldConnection);
                if (originalError != null) {
                    this.checkRetryableException(originalError, releasingCallback);
                } else {
                    try {
                        releasingCallback.onResult(transformer.apply(result, oldConnection.getDescription().getServerAddress()), null);
                    }
                    catch (Throwable transformError) {
                        this.checkRetryableException(transformError, releasingCallback);
                    }
                }
            }

            private void checkRetryableException(Throwable originalError, SingleResultCallback<R> releasingCallback) {
                if (!CommandOperationHelper.shouldAttemptToRetry(command, originalError)) {
                    if (CommandOperationHelper.isRetryWritesEnabled(command)) {
                        CommandOperationHelper.logUnableToRetry(command.getFirstKey(), originalError);
                    }
                    releasingCallback.onResult(null, originalError);
                } else {
                    oldConnection.release();
                    oldSource.release();
                    this.retryableCommand(originalError);
                }
            }

            private void retryableCommand(final Throwable originalError) {
                CommandOperationHelper.logRetryExecute(command.getFirstKey(), originalError);
                OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnectionAndSource(){

                    @Override
                    public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, originalError);
                        } else if (!OperationHelper.canRetryWrite(source.getServerDescription(), connection.getDescription(), binding.getSessionContext())) {
                            OperationHelper.releasingCallback(callback, source, connection).onResult(null, originalError);
                        } else {
                            connection.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext(), new TransformingResultCallback(transformer, connection.getDescription().getServerAddress(), originalError, OperationHelper.releasingCallback(callback, source, connection)));
                        }
                    }
                });
            }
        };
    }

    static boolean isRetryableException(Throwable t) {
        if (!(t instanceof MongoException)) {
            return false;
        }
        if (t instanceof MongoSocketException || t instanceof MongoNotPrimaryException || t instanceof MongoNodeIsRecoveringException) {
            return true;
        }
        String errorMessage = t.getMessage();
        if (t instanceof MongoWriteConcernException) {
            errorMessage = ((MongoWriteConcernException)t).getWriteConcernError().getMessage();
        }
        if (errorMessage.contains("not master") || errorMessage.contains("node is recovering")) {
            return true;
        }
        return RETRYABLE_ERROR_CODES.contains(((MongoException)t).getCode());
    }

    static void rethrowIfNotNamespaceError(MongoCommandException e) {
        CommandOperationHelper.rethrowIfNotNamespaceError(e, null);
    }

    static <T> T rethrowIfNotNamespaceError(MongoCommandException e, T defaultValue) {
        if (!CommandOperationHelper.isNamespaceError(e)) {
            throw e;
        }
        return defaultValue;
    }

    static boolean isNamespaceError(Throwable t) {
        if (t instanceof MongoCommandException) {
            MongoCommandException e = (MongoCommandException)t;
            return e.getErrorMessage().contains("ns not found") || e.getErrorCode() == 26;
        }
        return false;
    }

    private static boolean shouldAttemptToRetry(@Nullable BsonDocument command, Throwable exception) {
        return CommandOperationHelper.isRetryWritesEnabled(command) && CommandOperationHelper.isRetryableException(exception);
    }

    private static boolean isRetryWritesEnabled(@Nullable BsonDocument command) {
        return command != null && (command.containsKey("txnNumber") || command.getFirstKey().equals("commitTransaction") || command.getFirstKey().equals("abortTransaction"));
    }

    static boolean shouldAttemptToRetry(boolean retryWritesEnabled, Throwable exception) {
        return retryWritesEnabled && CommandOperationHelper.isRetryableException(exception);
    }

    static void logRetryExecute(String operation, Throwable originalError) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            OperationHelper.LOGGER.debug(String.format("Retrying operation %s due to an error \"%s\"", operation, originalError));
        }
    }

    static void logUnableToRetry(String operation, Throwable originalError) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            OperationHelper.LOGGER.debug(String.format("Unable to retry operation %s due to error \"%s\"", operation, originalError));
        }
    }

    private CommandOperationHelper() {
    }

    private static class CommandProtocolExecutingCallback<D, R>
    implements SingleResultCallback<AsyncConnectionSource> {
        private final String database;
        private final BsonDocument command;
        private final Decoder<D> decoder;
        private final ReadPreference readPreference;
        private final FieldNameValidator fieldNameValidator;
        private final CommandTransformer<D, R> transformer;
        private final SingleResultCallback<R> callback;
        private final SessionContext sessionContext;

        CommandProtocolExecutingCallback(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, ReadPreference readPreference, CommandTransformer<D, R> transformer, SessionContext sessionContext, SingleResultCallback<R> callback) {
            this.database = database;
            this.command = command;
            this.fieldNameValidator = fieldNameValidator;
            this.decoder = decoder;
            this.readPreference = readPreference;
            this.transformer = transformer;
            this.sessionContext = sessionContext;
            this.callback = callback;
        }

        @Override
        public void onResult(final AsyncConnectionSource source, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                source.getConnection(new SingleResultCallback<AsyncConnection>(){

                    @Override
                    public void onResult(final AsyncConnection connection, Throwable t) {
                        if (t != null) {
                            CommandProtocolExecutingCallback.this.callback.onResult(null, t);
                        } else {
                            final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(CommandProtocolExecutingCallback.this.callback, source, connection);
                            connection.commandAsync(CommandProtocolExecutingCallback.this.database, CommandProtocolExecutingCallback.this.command, CommandProtocolExecutingCallback.this.fieldNameValidator, CommandProtocolExecutingCallback.this.readPreference, CommandProtocolExecutingCallback.this.decoder, CommandProtocolExecutingCallback.this.sessionContext, new SingleResultCallback<D>(){

                                @Override
                                public void onResult(D response, Throwable t) {
                                    if (t != null) {
                                        wrappedCallback.onResult(null, t);
                                    } else {
                                        wrappedCallback.onResult(CommandProtocolExecutingCallback.this.transformer.apply(response, connection.getDescription().getServerAddress()), null);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    static class TransformingResultCallback<T, R>
    implements SingleResultCallback<T> {
        private final CommandTransformer<T, R> transformer;
        private final ServerAddress serverAddress;
        private final Throwable originalError;
        private final SingleResultCallback<R> callback;

        TransformingResultCallback(CommandTransformer<T, R> transformer, ServerAddress serverAddress, Throwable originalError, SingleResultCallback<R> callback) {
            this.transformer = transformer;
            this.serverAddress = serverAddress;
            this.originalError = originalError;
            this.callback = callback;
        }

        @Override
        public void onResult(T result, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                try {
                    R transformedResult = this.transformer.apply(result, this.serverAddress);
                    this.callback.onResult(transformedResult, null);
                }
                catch (Throwable transformError) {
                    this.callback.onResult(null, this.originalError);
                }
            }
        }
    }

    static interface CommandCreator {
        public BsonDocument create(ServerDescription var1, ConnectionDescription var2);
    }

    static class IdentityTransformer<T>
    implements CommandTransformer<T, T> {
        IdentityTransformer() {
        }

        @Override
        public T apply(T t, ServerAddress serverAddress) {
            return t;
        }
    }

    static interface CommandTransformer<T, R> {
        public R apply(T var1, ServerAddress var2);
    }
}

