/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.Debug;
import javax.security.auth.login.LoginException;

public class LoginContext {
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.sun.security.auth.Resources");
    private static final String INIT_METHOD = "initialize";
    private static final String LOGIN_METHOD = "login";
    private static final String COMMIT_METHOD = "commit";
    private static final String ABORT_METHOD = "abort";
    private static final String LOGOUT_METHOD = "logout";
    private static final String OTHER = "other";
    private Subject subject = null;
    private boolean subjectProvided = false;
    private CallbackHandler callbackHandler;
    private Map state = new HashMap();
    private Configuration config;
    private AppConfigurationEntry[] moduleStack;
    private ClassLoader contextClassLoader = null;
    private static final Class[] PARAMS = new Class[0];
    private static final Debug debug = Debug.getInstance("logincontext", "\t[LoginContext]");

    private void init(String string) throws LoginException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("createLoginContext"));
        }
        if (string == null) {
            throw new LoginException(rb.getString("Invalid null input: name"));
        }
        if (this.config == null) {
            this.config = (Configuration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Configuration.getConfiguration();
                }
            });
        }
        this.moduleStack = this.config.getAppConfigurationEntry(string);
        if (this.moduleStack == null) {
            this.moduleStack = this.config.getAppConfigurationEntry(OTHER);
            if (this.moduleStack == null) {
                throw new LoginException(rb.getString("No LoginModules configured for ") + string);
            }
        }
        this.contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public LoginContext(String string) throws LoginException {
        this.init(string);
    }

    public LoginContext(String string, Subject subject) throws LoginException {
        this.init(string);
        if (subject == null) {
            throw new LoginException(rb.getString("invalid null Subject provided"));
        }
        this.subject = subject;
        this.subjectProvided = true;
    }

    public LoginContext(String string, CallbackHandler callbackHandler) throws LoginException {
        this.init(string);
        if (callbackHandler == null) {
            throw new LoginException(rb.getString("invalid null CallbackHandler provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this(string, subject);
        if (callbackHandler == null) {
            throw new LoginException(rb.getString("invalid null CallbackHandler provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public void login() throws LoginException {
        Object var1_1 = null;
        if (this.subject == null) {
            this.subject = new Subject();
        }
        try {
            this.invokeModule(LOGIN_METHOD);
            this.invokeModule(COMMIT_METHOD);
        }
        catch (LoginException loginException) {
            try {
                this.invokeModule(ABORT_METHOD);
            }
            catch (LoginException loginException2) {
                if (!this.subjectProvided) {
                    this.subject = null;
                }
                throw loginException;
            }
            if (!this.subjectProvided) {
                this.subject = null;
            }
            throw loginException;
        }
    }

    public void logout() throws LoginException {
        if (this.subject == null) {
            throw new LoginException(rb.getString("null subject - logout called before login"));
        }
        try {
            this.invokeModule(LOGOUT_METHOD);
        }
        catch (LoginException loginException) {
            if (!this.subjectProvided) {
                this.subject = null;
            }
            throw loginException;
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    private void throwException(LoginException loginException, LoginException loginException2) throws LoginException {
        LoginException loginException3 = loginException != null ? loginException : loginException2;
        throw loginException3;
    }

    private void invokeModule(String string) throws LoginException {
        try {
            final String string2 = string;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws LoginException {
                    LoginContext.this.invoke(string2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (LoginException)privilegedActionException.getException();
        }
    }

    private void invoke(String string) throws LoginException {
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        boolean bl = false;
        int n = 0;
        while (n < this.moduleStack.length) {
            block34: {
                Object[] objectArray3;
                try {
                    Object[] objectArray4;
                    int n2 = 0;
                    Method[] methodArray = null;
                    if (this.moduleStack[n].module != null) {
                        methodArray = this.moduleStack[n].module.getClass().getMethods();
                    } else {
                        objectArray4 = Class.forName(this.moduleStack[n].getLoginModuleName(), true, this.contextClassLoader);
                        Constructor<?> constructor = objectArray4.getConstructor(PARAMS);
                        Object[] objectArray5 = new Object[]{};
                        this.moduleStack[n].module = constructor.newInstance(objectArray5);
                        methodArray = this.moduleStack[n].module.getClass().getMethods();
                        n2 = 0;
                        while (n2 < methodArray.length) {
                            if (methodArray[n2].getName().equals(INIT_METHOD)) break;
                            ++n2;
                        }
                        objectArray3 = new Object[]{this.subject, this.callbackHandler, this.state, this.moduleStack[n].getOptions()};
                        methodArray[n2].invoke(this.moduleStack[n].module, objectArray3);
                    }
                    n2 = 0;
                    while (n2 < methodArray.length) {
                        if (methodArray[n2].getName().equals(string)) break;
                        ++n2;
                    }
                    objectArray4 = new Object[]{};
                    boolean bl2 = (Boolean)methodArray[n2].invoke(this.moduleStack[n].module, objectArray4);
                    if (bl2) {
                        if (!string.equals(ABORT_METHOD) && !string.equals(LOGOUT_METHOD) && this.moduleStack[n].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && objectArray2 == null) {
                            if (debug != null) {
                                debug.println(string + " SUFFICIENT success");
                            }
                            return;
                        }
                        if (debug != null) {
                            debug.println(string + " success");
                        }
                        bl = true;
                    } else if (debug != null) {
                        debug.println(string + " ignored");
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new LoginException(rb.getString("unable to instantiate LoginModule, ") + this.moduleStack[n].getLoginModuleName() + rb.getString(", because it does not provide a ") + rb.getString("no-argument constructor"));
                }
                catch (InstantiationException instantiationException) {
                    throw new LoginException(rb.getString("unable to instantiate LoginModule: ") + instantiationException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new LoginException(rb.getString("unable to find LoginModule class: ") + classNotFoundException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new LoginException(rb.getString("unable to access LoginModule: ") + illegalAccessException.getMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof LoginException) {
                        objectArray3 = (Object[])invocationTargetException.getTargetException();
                    } else {
                        StringWriter stringWriter = new StringWriter();
                        invocationTargetException.getTargetException().printStackTrace(new PrintWriter(stringWriter));
                        stringWriter.flush();
                        objectArray3 = new LoginException(stringWriter.toString());
                    }
                    if (this.moduleStack[n].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                        if (debug != null) {
                            debug.println(string + " REQUISITE failure");
                        }
                        if (string.equals(ABORT_METHOD) || string.equals(LOGOUT_METHOD)) {
                            if (objectArray2 == null) {
                                objectArray2 = objectArray3;
                            }
                        } else {
                            this.throwException((LoginException)objectArray2, (LoginException)objectArray3);
                        }
                    }
                    if (this.moduleStack[n].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                        if (debug != null) {
                            debug.println(string + " REQUIRED failure");
                        }
                        if (objectArray2 == null) {
                            objectArray2 = objectArray3;
                        }
                    }
                    if (debug != null) {
                        debug.println(string + " OPTIONAL failure");
                    }
                    if (objectArray != null) break block34;
                    objectArray = objectArray3;
                }
            }
            ++n;
        }
        if (objectArray2 != null) {
            this.throwException((LoginException)objectArray2, null);
        } else if (!bl && objectArray != null) {
            this.throwException((LoginException)objectArray, null);
        } else if (!bl) {
            this.throwException(new LoginException(rb.getString("Login Failure: all modules ignored")), null);
        } else {
            return;
        }
    }

    private class SecureCallbackHandler
    implements CallbackHandler {
        private final AccessControlContext acc;
        private final CallbackHandler ch;

        SecureCallbackHandler(AccessControlContext accessControlContext, CallbackHandler callbackHandler) {
            this.acc = accessControlContext;
            this.ch = callbackHandler;
        }

        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            try {
                Callback[] callbackArray2 = callbackArray;
                AccessController.doPrivileged(new PrivilegedExceptionAction(this, callbackArray2){
                    private final /* synthetic */ Callback[] val$finalCallbacks;
                    private final /* synthetic */ SecureCallbackHandler this$1;
                    {
                        this.this$1 = secureCallbackHandler;
                        this.val$finalCallbacks = callbackArray;
                    }

                    public Object run() throws IOException, UnsupportedCallbackException {
                        SecureCallbackHandler.access$100(this.this$1).handle(this.val$finalCallbacks);
                        return null;
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (UnsupportedCallbackException)privilegedActionException.getException();
            }
        }

        static /* synthetic */ CallbackHandler access$100(SecureCallbackHandler secureCallbackHandler) {
            return secureCallbackHandler.ch;
        }
    }
}

