/*
 * Decompiled with CFR 0.152.
 */
package flex.rds.server.servlet.internal;

import flex.messaging.MessageBroker;
import flex.messaging.config.ChannelSettings;
import flex.messaging.services.Service;
import flex.rds.server.servlet.internal.JavatoFiberTypeMap;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaIntrospectorUtil {
    public static boolean isPublicField(int modifiers) {
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
    }

    public static boolean isPublicAccessor(int modifiers) {
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    public static String getFiberEquivalentType(Type genericType, Class<?> class1) {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        if (JavatoFiberTypeMap.isJavaCollection(class1) && genericType instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()) != null && typeArguments.length == 1) {
            Class firstClassArgument;
            Type firstTypeArgument = typeArguments[0];
            if (firstTypeArgument instanceof ParameterizedType) {
                Class firstClassArgument2;
                ParameterizedType firstParametterizedTypeArgument = (ParameterizedType)firstTypeArgument;
                Type firstRawTypeArgument = firstParametterizedTypeArgument.getRawType();
                if (firstRawTypeArgument instanceof Class && !(firstClassArgument2 = (Class)firstRawTypeArgument).isArray() && !JavatoFiberTypeMap.isJavaCollection(firstClassArgument2)) {
                    return JavaIntrospectorUtil.getFiberEquivalentType(firstTypeArgument, firstClassArgument2) + "[]";
                }
            } else if (firstTypeArgument instanceof Class && !(firstClassArgument = (Class)firstTypeArgument).isArray() && !JavatoFiberTypeMap.isJavaCollection(firstClassArgument)) {
                return JavaIntrospectorUtil.getFiberEquivalentType(firstClassArgument) + "[]";
            }
        }
        return JavaIntrospectorUtil.getFiberEquivalentType(class1);
    }

    private static String getFiberEquivalentType(Class<?> class1) {
        if (class1.isArray() && !JavatoFiberTypeMap.contains(class1.getCanonicalName())) {
            if (class1.getComponentType().isArray() || JavatoFiberTypeMap.isJavaCollection(class1.getComponentType())) {
                return "opaque[]";
            }
            return JavaIntrospectorUtil.getFiberEquivalentType(class1.getComponentType()) + "[]";
        }
        if (JavatoFiberTypeMap.isJavaCollection(class1)) {
            return "opaque[]";
        }
        if (JavatoFiberTypeMap.isJavaMap(class1) || JavatoFiberTypeMap.isJavaDictionary(class1) || JavatoFiberTypeMap.isJavaDocument(class1)) {
            return "opaque";
        }
        if (JavatoFiberTypeMap.isJavaEnum(class1) || JavatoFiberTypeMap.isJavaBigDecimal(class1) || JavatoFiberTypeMap.isJavaBigInteger(class1)) {
            return "string";
        }
        if (JavatoFiberTypeMap.contains(class1.getCanonicalName())) {
            return JavatoFiberTypeMap.get(class1.getCanonicalName());
        }
        String fiberEquivalentFieldType = class1.getSimpleName();
        if (Character.isLowerCase(fiberEquivalentFieldType.charAt(0))) {
            fiberEquivalentFieldType = ("" + fiberEquivalentFieldType.charAt(0)).toUpperCase() + fiberEquivalentFieldType.substring(1, fiberEquivalentFieldType.length());
        }
        return fiberEquivalentFieldType;
    }

    public static boolean addToTypeSet(Class<?> class1, Set<Class<?>> typeSet) {
        if (class1 == null || JavatoFiberTypeMap.contains(class1.getCanonicalName()) || typeSet.contains(class1) || JavatoFiberTypeMap.isJavaCollection(class1) || JavatoFiberTypeMap.isJavaMap(class1) || JavatoFiberTypeMap.isJavaEnum(class1) || JavatoFiberTypeMap.isJavaBigDecimal(class1) || JavatoFiberTypeMap.isJavaBigInteger(class1) || JavatoFiberTypeMap.isJavaDictionary(class1) || JavatoFiberTypeMap.isJavaDocument(class1)) {
            return false;
        }
        if (class1.isArray()) {
            JavaIntrospectorUtil.addToTypeSet(class1.getComponentType(), typeSet);
        }
        typeSet.add(class1);
        return true;
    }

    public static String getDefaultChannels(MessageBroker messageBroker, String serviceId) {
        Service service = messageBroker.getService(serviceId);
        List defaultChannels = service.getDefaultChannels();
        StringBuilder uris = new StringBuilder();
        for (String defaultChannelUriString : defaultChannels) {
            ChannelSettings channelSettings = messageBroker.getChannelSettings(defaultChannelUriString);
            String channelUri = channelSettings.getUri();
            if (uris.length() != 0) continue;
            uris.append("<").append(channelUri).append("<").append(channelSettings.getClientType());
            return uris.toString();
        }
        return uris.toString();
    }
}

