/*
 * Decompiled with CFR 0.152.
 */
package flex.rds.server.servlet.internal;

import flex.messaging.Destination;
import flex.messaging.FactoryDestination;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.http.HTTPProxyDestination;
import flex.rds.server.servlet.internal.DestinationMetaData;
import flex.rds.server.servlet.internal.ServiceMetaData;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JavaDestinationReader {
    public static ServiceMetaData[] getAllServicesMetaData(MessageBroker broker) {
        ArrayList<ServiceMetaData> servicesMetaData = new ArrayList<ServiceMetaData>();
        ServiceMetaData remotingServiceMetaData = new ServiceMetaData("flex.messaging.services.RemotingService", "remoting-service");
        ServiceMetaData dataServiceMetaData = new ServiceMetaData("flex.data.DataService", "data-service");
        ServiceMetaData messagingServiceMetaData = new ServiceMetaData("flex.messaging.services.MessageService", "message-service");
        ServiceMetaData proxyServiceMetaData = new ServiceMetaData("flex.messaging.services.HTTPProxyService", "proxy-service");
        servicesMetaData.add(remotingServiceMetaData);
        servicesMetaData.add(dataServiceMetaData);
        servicesMetaData.add(messagingServiceMetaData);
        servicesMetaData.add(proxyServiceMetaData);
        if (broker != null) {
            for (ServiceMetaData serviceMetaData : servicesMetaData) {
                Map destinations;
                Iterator destinationsIterator;
                Service service = broker.getServiceByType(serviceMetaData.getServiceName());
                if (service == null || (destinationsIterator = (destinations = service.getDestinations()).keySet().iterator()) == null) continue;
                while (destinationsIterator.hasNext()) {
                    HTTPProxyDestination proxyDestination;
                    Destination destination = (Destination)destinations.get(destinationsIterator.next());
                    if (destination == null) continue;
                    DestinationMetaData destinationMetaData = new DestinationMetaData();
                    serviceMetaData.addDestinationMetaData(destinationMetaData);
                    List channelIdList = destination.getChannels();
                    for (String channelId : channelIdList) {
                        Endpoint endpoint = broker.getEndpoint(channelId);
                        String endPointUrl = null;
                        if (endpoint != null) {
                            endPointUrl = endpoint.getUrl();
                        }
                        if (endPointUrl == null || endPointUrl.equals("")) continue;
                        destinationMetaData.endPointUrl = endPointUrl;
                        break;
                    }
                    destinationMetaData.destinationId = destination.getId();
                    destinationMetaData.destinationClassType = destination.getClass().getName();
                    destinationMetaData.adapterId = destination.getAdapter().getId();
                    destinationMetaData.adapterName = destination.getAdapter().getClass().getName();
                    if (destination instanceof FactoryDestination) {
                        destinationMetaData.destinationSource = ((FactoryDestination)destination).getSource();
                        destinationMetaData.factoryType = ((FactoryDestination)destination).getFactory().getClass().getName();
                        continue;
                    }
                    if (!(destination instanceof HTTPProxyDestination) || (proxyDestination = (HTTPProxyDestination)destination).getDefaultUrl() == null) continue;
                    ServiceAdapter serviceAdapter = proxyDestination.getAdapter();
                    String adapterClassName = serviceAdapter.getClass().getName();
                    if (adapterClassName.equals("flex.messaging.services.http.HTTPProxyAdapter")) {
                        destinationMetaData.properties.put("url", proxyDestination.getDefaultUrl());
                        continue;
                    }
                    if (!adapterClassName.equals("flex.messaging.services.http.SOAPProxyAdapter")) continue;
                    destinationMetaData.properties.put("wsdl", proxyDestination.getDefaultUrl());
                }
            }
        }
        return servicesMetaData.toArray(new ServiceMetaData[0]);
    }

    public static String getDesinationsAsXMLString(ServiceMetaData[] servicesMetaDatas) {
        return JavaDestinationReader.createXML(servicesMetaDatas);
    }

    public static String getDesinationsAsXMLString(MessageBroker broker) {
        return JavaDestinationReader.createXML(JavaDestinationReader.getAllServicesMetaData(broker));
    }

    public static String createXML(ServiceMetaData[] serviceInfos) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<services>");
        for (ServiceMetaData serviceInfo : serviceInfos) {
            DestinationMetaData[] destinationsMetaData;
            stringBuilder.append("<service type=\"" + serviceInfo.getServiceName() + "\"" + " id=" + "\"" + serviceInfo.getServiceId() + "\"" + ">");
            stringBuilder.append("<destinations>");
            for (DestinationMetaData destinationMetaData : destinationsMetaData = serviceInfo.getDestinationsMetaData()) {
                stringBuilder.append("<destination>");
                stringBuilder.append("<id>" + destinationMetaData.destinationId + "</id>");
                stringBuilder.append("<destinationClassType>" + destinationMetaData.destinationClassType + "</destinationClassType>");
                stringBuilder.append("<destinationSource>" + destinationMetaData.destinationSource + "</destinationSource>");
                stringBuilder.append("<factoryType>" + destinationMetaData.factoryType + "</factoryType>");
                stringBuilder.append("<adapterId>" + destinationMetaData.adapterId + "</adapterId>");
                stringBuilder.append("<adapterName>" + destinationMetaData.adapterName + "</adapterName>");
                stringBuilder.append("<endPointUrl>" + destinationMetaData.endPointUrl + "</endPointUrl>");
                if (destinationMetaData.properties.size() > 0) {
                    Enumeration<?> enumeration = destinationMetaData.properties.propertyNames();
                    stringBuilder.append("<properties>");
                    while (enumeration.hasMoreElements()) {
                        String key = (String)enumeration.nextElement();
                        stringBuilder.append("<" + key + ">").append(destinationMetaData.properties.getProperty(key)).append("</" + key + ">");
                    }
                    stringBuilder.append("</properties>");
                }
                stringBuilder.append("</destination>");
            }
            stringBuilder.append("</destinations>");
            stringBuilder.append("</service>");
        }
        stringBuilder.append("</services>");
        return stringBuilder.toString();
    }
}

