/*
 * Decompiled with CFR 0.152.
 */
package flex.rds.server.servlet;

import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.rds.server.RdsHttpResponseFormatter;
import flex.rds.server.servlet.IRDSServletInit;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FrontEndServlet
extends HttpServlet {
    private static final long serialVersionUID = 1259366992083281022L;
    private Map _servlets = new HashMap();
    protected Logger logger;

    public void init() throws ServletException {
        this.logger = Log.getLogger((String)"RDS");
        Vector<String> initList = new Vector<String>();
        initList.add("flex.rds.server.servlet.BlazeRDSServletInit");
        initList.add("flex.rds.server.lcds.servlet.LCDSRDSServletInit");
        String extras = this.getServletConfig().getInitParameter("initServlets");
        if (extras != null) {
            StringTokenizer tokens = new StringTokenizer(extras, ",");
            while (tokens.hasMoreTokens()) {
                String test = tokens.nextToken().trim();
                if (test.length() <= 0) continue;
                initList.add(test);
            }
        }
        for (String initClass : initList) {
            try {
                Class<?> clazz = Class.forName(initClass);
                Object initObject = clazz.newInstance();
                if (initObject instanceof IRDSServletInit) {
                    Map<String, Class> map = ((IRDSServletInit)initObject).getServletCommandMap();
                    for (String servletCommand : map.keySet()) {
                        this.loadServlet(servletCommand, map.get(servletCommand));
                    }
                    continue;
                }
                this.logger.error("Unable to load RDS initClass (does not implement IRDSServletInit): " + initClass);
            }
            catch (ClassNotFoundException cnfe) {
                this.logger.error("Unable to load RDS initClass (ClassNotFoundException): " + initClass);
            }
            catch (IllegalAccessException iae) {
                this.logger.error("Unable to load RDS initClass (IllegalAccessException): " + initClass);
            }
            catch (InstantiationException instex) {
                this.logger.error("Unable to load RDS initClass (InstantiationException): " + initClass);
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String action = req.getParameter("ACTION");
            if (action == null) {
                throw new ServletException("Could not locate Action attribute in request, RDS operation not defined");
            }
            Servlet servlet = this.getServlet(action = action.toUpperCase());
            if (servlet == null) {
                throw new ServletException("Operation not supported: " + action);
            }
            servlet.service((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            Throwable tmpRoot = e;
            ServletException root = null;
            while (root == null) {
                if (tmpRoot instanceof ServletException) {
                    Throwable se = tmpRoot;
                    if (se.getRootCause() == null) {
                        root = se;
                        continue;
                    }
                    tmpRoot = se.getRootCause();
                    continue;
                }
                root = tmpRoot;
            }
            RdsHttpResponseFormatter rl = new RdsHttpResponseFormatter();
            rl.setError(e.getMessage(), root);
            resp.getOutputStream().write(rl.getMessageBytes());
            this.log("Error occured!:" + new String(rl.getMessageBytes()));
        }
        catch (Throwable th) {
            RdsHttpResponseFormatter rl = new RdsHttpResponseFormatter();
            rl.setError(th.getMessage(), th);
            resp.getOutputStream().write(rl.getMessageBytes());
            this.log("Error occured!:" + new String(rl.getMessageBytes()));
            this.logger.error(th.getMessage(), th);
        }
    }

    public void destroy() {
        for (Object o : this._servlets.keySet()) {
            String name = (String)o;
            Servlet s = (Servlet)this._servlets.get(name);
            s.destroy();
        }
    }

    private Servlet getServlet(String action) {
        return (Servlet)this._servlets.get(action);
    }

    private void loadServlet(String name, Class cls) throws ServletException {
        try {
            Servlet s = (Servlet)cls.newInstance();
            s.init(this.getServletConfig());
            this._servlets.put(name.toUpperCase(), s);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

