/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.runtime.messaging.endpoints.HTTPEndpointControl;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.BasePollingHTTPEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.endpoints.amf.BatchProcessFilter;
import flex.messaging.endpoints.amf.MessageBrokerFilter;
import flex.messaging.endpoints.amf.SerializationFilter;
import flex.messaging.endpoints.amf.SessionFilter;
import flex.messaging.messages.Message;

public class HTTPEndpoint
extends BasePollingHTTPEndpoint {
    public static final String LOG_CATEGORY = "Endpoint.HTTP";

    public HTTPEndpoint() {
        this(false);
    }

    public HTTPEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    public Message convertToSmallMessage(Message message) {
        return message;
    }

    protected AMFFilter createFilterChain() {
        SerializationFilter serializationFilter = new SerializationFilter(this.getLogCategory());
        BatchProcessFilter batchFilter = new BatchProcessFilter();
        SessionFilter sessionFilter = new SessionFilter();
        MessageBrokerFilter messageBrokerFilter = new MessageBrokerFilter(this);
        serializationFilter.setNext(batchFilter);
        batchFilter.setNext(sessionFilter);
        sessionFilter.setNext(messageBrokerFilter);
        return serializationFilter;
    }

    protected String getResponseContentType() {
        return "application/xml";
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected String getDeserializerClassName() {
        return "flex.messaging.io.amfx.AmfxMessageDeserializer";
    }

    protected String getSerializerClassName() {
        return "flex.messaging.io.amfx.AmfxMessageSerializer";
    }

    protected void setupEndpointControl(MessageBroker broker) {
        this.controller = new HTTPEndpointControl(this, broker.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }
}

