/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.management.runtime.messaging.MessageDestinationControl;
import flex.management.runtime.messaging.services.messaging.SubscriptionManagerControl;
import flex.management.runtime.messaging.services.messaging.ThrottleManagerControl;
import flex.messaging.Destination;
import flex.messaging.FactoryDestination;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.NetworkSettings;
import flex.messaging.config.ServerSettings;
import flex.messaging.config.ThrottleSettings;
import flex.messaging.services.MessageService;
import flex.messaging.services.Service;
import flex.messaging.services.messaging.RemoteSubscriptionManager;
import flex.messaging.services.messaging.SubscriptionManager;
import flex.messaging.services.messaging.ThrottleManager;
import flex.messaging.util.ClassUtil;

public class MessageDestination
extends FactoryDestination {
    static final long serialVersionUID = -2016911808141319012L;
    public static final String LOG_CATEGORY = "Service.Message";
    private static final int UNSUPPORTED_POLICY = 10124;
    private ServerSettings serverSettings = new ServerSettings();
    private SubscriptionManager subscriptionManager = new SubscriptionManager(this);
    private RemoteSubscriptionManager remoteSubscriptionManager = new RemoteSubscriptionManager(this);
    private ThrottleManager throttleManager;
    private MessageDestinationControl controller;

    public MessageDestination() {
        this(false);
    }

    public MessageDestination(boolean enableManagement) {
        super(enableManagement);
    }

    public void initialize(String id, ConfigMap properties) {
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.network(properties);
        this.server(properties);
    }

    public void start() {
        ThrottleSettings settings;
        if (this.networkSettings.getThrottleSettings() != null && ((settings = this.networkSettings.getThrottleSettings()).isClientThrottleEnabled() || settings.isDestinationThrottleEnabled())) {
            settings.setDestinationName(this.getId());
            this.throttleManager = this.createThrottleManager();
            this.throttleManager.setThrottleSettings(settings);
            this.throttleManager.start();
        }
        super.start();
    }

    public void stop() {
        if (this.isStarted()) {
            this.subscriptionManager.stop();
            this.remoteSubscriptionManager.stop();
            if (this.throttleManager != null) {
                this.throttleManager.stop();
            }
        }
        super.stop();
    }

    public void setNetworkSettings(NetworkSettings networkSettings) {
        super.setNetworkSettings(networkSettings);
        if (networkSettings.getSubscriptionTimeoutMinutes() > 0) {
            long subscriptionTimeoutMillis = networkSettings.getSubscriptionTimeoutMinutes() * 60 * 1000;
            this.subscriptionManager.setSubscriptionTimeoutMillis(subscriptionTimeoutMillis);
        }
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public void setService(Service service) {
        MessageService messageService = (MessageService)service;
        super.setService(messageService);
    }

    public ConfigMap describeDestination(boolean onlyReliable) {
        ConfigMap network;
        ConfigMap destinationConfig = super.describeDestination(onlyReliable);
        if (destinationConfig == null) {
            return null;
        }
        if (this.throttleManager == null) {
            return destinationConfig;
        }
        ThrottleSettings.Policy outboundPolicy = this.throttleManager.getOutboundPolicy();
        if (outboundPolicy == null || outboundPolicy == ThrottleSettings.Policy.NONE) {
            return destinationConfig;
        }
        ConfigMap properties = destinationConfig.getPropertyAsMap("properties", null);
        if (properties == null) {
            properties = new ConfigMap();
            destinationConfig.addProperty("properties", properties);
        }
        if ((network = properties.getPropertyAsMap("network", null)) == null) {
            network = new ConfigMap();
            properties.addProperty("network", network);
        }
        ConfigMap throttleOutbound = new ConfigMap();
        throttleOutbound.addProperty("policy", this.throttleManager.getOutboundPolicy().toString());
        network.addProperty("throttle-outbound", throttleOutbound);
        return destinationConfig;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public RemoteSubscriptionManager getRemoteSubscriptionManager() {
        return this.remoteSubscriptionManager;
    }

    public ThrottleManager getThrottleManager() {
        return this.throttleManager;
    }

    public boolean equals(Object o) {
        if (o instanceof Destination) {
            Destination d = (Destination)o;
            return d.getServiceType().equals(this.getServiceType()) && d.getId().equals(this.getId());
        }
        return false;
    }

    public int hashCode() {
        return (this.getServiceType() == null ? 0 : this.getServiceType().hashCode()) * 100003 + (this.getId() == null ? 0 : this.getId().hashCode());
    }

    public String toString() {
        return this.getServiceType() + "#" + this.getId();
    }

    protected ThrottleManager createThrottleManager() {
        Service service = this.getService();
        if (service == null || service.getMessageBroker() == null) {
            return new ThrottleManager();
        }
        try {
            Class<? extends ThrottleManager> throttleManagerClass = service.getMessageBroker().getThrottleManagerClass();
            Object instance = ClassUtil.createDefaultInstance(throttleManagerClass, null);
            if (instance instanceof ThrottleManager) {
                return (ThrottleManager)instance;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ThrottleManager();
    }

    protected void network(ConfigMap properties) {
        ConfigMap network = properties.getPropertyAsMap("network", null);
        if (network == null) {
            return;
        }
        NetworkSettings ns = this.getNetworkSettings();
        int useLegacyPropertyToken = -999999;
        int subscriptionTimeoutMinutes = network.getPropertyAsInt("subscription-timeout-minutes", useLegacyPropertyToken);
        if (subscriptionTimeoutMinutes == useLegacyPropertyToken) {
            subscriptionTimeoutMinutes = network.getPropertyAsInt("session-timeout", 0);
        }
        ns.setSubscriptionTimeoutMinutes(subscriptionTimeoutMinutes);
        ThrottleSettings ts = ns.getThrottleSettings();
        ts.setDestinationName(this.getId());
        this.throttle(ts, network);
        this.setNetworkSettings(ns);
    }

    protected void throttle(ThrottleSettings ts, ConfigMap network) {
        ConfigMap outbound;
        ConfigMap inbound = network.getPropertyAsMap("throttle-inbound", null);
        if (inbound != null) {
            ThrottleSettings.Policy policy = this.getPolicyFromThrottleSettings(inbound);
            ts.setInboundPolicy(policy);
            int destFreq = inbound.getPropertyAsInt("max-frequency", 0);
            ts.setIncomingDestinationFrequency(destFreq);
            int clientFreq = inbound.getPropertyAsInt("max-client-frequency", 0);
            ts.setIncomingClientFrequency(clientFreq);
        }
        if ((outbound = network.getPropertyAsMap("throttle-outbound", null)) != null) {
            ThrottleSettings.Policy policy = this.getPolicyFromThrottleSettings(outbound);
            ts.setOutboundPolicy(policy);
            int destFreq = outbound.getPropertyAsInt("max-frequency", 0);
            ts.setOutgoingDestinationFrequency(destFreq);
            int clientFreq = outbound.getPropertyAsInt("max-client-frequency", 0);
            ts.setOutgoingClientFrequency(clientFreq);
        }
    }

    private ThrottleSettings.Policy getPolicyFromThrottleSettings(ConfigMap settings) {
        String policyString = settings.getPropertyAsString("policy", null);
        ThrottleSettings.Policy policy = ThrottleSettings.Policy.NONE;
        if (policyString == null) {
            return policy;
        }
        try {
            policy = ThrottleSettings.parsePolicy(policyString);
        }
        catch (ConfigurationException exception) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(10124, new Object[]{this.getId(), policyString});
            throw ce;
        }
        return policy;
    }

    protected void server(ConfigMap properties) {
        ConfigMap server = properties.getPropertyAsMap("server", null);
        if (server == null) {
            return;
        }
        long ttl = server.getPropertyAsLong("message-time-to-live", -1L);
        this.serverSettings.setMessageTTL(ttl);
        boolean durable = server.getPropertyAsBoolean("durable", false);
        this.serverSettings.setDurable(durable);
        boolean allowSubtopics = server.getPropertyAsBoolean("allow-subtopics", false);
        this.serverSettings.setAllowSubtopics(allowSubtopics);
        boolean disallowWildcardSubtopics = server.getPropertyAsBoolean("disallow-wildcard-subtopics", false);
        this.serverSettings.setDisallowWildcardSubtopics(disallowWildcardSubtopics);
        int priority = server.getPropertyAsInt("message-priority", -1);
        if (priority != -1) {
            this.serverSettings.setPriority(priority);
        }
        String subtopicSeparator = server.getPropertyAsString("subtopic-separator", ".");
        this.serverSettings.setSubtopicSeparator(subtopicSeparator);
        String routingMode = server.getPropertyAsString("cluster-message-routing", "server-to-server");
        this.serverSettings.setBroadcastRoutingMode(routingMode);
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected void setupDestinationControl(Service service) {
        this.controller = new MessageDestinationControl(this, service.getControl());
        this.controller.register();
        this.setControl(this.controller);
        this.setupThrottleManagerControl(this.controller);
        this.setupSubscriptionManagerControl(this.controller);
    }

    protected void setupThrottleManagerControl(MessageDestinationControl destinationControl) {
        if (this.throttleManager != null) {
            ThrottleManagerControl throttleManagerControl = new ThrottleManagerControl(this.throttleManager, destinationControl);
            throttleManagerControl.register();
            this.throttleManager.setControl(throttleManagerControl);
            this.throttleManager.setManaged(true);
            destinationControl.setThrottleManager(throttleManagerControl.getObjectName());
        }
    }

    private void setupSubscriptionManagerControl(MessageDestinationControl destinationControl) {
        SubscriptionManagerControl subscriptionManagerControl = new SubscriptionManagerControl(this.getSubscriptionManager(), destinationControl);
        subscriptionManagerControl.register();
        this.getSubscriptionManager().setControl(subscriptionManagerControl);
        this.getSubscriptionManager().setManaged(true);
        destinationControl.setSubscriptionManager(subscriptionManagerControl.getObjectName());
    }
}

