/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;

public class TypeHintContext {
    private ConverterManager converterManager;
    private String cachedToString = null;
    private final Method method;
    private final int parameterNumber;
    private final Object parameterType;
    private final List parameterNumberTree;
    private final List parameterTypeTree;
    private static final Logger log;
    private static final Class parameterizedTypeClass;
    private static final Method getGenericParameterTypesMethod;
    private static final Method getActualTypeArgumentsMethod;
    private static final Method getRawTypeMethod;
    private static final boolean isGenericsSupported;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$directwebremoting$extend$TypeHintContext;
    static /* synthetic */ Class class$java$lang$reflect$Method;

    public TypeHintContext(ConverterManager converterManager, Method method, int parameterNumber) {
        if (method == null) {
            throw new IllegalArgumentException("The method can not be null");
        }
        this.converterManager = converterManager;
        this.method = method;
        this.parameterNumber = parameterNumber;
        Object[] types = (Object[])LocalUtil.invoke(method, getGenericParameterTypesMethod, new Object[0]);
        if (types != null) {
            if (parameterNumber >= types.length) {
                throw new IllegalArgumentException("parameterNumber=" + parameterNumber + " is too big when method=" + method.getName() + " returns genericParameterTypes.length=" + types.length);
            }
            this.parameterType = types[parameterNumber];
        } else {
            this.parameterType = null;
        }
        this.parameterNumberTree = new ArrayList();
        this.parameterTypeTree = new ArrayList();
    }

    private TypeHintContext(ConverterManager manager, Method method, int parameterNumber, Object parameterType) {
        this.converterManager = manager;
        this.method = method;
        this.parameterNumber = parameterNumber;
        this.parameterType = parameterType;
        this.parameterNumberTree = new ArrayList();
        this.parameterTypeTree = new ArrayList();
    }

    public TypeHintContext createChildContext(int newParameterNumber) {
        Object childType = null;
        if (isGenericsSupported && parameterizedTypeClass.isInstance(this.parameterType)) {
            Object ptype = this.parameterType;
            Object[] actualTypeArguments = (Object[])LocalUtil.invoke(ptype, getActualTypeArgumentsMethod, new Object[0]);
            if (newParameterNumber >= actualTypeArguments.length) {
                throw new IllegalArgumentException("newParameterNumber=" + newParameterNumber + " is too big when parameterType=" + this.parameterType + " give actualTypeArguments.length=" + actualTypeArguments.length);
            }
            childType = actualTypeArguments[newParameterNumber];
        }
        TypeHintContext child = new TypeHintContext(this.converterManager, this.method, this.parameterNumber, childType);
        child.parameterNumberTree.addAll(this.parameterNumberTree);
        child.parameterNumberTree.add(new Integer(newParameterNumber));
        child.parameterTypeTree.addAll(this.parameterTypeTree);
        child.parameterTypeTree.add(this.parameterType);
        return child;
    }

    public Class getExtraTypeInfo() {
        Class type = null;
        if (this.converterManager != null && (type = this.converterManager.getExtraTypeInfo(this)) != null) {
            log.debug("Using type info from <signature> " + this.toString() + " of " + type);
            return type;
        }
        if (isGenericsSupported) {
            if (parameterizedTypeClass.isInstance(this.parameterType)) {
                Object ptype = this.parameterType;
                Object rawType = LocalUtil.invoke(ptype, getRawTypeMethod, new Object[0]);
                if (rawType instanceof Class) {
                    type = (Class)rawType;
                    log.debug("Using type info from JDK5 ParameterizedType of " + type.getName() + " for " + this.toString());
                    return type;
                }
            } else if (this.parameterType instanceof Class) {
                type = (Class)this.parameterType;
                log.debug("Using type info from JDK5 reflection of " + type.getName() + " for " + this.toString());
                return type;
            }
        }
        log.warn("Missing type info for " + this.toString() + ". Assuming this is a map with String keys. Please add to <signatures> in dwr.xml");
        return class$java$lang$String == null ? (class$java$lang$String = TypeHintContext.class$("java.lang.String")) : class$java$lang$String;
    }

    public int hashCode() {
        return this.method.hashCode() + this.parameterNumber + ((Object)this.parameterNumberTree).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TypeHintContext that = (TypeHintContext)obj;
        if (!this.method.equals(that.method)) {
            return false;
        }
        if (this.parameterNumber != that.parameterNumber) {
            return false;
        }
        return ((Object)this.parameterNumberTree).equals(that.parameterNumberTree);
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.method.getName());
            buffer.append('(');
            buffer.append(this.parameterNumber);
            Iterator it = this.parameterNumberTree.iterator();
            while (it.hasNext()) {
                buffer.append('<');
                buffer.append(it.next());
            }
            it = this.parameterNumberTree.iterator();
            while (it.hasNext()) {
                buffer.append('>');
                it.next();
            }
            buffer.append(')');
            this.cachedToString = buffer.toString();
        }
        return this.cachedToString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class tempParameterizedTypeClass;
        log = Logger.getLogger(class$org$directwebremoting$extend$TypeHintContext == null ? (class$org$directwebremoting$extend$TypeHintContext = TypeHintContext.class$("org.directwebremoting.extend.TypeHintContext")) : class$org$directwebremoting$extend$TypeHintContext);
        int failures = 0;
        try {
            tempParameterizedTypeClass = LocalUtil.classForName("java.lang.reflect.ParameterizedType");
            log.debug("JDK1.5 reflection available.");
        }
        catch (Exception ex) {
            tempParameterizedTypeClass = null;
            log.debug("JDK1.5 reflection not available. Generic parameters must use <signatures>.");
            ++failures;
        }
        Method tempGetGenericParameterTypesMethod = null;
        try {
            tempGetGenericParameterTypesMethod = (class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = TypeHintContext.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method).getDeclaredMethod("getGenericParameterTypes", new Class[0]);
        }
        catch (Exception ex) {
            log.debug("Error finding Method.getGenericParameterTypes(): JDK1.5 reflection not available.");
            ++failures;
        }
        catch (Error er) {
            log.error("If you see this stack trace please report it to the DWR users mailing list", er);
        }
        Method tempGetActualTypeArgumentsMethod = null;
        try {
            if (tempParameterizedTypeClass != null) {
                tempGetActualTypeArgumentsMethod = tempParameterizedTypeClass.getDeclaredMethod("getActualTypeArguments", new Class[0]);
            }
        }
        catch (Exception ex) {
            log.debug("Error finding ParameterizedType.getActualTypeArguments(): JDK1.5 reflection not available.");
            ++failures;
        }
        Method tempGetRawTypeMethod = null;
        try {
            if (tempParameterizedTypeClass != null) {
                tempGetRawTypeMethod = tempParameterizedTypeClass.getDeclaredMethod("getRawType", new Class[0]);
            }
        }
        catch (Exception ex) {
            log.debug("Error finding ParameterizedType.getRawType(): JDK1.5 reflection not available.");
            ++failures;
        }
        if (failures == 0) {
            isGenericsSupported = true;
            parameterizedTypeClass = tempParameterizedTypeClass;
            getGenericParameterTypesMethod = tempGetGenericParameterTypesMethod;
            getActualTypeArgumentsMethod = tempGetActualTypeArgumentsMethod;
            getRawTypeMethod = tempGetRawTypeMethod;
        } else {
            isGenericsSupported = false;
            parameterizedTypeClass = null;
            getGenericParameterTypesMethod = null;
            getActualTypeArgumentsMethod = null;
            getRawTypeMethod = null;
        }
    }
}

