/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.javaParser;

public class Token {
    public String value;
    public Position from = new Position(1, 1);
    public Position to = new Position(1, 1);
    public int fromIndex;
    public int toIndex;
    public int type;
    public Token next;
    public static final int NONE = 700;
    public static final int WHITE = 750;
    public static final int COMMENT = 751;
    public static final int STRING = 752;
    public static final int CHAR = 753;
    public static final int IDENT = 754;
    public static final int OTHER = 755;
    public static final int EOF = 799;

    public String toString() {
        return "[Token." + this.typeString() + ":\"" + this.value + "\" at " + this.from + " to " + this.to + "]";
    }

    public String typeString() {
        switch (this.type) {
            case 700: {
                return "NONE    ";
            }
            case 750: {
                return "WHITE   ";
            }
            case 751: {
                return "COMMENT ";
            }
            case 752: {
                return "STRING  ";
            }
            case 753: {
                return "CHAR    ";
            }
            case 754: {
                return "IDENT   ";
            }
            case 755: {
                return "OTHER   ";
            }
            case 799: {
                return "EOF     ";
            }
        }
        return "???     ";
    }

    public static class ListIterator
    implements Iterator {
        private Token current;
        private boolean started;

        public ListIterator(Token token) {
            this.current = token;
        }

        public Token getCurrentToken() {
            return this.current;
        }

        public Token getNextRelevantToken() {
            do {
                this.current = this.getNextToken();
            } while (this.current.type == 750 || this.current.type == 751);
            return this.current;
        }

        public Token getNextToken() {
            if (this.started) {
                this.current = this.current.next;
            } else {
                this.started = true;
            }
            return this.current;
        }
    }

    public static interface Iterator {
        public Token getCurrentToken();

        public Token getNextToken();

        public Token getNextRelevantToken();
    }

    public static class Position {
        public int line;
        public int column;

        public Position(int n, int n2) {
            this.line = n;
            this.column = n2;
        }

        public boolean equals(Object object) {
            return object instanceof Position && ((Position)object).line == this.line && ((Position)object).column == this.column;
        }

        public int hashCode() {
            return this.line ^ this.column << 7;
        }

        public String toString() {
            return this.line + "/" + this.column;
        }
    }
}

