/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.parser.compiler141;

import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Position;
import com.tombrus.cleanImports.parser.Cleaner;
import com.tombrus.javaParser.ProgressKeeper;
import com.tombrus.javaParser.Span;
import com.tombrus.javaParser.SpanDoctor;
import com.tombrus.javaParser.Token;
import com.tombrus.javaParser.compiler141.ProgressKeeperHolder;
import com.tombrus.javaParser.compiler141.VisitorUtils;
import com.tombrus.util.DB;
import com.tombrus.util.InternalProblem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CleanerPass1
extends Tree.Visitor
implements Flags,
Runnable {
    public boolean DEBUG;
    private Cleaner cleaner;
    private ProgressKeeper progressKeeper;
    private List trees;
    private Name.Table nameTable;
    private Set allScopes = new HashSet();
    private Tree.TopLevel currTopLevel;
    private String currClassName;
    private String currFullClassName;
    private Tree.ClassDef currClassDef;
    private SpanDoctor spanDoctor;
    private HashSet reportedVarDefs;

    public CleanerPass1(Cleaner cleaner, Object object, Object object2) {
        this.cleaner = cleaner;
        this.progressKeeper = ProgressKeeperHolder.ProgressKeeperInstance((Context)object);
        this.trees = (List)object2;
        this.nameTable = Name.Table.instance((Context)((Context)object));
    }

    public void run() {
        this.visitOneList(this.trees);
        Iterator iterator = this.allScopes.iterator();
        while (iterator.hasNext()) {
            Scope scope = (Scope)iterator.next();
            String string = scope.owner.fullName().toString();
            Set set = CleanerPass1.getClassSymbolsFromScope(scope);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)iterator2.next();
                if (classSymbol.owner != scope.owner) continue;
                this.cleaner.packageContents(string, classSymbol.name.toString());
            }
        }
    }

    private static Set getClassSymbolsFromScope(Scope scope) {
        HashSet<Symbol> hashSet = new HashSet<Symbol>();
        Scope.Entry entry = scope.elems;
        while (entry != null) {
            if (entry.sym != null && entry.sym instanceof Symbol.ClassSymbol) {
                hashSet.add(entry.sym);
            }
            entry = entry.sibling;
        }
        return hashSet;
    }

    private void visitOneTree(Tree tree) {
        if (tree != null) {
            tree.accept((Tree.Visitor)this);
        }
    }

    private void visitOneList(List list) {
        while (list != null && list.nonEmpty()) {
            this.visitOneTree((Tree)list.head);
            list = list.tail;
        }
    }

    private SpanDoctor getSpanDoctor() {
        if (this.spanDoctor == null) {
            if (this.currTopLevel == null || this.currTopLevel.sourcefile == null) {
                throw new TreeProblem("spanDoctor required while no file.");
            }
            this.spanDoctor = new SpanDoctor(8, this.currTopLevel.sourcefile.toString(), new SpanDoctor.BugCorrector(){

                public void correctForCompilerBug(Token token) {
                    int n;
                    if ((token.type == 752 || token.type == 753) && token.to.column != token.from.column + (n = token.value.length())) {
                        token.to.column = token.from.column + n;
                    }
                }
            });
        }
        return this.spanDoctor;
    }

    private Span getNameSpan(Tree tree) throws TreeProblem {
        return this.getNameSpan(tree, this.getStringFromTree(tree));
    }

    private Span getNameSpan(Tree tree, String string) throws TreeProblem {
        int n = this.getPosFromTree(tree);
        return this.getSpanDoctor().getSpan(Position.line((int)n), Position.column((int)n), string);
    }

    private void classDependency(Tree tree) {
        if (tree != null) {
            try {
                if (tree instanceof Tree.Select) {
                    Tree.Select select = (Tree.Select)tree;
                    this.classDependency(tree, select.sym);
                } else if (tree instanceof Tree.Ident) {
                    Tree.Ident ident = (Tree.Ident)tree;
                    this.classDependency(tree, ident.sym);
                } else if (tree instanceof Tree.VarDef) {
                    Tree.VarDef varDef = (Tree.VarDef)tree;
                    this.classDependency(varDef.vartype);
                } else if (tree instanceof Tree.TypeArray) {
                    Tree.TypeArray typeArray = (Tree.TypeArray)tree;
                    this.classDependency(typeArray.elemtype);
                } else if (tree instanceof Tree.Parens) {
                    Tree.Parens parens = (Tree.Parens)tree;
                    this.classDependency(parens.expr);
                } else if (!(tree instanceof Tree.TypeIdent)) {
                    new TreeProblem("tree should be a Select/Ident/TypeIdent/TypeArray but it is " + tree.getClass() + ".").report();
                }
            }
            catch (TreeProblem treeProblem) {
                treeProblem.report();
            }
        }
    }

    private void classDependency(Tree tree, Symbol symbol) throws TreeProblem {
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
            if (VisitorUtils.isVisibleFromTheOutside(symbol)) {
                String string = classSymbol.name.toString();
                String string2 = this.fullName((Symbol)classSymbol);
                String string3 = this.getPackageFromSymbol(classSymbol);
                String string4 = classSymbol.classfile == null ? null : classSymbol.classfile.getPath();
                this.cleaner.classDependency(this.currFullClassName, this.currClassName, string2, string, this.getStringFromTree(tree), string3, this.getNameSpan(tree), string4, this.noSuchType((Symbol)classSymbol));
                this.allScopes.add(classSymbol.owner.members());
            }
        } else {
            throw new TreeProblem("dependency on non-ClassSymbol: " + symbol.getClass() + ".");
        }
    }

    private int getPosFromTree(Tree tree) throws TreeProblem {
        final int[] nArray = new int[]{Integer.MAX_VALUE};
        tree.accept(new Tree.Visitor(){

            public void visitSelect(Tree.Select select) {
                this.acceptBetter(select.pos);
                select.selected.accept((Tree.Visitor)this);
            }

            public void visitIdent(Tree.Ident ident) {
                this.acceptBetter(ident.pos);
            }

            public void visitClassDef(Tree.ClassDef classDef) {
                this.acceptBetter(classDef.pos);
            }

            public void visitImport(Tree.Import import_) {
                this.acceptBetter(import_.pos);
            }

            public void visitMethodDef(Tree.MethodDef methodDef) {
                this.acceptBetter(methodDef.pos);
            }

            public void visitParens(Tree.Parens parens) {
                this.acceptBetter(parens.pos);
                parens.expr.accept((Tree.Visitor)this);
            }

            private void acceptBetter(int n) {
                if (n < nArray[0]) {
                    nArray[0] = n;
                }
            }
        });
        if (nArray[0] == Integer.MAX_VALUE) {
            throw new TreeProblem("can not deduce correct span from " + tree);
        }
        return nArray[0];
    }

    private String getStringFromTree(Tree tree) throws TreeProblem {
        return this.getStringFromTree(tree, new StringBuffer()).toString();
    }

    private StringBuffer getStringFromTree(Tree tree, StringBuffer stringBuffer) throws TreeProblem {
        if (tree instanceof Tree.Ident) {
            Tree.Ident ident = (Tree.Ident)tree;
            stringBuffer.append(ident.name);
        } else if (tree instanceof Tree.Select) {
            Tree.Select select = (Tree.Select)tree;
            this.getStringFromTree(select.selected, stringBuffer).append(".").append(select.name);
        } else if (tree instanceof Tree.Import) {
            Tree.Import import_ = (Tree.Import)tree;
            this.getStringFromTree(import_.qualid, stringBuffer.append("import ")).append(";");
        } else if (tree instanceof Tree.Parens) {
            Tree.Parens parens = (Tree.Parens)tree;
            this.getStringFromTree(parens.expr, stringBuffer.append("(")).append(")");
        } else {
            throw new TreeProblem("tree should be a Select/Ident/Import but it is " + tree.getClass() + ".");
        }
        return stringBuffer;
    }

    private String fullName(Symbol symbol) {
        return symbol.fullName().toString();
    }

    private String getPackageFromSymbol(Symbol.ClassSymbol classSymbol) {
        String string = classSymbol.flatName().toString();
        int n = string.lastIndexOf(".");
        string = n == -1 ? "" : string.substring(0, n);
        return string;
    }

    private boolean noSuchType(Symbol symbol) {
        if (symbol instanceof Symbol.TypeSymbol) {
            Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)symbol;
            return typeSymbol.type.isErroneous() || !typeSymbol.exists();
        }
        return false;
    }

    public void visitTopLevel(Tree.TopLevel topLevel) {
        this.DEBUG = DB.ONE(topLevel.sourcefile.toString());
        this.progressKeeper.progress(topLevel.sourcefile.toString());
        SpanDoctor spanDoctor = this.spanDoctor;
        Tree.TopLevel topLevel2 = this.currTopLevel;
        this.spanDoctor = null;
        this.currTopLevel = topLevel;
        String string = topLevel.sourcefile.toString();
        String string2 = topLevel.pid == null ? "" : this.fullName((Symbol)topLevel.packge);
        this.cleaner.fileStart(string, string2);
        this.allScopes.add(topLevel.packge.members());
        this.reportedVarDefs = null;
        this.visitOneList(topLevel.defs);
        this.currTopLevel = topLevel2;
        this.spanDoctor = spanDoctor;
    }

    public void visitImport(Tree.Import import_) {
    }

    public void visitClassDef(Tree.ClassDef classDef) {
        Tree.ClassDef classDef2 = this.currClassDef;
        String string = this.currClassName;
        String string2 = this.currFullClassName;
        this.currClassDef = classDef;
        this.currClassName = this.currClassDef.sym.name.toString();
        this.currFullClassName = classDef.sym.toJava();
        this.currClassName = CleanerPass1.getLastBit(this.currFullClassName);
        Map map = this.gatherVisibleInners((Type.ClassType)classDef.type);
        this.cleaner.classStart(this.currFullClassName, map);
        this.visitOneTree(classDef.extending);
        this.visitOneList(classDef.implementing);
        this.visitOneList(classDef.defs);
        this.currFullClassName = string2;
        this.currClassName = string;
        this.currClassDef = classDef2;
    }

    static String getLastBit(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private Map gatherVisibleInners(Type.ClassType classType) {
        if (this.DEBUG) {
            System.err.println("++++ " + classType);
        }
        HashMap hashMap = new HashMap();
        this.gatherVisibleInnersOfSupersAndInterfaces(">SUPER>", classType, hashMap);
        this.gatherVisibleInnersOfOuters(classType, hashMap);
        return hashMap;
    }

    private void gatherVisibleInnersOfSupersAndInterfaces(String string, Type.ClassType classType, Map map) {
        Type.ClassType classType2 = classType;
        while (classType2 != null && classType2 instanceof Type.ClassType && classType2.tsym.fullName() != this.nameTable.java_lang_Object) {
            this.enterAllClassesInScope(string, classType2.tsym.members(), map);
            if (classType2 != classType) {
                this.gatherVisibleInnersOfSupersAndInterfaces(string + "E>", classType2, map);
            }
            classType2 = classType2.supertype();
        }
        List list = classType.interfaces();
        while (list != null && list.nonEmpty()) {
            Object object = list.head;
            if (object instanceof Type.ClassType) {
                this.gatherVisibleInnersOfSupersAndInterfaces(string + "I>", (Type.ClassType)object, map);
            }
            list = list.tail;
        }
    }

    private void gatherVisibleInnersOfOuters(Type.ClassType classType, Map map) {
        Symbol symbol = classType.tsym.owner;
        while (symbol != null && !(symbol instanceof Symbol.PackageSymbol)) {
            if (symbol instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                if (classSymbol.type instanceof Type.ClassType) {
                    this.gatherVisibleInnersOfSupersAndInterfaces(">OUTER>", (Type.ClassType)classSymbol.type, map);
                } else {
                    this.enterAllClassesInScope(">outer>", classSymbol.members(), map);
                }
            }
            symbol = symbol.owner;
        }
    }

    private void enterAllClassesInScope(String string, Scope scope, Map map) {
        Scope.Entry entry = scope.elems;
        while (entry != null && entry.sym != null) {
            if (entry.sym instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)entry.sym;
                String string2 = classSymbol.name.toString();
                if (!map.containsKey(string2)) {
                    map.put(string2, classSymbol.fullName().toString());
                    if (this.DEBUG) {
                        System.err.println(string + "  ----- " + classSymbol + " [" + classSymbol.getClass().getName() + "]");
                    }
                } else if (this.DEBUG) {
                    System.err.println(string + "  -DUP- " + classSymbol + " [" + classSymbol.getClass().getName() + "]");
                }
            }
            entry = entry.sibling;
        }
    }

    public void visitMethodDef(Tree.MethodDef methodDef) {
        if ((methodDef.flags & 0x10000L) == 0L) {
            boolean bl;
            boolean bl2 = this.currClassDef.sym == null || this.currClassDef.sym.name == this.nameTable.empty;
            boolean bl3 = methodDef.pos == this.currClassDef.pos && !bl2;
            boolean bl4 = bl = methodDef.name == this.nameTable.init;
            if (!(bl3 || methodDef.sym == null || bl2 && bl)) {
                this.visitOneTree(methodDef.restype);
                this.visitOneList(methodDef.params);
                this.visitOneList(methodDef.thrown);
                this.visitOneTree((Tree)methodDef.body);
            }
        }
    }

    public void visitVarDef(Tree.VarDef varDef) {
        if ((varDef.flags & 0x10000L) == 0L) {
            this.visitOneTree(varDef.vartype);
            this.visitOneTree(varDef.init);
        }
    }

    public void visitSelect(Tree.Select select) {
        if (select.sym != null && select.sym instanceof Symbol.ClassSymbol) {
            this.classDependency((Tree)select);
        }
        this.visitOneTree(select.selected);
    }

    public void visitIdent(Tree.Ident ident) {
        if (ident.sym != null && ident.sym instanceof Symbol.ClassSymbol) {
            this.classDependency((Tree)ident);
        }
    }

    public void visitSkip(Tree.Skip skip) {
    }

    public void visitBlock(Tree.Block block) {
        this.visitOneList(block.stats);
    }

    public void visitDoLoop(Tree.DoLoop doLoop) {
        this.visitOneTree(doLoop.cond);
        this.visitOneTree(doLoop.body);
    }

    public void visitWhileLoop(Tree.WhileLoop whileLoop) {
        this.visitOneTree(whileLoop.cond);
        this.visitOneTree(whileLoop.body);
    }

    public void visitForLoop(Tree.ForLoop forLoop) {
        this.visitOneList(forLoop.init);
        this.visitOneTree(forLoop.cond);
        this.visitOneList(forLoop.step);
        this.visitOneTree(forLoop.body);
    }

    public void visitLabelled(Tree.Labelled labelled) {
        this.visitOneTree(labelled.body);
    }

    public void visitSwitch(Tree.Switch switch_) {
        this.visitOneTree(switch_.selector);
        this.visitOneList(switch_.cases);
    }

    public void visitCase(Tree.Case case_) {
        this.visitOneTree(case_.pat);
        this.visitOneList(case_.stats);
    }

    public void visitSynchronized(Tree.Synchronized synchronized_) {
        this.visitOneTree(synchronized_.lock);
        this.visitOneTree(synchronized_.body);
    }

    public void visitTry(Tree.Try try_) {
        this.visitOneTree(try_.body);
        this.visitOneList(try_.catchers);
        this.visitOneTree(try_.finalizer);
    }

    public void visitCatch(Tree.Catch catch_) {
        this.visitOneTree((Tree)catch_.param);
        this.visitOneTree(catch_.body);
    }

    public void visitConditional(Tree.Conditional conditional) {
        this.visitOneTree(conditional.cond);
        this.visitOneTree(conditional.truepart);
        this.visitOneTree(conditional.falsepart);
    }

    public void visitIf(Tree.If if_) {
        this.visitOneTree(if_.cond);
        this.visitOneTree(if_.thenpart);
        this.visitOneTree(if_.elsepart);
    }

    public void visitExec(Tree.Exec exec) {
        this.visitOneTree(exec.expr);
    }

    public void visitBreak(Tree.Break break_) {
    }

    public void visitContinue(Tree.Continue continue_) {
    }

    public void visitReturn(Tree.Return return_) {
        this.visitOneTree(return_.expr);
    }

    public void visitThrow(Tree.Throw throw_) {
        this.visitOneTree(throw_.expr);
    }

    public void visitAssert(Tree.Assert assert_) {
        this.visitOneTree(assert_.cond);
        this.visitOneTree(assert_.detail);
    }

    public void visitApply(Tree.Apply apply) {
        this.visitOneTree(apply.meth);
        this.visitOneList(apply.args);
    }

    public void visitNewClass(Tree.NewClass newClass) {
        this.visitOneTree(newClass.encl);
        if (newClass.def == null) {
            this.visitOneTree(newClass.clazz);
            this.visitOneList(newClass.args);
        } else {
            this.visitOneList(newClass.args);
            this.visitOneTree((Tree)newClass.def);
        }
    }

    public void visitNewArray(Tree.NewArray newArray) {
        this.visitOneTree(newArray.elemtype);
        this.visitOneList(newArray.dims);
        this.visitOneList(newArray.elems);
    }

    public void visitParens(Tree.Parens parens) {
        this.visitOneTree(parens.expr);
    }

    public void visitAssign(Tree.Assign assign) {
        this.visitOneTree(assign.lhs);
        this.visitOneTree(assign.rhs);
    }

    public void visitAssignop(Tree.Assignop assignop) {
        this.visitOneTree(assignop.lhs);
        this.visitOneTree(assignop.rhs);
    }

    public void visitUnary(Tree.Unary unary) {
        this.visitOneTree(unary.arg);
    }

    public void visitBinary(Tree.Binary binary) {
        this.visitOneTree(binary.lhs);
        this.visitOneTree(binary.rhs);
    }

    public void visitTypeCast(Tree.TypeCast typeCast) {
        this.visitOneTree(typeCast.expr);
        this.visitOneTree(typeCast.clazz);
    }

    public void visitTypeTest(Tree.TypeTest typeTest) {
        this.visitOneTree(typeTest.expr);
        this.visitOneTree(typeTest.clazz);
    }

    public void visitIndexed(Tree.Indexed indexed) {
        this.visitOneTree(indexed.indexed);
        this.visitOneTree(indexed.index);
    }

    public void visitLiteral(Tree.Literal literal) {
    }

    public void visitTypeIdent(Tree.TypeIdent typeIdent) {
    }

    public void visitTypeArray(Tree.TypeArray typeArray) {
        this.visitOneTree(typeArray.elemtype);
    }

    public void visitErroneous(Tree.Erroneous erroneous) {
    }

    private static void dumpScope(Scope scope) {
        System.err.println("Scope dump (" + scope + ")");
        System.err.println("   nelems    = " + scope.nelems);
        System.err.println("   length    = " + scope.table.length);
        System.err.println("   owner     = " + scope.owner);
        System.err.println("   owner.fullName()  = " + scope.owner.fullName());
        System.err.println("   owner.flatName()  = " + scope.owner.flatName());
        System.err.println("   scopeName  = " + scope.owner.fullName());
        Set set = CleanerPass1.getClassSymbolsFromScope(scope);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)iterator.next();
            System.err.println("      - " + classSymbol);
        }
        if (scope.next != null) {
            System.err.println("*@*@*@*@*@* next:");
            CleanerPass1.dumpScope(scope.next);
        }
    }

    private class TreeProblem
    extends InternalProblem {
        public TreeProblem() {
        }

        public TreeProblem(String string) {
            super(string);
        }

        private void report() {
            CleanerPass1.this.cleaner.treeProblem(this.getMessage(), ((CleanerPass1)CleanerPass1.this).currTopLevel.sourcefile.toString());
        }
    }
}

