/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.engine;

import com.tombrus.cleanImports.engine.ImportGenerator;
import com.tombrus.cleanImports.model.Import;
import com.tombrus.cleanImports.model.ImportList;
import com.tombrus.cleanImports.model.ImportSpecification;
import java.util.Iterator;
import java.util.regex.Pattern;

public class ImportFormatter {
    private static final String defaultLineSeparator = System.getProperty("line.separator", "\n");

    public static String getImportStatements(ImportList importList, String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = importList.sortedIterator();
        while (iterator.hasNext()) {
            ((Import)iterator.next()).appendImportStatement(stringBuffer, bl, bl2).append(string);
        }
        return stringBuffer.toString();
    }

    public static String getImportStatements(final ImportGenerator importGenerator, ImportSpecification importSpecification, final String string) {
        final ImportList importList = importGenerator.getImportList().copy();
        String string2 = "";
        if (importList.size() != 0) {
            if (importSpecification == null) {
                string2 = ImportFormatter.getImportStatements(importList, string, false, true);
            } else {
                final StringBuffer stringBuffer = new StringBuffer();
                final StringBuffer stringBuffer2 = new StringBuffer();
                final StringBuffer stringBuffer3 = new StringBuffer();
                importSpecification.accept(new ImportSpecification.Visitor(){
                    StringBuffer currentBuf;
                    int above;
                    boolean ambiguities;
                    String postBlanks;
                    String restBlanks;
                    {
                        this.currentBuf = stringBuffer;
                        this.above = Integer.MAX_VALUE;
                        this.ambiguities = true;
                        this.postBlanks = string;
                        this.restBlanks = string;
                    }

                    public void begin() {
                    }

                    public void text(String string2) {
                        this.appendText(string2);
                    }

                    public void regExp(String string2, Pattern pattern) {
                        this.appendTextAndImportsIfAnyImports(string2, importList.extractMatching(pattern, false).collapse(this.above), false);
                    }

                    public void javaLang(String string2, boolean bl) {
                        this.appendTextAndImportsIfAnyImports(string2, importGenerator.getJavaLangImportList(), bl);
                    }

                    public void own(String string2, boolean bl) {
                        this.appendTextAndImportsIfAnyImports(string2, importGenerator.getOwnImportList(), bl);
                    }

                    public void rest(String string2) {
                        this.currentBuf = stringBuffer2;
                        this.appendText(string2);
                        this.currentBuf = stringBuffer3;
                        this.restBlanks = this.postBlanks;
                    }

                    public void collapseAbove(int n) {
                        this.above = n;
                    }

                    public void postBlanks(int n) {
                        StringBuffer stringBuffer4 = new StringBuffer();
                        int n2 = 0;
                        while (n2 < n) {
                            stringBuffer4.append(string);
                            ++n2;
                        }
                        this.postBlanks = stringBuffer4.toString();
                    }

                    public void ambiguities(boolean bl) {
                        this.ambiguities = bl;
                    }

                    public void end() {
                        String string2 = ImportFormatter.getImportStatements(importList.collapse(this.above), string, false, this.ambiguities);
                        if (string2.length() > 0) {
                            stringBuffer2.append(string2).append(this.restBlanks);
                        } else {
                            stringBuffer2.setLength(0);
                        }
                    }

                    public String getEOL() {
                        return string;
                    }

                    private void appendTextAndImportsIfAnyImports(String string2, ImportList importList2, boolean bl) {
                        this.appendTextAndImportsIfAnyImports(string2, ImportFormatter.getImportStatements(importList2, string, bl, this.ambiguities));
                    }

                    private void appendTextAndImportsIfAnyImports(String string3, String string2) {
                        if (string2.length() > 0) {
                            this.appendText(string3);
                            this.currentBuf.append(string2).append(this.postBlanks);
                        }
                    }

                    private void appendText(String string2) {
                        if (string2 != null) {
                            this.currentBuf.append(string2).append(string);
                        }
                    }
                });
                string2 = stringBuffer.toString() + stringBuffer2.toString() + stringBuffer3.toString();
                if (string2.startsWith(string)) {
                    string2 = string2.substring(string.length());
                }
            }
        }
        return string2;
    }
}

