/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.ant;

import com.tombrus.cleanImports.model.ImportSpecification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Reference;

public class CleanFormat {
    private Project project;
    private List list = new ArrayList();
    private Reference ref;

    public CleanFormat(Project project) {
        this.project = project;
    }

    public void setRefid(Reference reference) {
        this.ref = reference;
    }

    public CleanFormat getCleanFormat() {
        CleanFormat cleanFormat = this;
        if (this.ref != null) {
            Object object = this.ref.getReferencedObject(this.project);
            cleanFormat = (CleanFormat)object;
            if (object instanceof CleanFormat) {
                cleanFormat = (CleanFormat)object;
            } else {
                throw new BuildException("refid of CleanFormat should be a <cleanformat> but it is a " + object.getClass().getName());
            }
        }
        return cleanFormat;
    }

    public void addText(Text text) {
        this.list.add(text);
    }

    public void addImport(Import import_) {
        this.list.add(import_);
    }

    public void addOptions(Options options) {
        this.list.add(options);
    }

    public void addCollapse(Collapse collapse) {
        this.project.log("Obsolete: The <collapse above=\"" + collapse.above + "\"> construct is obsolete, use <options collapseAbove=\"" + collapse.above + "\"> instead.", 1);
        this.list.add(collapse);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" == ").append(iterator.next().toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    ImportSpecification getImportSpecification() {
        ImportSpecification importSpecification = new ImportSpecification();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            ((FormatElement)iterator.next()).addTo(importSpecification);
        }
        return importSpecification;
    }

    public static class Collapse
    extends Text {
        protected int above;

        public void setAbove(int n) {
            this.above = n;
        }

        void addTo(ImportSpecification importSpecification) {
            importSpecification.addCollapseAbove(this.above);
        }
    }

    public static class Options
    extends FormatElement {
        protected boolean collapseAboveUsed;
        protected int collapseAbove;
        protected boolean blankLinesUsed;
        protected int blankLines;
        protected boolean ambiguitiesUsed;
        protected boolean ambiguities;

        public void setCollapseAbove(int n) {
            this.collapseAboveUsed = true;
            this.collapseAbove = n;
        }

        public void setBlankLines(int n) {
            this.blankLinesUsed = true;
            this.blankLines = n;
        }

        public void setAmbiguities(boolean bl) {
            this.ambiguitiesUsed = true;
            this.ambiguities = bl;
        }

        void addTo(ImportSpecification importSpecification) {
            if (this.collapseAboveUsed) {
                importSpecification.addCollapseAbove(this.collapseAbove);
            }
            if (this.blankLinesUsed) {
                importSpecification.addPostBlanks(this.blankLines);
            }
            if (this.ambiguitiesUsed) {
                importSpecification.addAmbiguities(this.ambiguities);
            }
        }
    }

    public static class Import
    extends Text {
        protected String pack;
        protected String regexp;
        protected boolean javaLangUsed;
        protected boolean javaLang;
        protected boolean ownUsed;
        protected boolean own;
        protected boolean asCommentUsed;
        protected boolean asComment;

        public void setPackage(String string) {
            this.pack = string;
        }

        public void setRegExp(String string) {
            this.regexp = string;
        }

        public void setJavaLang(boolean bl) {
            this.javaLangUsed = true;
            this.javaLang = bl;
        }

        public void setOwn(boolean bl) {
            this.ownUsed = true;
            this.own = bl;
        }

        public void setAsComment(boolean bl) {
            this.asCommentUsed = true;
            this.asComment = bl;
        }

        void addTo(ImportSpecification importSpecification) {
            if ((this.pack != null ? 1 : 0) + (this.regexp != null ? 1 : 0) + (this.javaLangUsed ? 1 : 0) + (this.ownUsed ? 1 : 0) > 1) {
                throw new BuildException("Only one of 'package', 'regexp', 'own' or 'javalang' can be set in an import element of CleanImports.");
            }
            if (this.asComment && !this.ownUsed && !this.javaLangUsed) {
                throw new BuildException("The 'asComment' attribute has no meaning except for 'own' or 'javalang' import elements of CleanImports.");
            }
            if (this.pack != null) {
                importSpecification.addRegExp(this.comment, this.embeddedText, "^\\Q" + this.pack + "\\E\\..*");
            } else if (this.regexp != null) {
                importSpecification.addRegExp(this.comment, this.embeddedText, this.regexp);
            } else if (this.own) {
                importSpecification.addOwn(this.comment, this.embeddedText, this.asComment);
            } else if (this.javaLang) {
                importSpecification.addJavaLang(this.comment, this.embeddedText, this.asComment);
            } else {
                importSpecification.addRest(this.comment, this.embeddedText);
            }
        }
    }

    public static class Text
    extends FormatElement {
        protected String comment;
        protected String embeddedText;

        public void setComment(String string) {
            this.comment = string;
        }

        public void addText(String string) {
            if (this.embeddedText == null) {
                this.embeddedText = "";
            }
            this.embeddedText = this.embeddedText + string;
        }

        void addTo(ImportSpecification importSpecification) {
            importSpecification.addText(this.comment, this.embeddedText);
        }
    }

    public static abstract class FormatElement {
        abstract void addTo(ImportSpecification var1);
    }
}

