/*
 * Decompiled with CFR 0.152.
 */
package com.excelsior.xFunction;

import com.excelsior.xFunction.ArgType;
import com.excelsior.xFunction.Argument;
import com.excelsior.xFunction.FunctionNotFoundException;
import com.excelsior.xFunction.GettingPointerValueException;
import com.excelsior.xFunction.IllegalSignatureException;
import com.excelsior.xFunction.IllegalStructureException;
import com.excelsior.xFunction.IncompatibleArgumentTypeException;
import com.excelsior.xFunction.LibraryNotFoundException;
import com.excelsior.xFunction.Pointer;
import com.excelsior.xFunction.StructureLayout;
import com.excelsior.xFunction.WrongArgumentNumberException;
import com.excelsior.xFunction.xParser;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class xFunction {
    private static final int dllNotFound = 1;
    private static final int functionNotFound = 3;
    private ArgType retType;
    private ArgType[] argTypes;
    private String dllName;
    private String funcName;
    private int handle;

    private xFunction() {
    }

    public xFunction(String string, String string2) throws LibraryNotFoundException, FunctionNotFoundException, IllegalSignatureException {
        this.parseSignature(string2);
        this.dllName = string;
        byte[] byArray = string.getBytes();
        byte[] byArray2 = this.funcName.getBytes();
        this.handle = xFunction.loadFunction(byArray, byArray.length, byArray2, byArray2.length);
        if (this.handle == 1) {
            throw new LibraryNotFoundException("Can't load library: '" + string + "'.");
        }
        if (this.handle == 3) {
            throw new FunctionNotFoundException("Can't load function: '" + this.funcName + "'.");
        }
    }

    public Object invoke() throws WrongArgumentNumberException, IncompatibleArgumentTypeException {
        return this.invoke(new Argument[0]);
    }

    public Object invoke(Argument argument) throws WrongArgumentNumberException, IncompatibleArgumentTypeException {
        return this.invoke(new Argument[]{argument});
    }

    public Object invoke(Argument argument, Argument argument2) throws WrongArgumentNumberException, IncompatibleArgumentTypeException {
        return this.invoke(new Argument[]{argument, argument2});
    }

    public Object invoke(Argument argument, Argument argument2, Argument argument3) throws WrongArgumentNumberException, IncompatibleArgumentTypeException {
        return this.invoke(new Argument[]{argument, argument2, argument3});
    }

    public Object invoke(Argument argument, Argument argument2, Argument argument3, Argument argument4) throws WrongArgumentNumberException, IncompatibleArgumentTypeException {
        return this.invoke(new Argument[]{argument, argument2, argument3, argument4});
    }

    public Object invoke(Argument argument, Argument argument2, Argument argument3, Argument argument4, Argument argument5) throws WrongArgumentNumberException, IncompatibleArgumentTypeException {
        return this.invoke(new Argument[]{argument, argument2, argument3, argument4, argument5});
    }

    public Object invoke(Argument[] argumentArray) throws WrongArgumentNumberException, IncompatibleArgumentTypeException {
        byte[] byArray;
        if (argumentArray.length > this.argTypes.length) {
            throw new WrongArgumentNumberException("too many arguments");
        }
        if (argumentArray.length < this.argTypes.length) {
            throw new WrongArgumentNumberException("not enough arguments");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < argumentArray.length) {
            if (!this.argTypes[n].isCompatible(argumentArray[n])) {
                throw new IncompatibleArgumentTypeException("The argument number '" + n + "' is not compatible with the one specified in signature.");
            }
            byArray = argumentArray[n].getAsByteArray();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            switch (byArray.length % 4) {
                case 1: {
                    byteArrayOutputStream.write(0);
                }
                case 2: {
                    byteArrayOutputStream.write(0);
                }
                case 3: {
                    byteArrayOutputStream.write(0);
                }
            }
            ++n;
        }
        byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = null;
        byArray2 = this.retType == null ? xFunction.callFunc(this.handle, byArray, byArray.length, 0, false) : xFunction.callFunc(this.handle, byArray, byArray.length, this.retType.getSizeAsRetVal(), this.retType.isFloat());
        if (this.retType == null) {
            return null;
        }
        if (byArray2 == null) {
            throw new Error("xFunction: fatal error: can't create byte array from native method");
        }
        Argument argument = null;
        if (this.retType.type == 30) {
            return xFunction.isNull(byArray2) ? Pointer.NULL : new Pointer(byArray2, this.retType);
        }
        if (this.retType.isStringType() && xFunction.isNull(byArray2)) {
            return null;
        }
        argument = new Argument(byArray2, this.retType);
        try {
            return argument.getValue();
        }
        catch (GettingPointerValueException gettingPointerValueException) {
            return null;
        }
    }

    private static boolean isNull(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSignature(String string) throws IllegalSignatureException {
        xParser xParser2 = xParser.getParser();
        xParser2.init(string);
        if (!xParser2.parseSignature()) {
            throw new IllegalSignatureException("Can't parse signature.", xParser2.errorInfo, string, xParser2.errorPos);
        }
        if (ArgType.ptName[0].equals(xParser2.baseType)) {
            if (xParser2.pDepth != 0) throw new IllegalSignatureException("Pointers to 'void' are not alowed as return value. You should use pointers to 'int' instead.");
            this.retType = null;
        } else {
            this.retType = ArgType.getArgType(xParser2.baseType, xParser2.pDepth);
        }
        this.funcName = xParser2.name;
        ArrayList<ArgType> arrayList = null;
        while (xParser2.parseSignature()) {
            ArgType argType = ArgType.getArgType(xParser2.baseType, xParser2.pDepth);
            if (arrayList == null) {
                arrayList = new ArrayList<ArgType>();
            }
            arrayList.add(argType);
        }
        if (xParser2.error) {
            throw new IllegalSignatureException("Can't parse signature.", xParser2.errorInfo, string, xParser2.errorPos);
        }
        xParser.freeParser(xParser2);
        if (arrayList == null) {
            this.argTypes = new ArgType[0];
        } else {
            int n = arrayList.size();
            this.argTypes = new ArgType[n];
            Iterator iterator = arrayList.iterator();
            int n2 = 0;
            while (n2 < n) {
                this.argTypes[n2] = (ArgType)iterator.next();
                ++n2;
            }
        }
        try {
            StructureLayout.processDeferred();
            return;
        }
        catch (IllegalStructureException illegalStructureException) {
            throw new IllegalSignatureException(illegalStructureException.getMessage());
        }
    }

    private static native int loadFunction(byte[] var0, int var1, byte[] var2, int var3);

    private static native byte[] callFunc(int var0, byte[] var1, int var2, int var3, boolean var4);

    static {
        System.loadLibrary("xFunction");
    }
}

