/*
 * Decompiled with CFR 0.152.
 */
package com.excelsior.xFunction;

import com.excelsior.xFunction.Argument;
import com.excelsior.xFunction.ConvPrim;
import com.excelsior.xFunction.IllegalStringConversionException;
import com.excelsior.xFunction.SLField;
import com.excelsior.xFunction.Structure;
import java.lang.reflect.Field;
import java.util.List;

class SLFieldString
extends SLField {
    int strType;

    public SLFieldString(int n, int n2, Field field) {
        super(n2, 4, field);
        this.strType = n;
    }

    public void fromByteArray(Structure structure, byte[] byArray) {
        byte[] byArray2 = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray2[n] = byArray[this.offset + n];
            ++n;
        }
        byte[] byArray3 = Argument.derefString(ConvPrim.byteArrayToInt(byArray2), this.strType);
        String string = null;
        switch (this.strType) {
            case 30: {
                string = ConvPrim.ASCII2String(byArray3);
                break;
            }
            case 20: {
                string = ConvPrim.Unicode2String(byArray3);
                break;
            }
            case 40: {
                string = ConvPrim.BSTR2String(byArray3);
                break;
            }
            default: {
                throw new Error("xFunction internal error");
            }
        }
        try {
            this.field.set(structure, string);
        }
        catch (Exception exception) {
            throw new Error("xFunction internal error: corrupt structure object");
        }
    }

    public void toByteArray(Structure structure, byte[] byArray, List list) {
        String string;
        try {
            string = (String)this.field.get(structure);
        }
        catch (Exception exception) {
            throw new Error("xFunction internal error: corrupt structure object");
        }
        if (string == null) {
            int n = 0;
            while (n < 4) {
                byArray[this.offset + n] = 0;
                ++n;
            }
            return;
        }
        Argument argument = null;
        try {
            argument = new Argument(string, this.strType);
        }
        catch (IllegalStringConversionException illegalStringConversionException) {
            if (this.strType != 30) {
                throw new Error("xFunction internal error: unexpected IllegalStringConversionException");
            }
            try {
                argument = new Argument(ConvPrim.ASCII2String(ConvPrim.String2ASCII(string)), 30);
            }
            catch (IllegalStringConversionException illegalStringConversionException2) {
                throw new Error("xFunction internal error: unexpected IllegalStringConversionException");
            }
        }
        list.add(argument);
        byte[] byArray2 = argument.value;
        int n = 0;
        while (n < 4) {
            byArray[this.offset + n] = byArray2[n];
            ++n;
        }
    }
}

