/*
 * Decompiled with CFR 0.152.
 */
package com.excelsior.xFunction;

import com.excelsior.xFunction.ArgType;
import com.excelsior.xFunction.Argument;
import com.excelsior.xFunction.ConvPrim;
import com.excelsior.xFunction.GettingPointerValueException;
import com.excelsior.xFunction.IllegalDimensionException;
import com.excelsior.xFunction.IllegalSignatureException;
import com.excelsior.xFunction.IllegalStructureException;
import com.excelsior.xFunction.NullDereferenceException;
import com.excelsior.xFunction.Structure;
import java.lang.reflect.Array;

public final class Pointer
extends Argument {
    public static final Pointer NULL;
    protected Argument objArg = null;

    protected Pointer() {
    }

    public Object deref() throws NullDereferenceException {
        ArgType argType = this.type.base;
        this.refresh();
        int n = ConvPrim.byteArrayToInt(this.value);
        byte[] byArray = Pointer.derefToByteArray(n, argType.getSize());
        Argument argument = null;
        if (argType.type == 30) {
            argument = new Pointer(byArray, argType);
            return argument;
        }
        argument = new Argument(byArray, argType);
        try {
            return argument.getValue();
        }
        catch (GettingPointerValueException gettingPointerValueException) {
            throw new Error("xFunction internal error: unexpected exception " + gettingPointerValueException);
        }
    }

    Object createMultiArray(byte[] byArray, int n, int[] nArray, int[] nArray2, int n2, Class[] classArray, ArgType argType) {
        if (n2 > 0) {
            Object object = Array.newInstance(classArray[n2], nArray[n2]);
            int n3 = 0;
            while (n3 < nArray[n2]) {
                Array.set(object, n3, this.createMultiArray(byArray, n, nArray, nArray2, n2 - 1, classArray, argType));
                n += nArray2[n2];
                ++n3;
            }
            return object;
        }
        Object object = Array.newInstance(classArray[0], nArray[0]);
        int n4 = nArray2[0];
        int n5 = 0;
        while (n5 < nArray[0]) {
            byte[] byArray2 = new byte[n4];
            int n6 = 0;
            while (n6 < n4) {
                byArray2[n6] = byArray[n + n6];
                ++n6;
            }
            n += n4;
            try {
                if (argType.type == 30) {
                    Array.set(object, n5, new Pointer(byArray2, argType));
                } else {
                    Array.set(object, n5, Argument.createFromPacked(byArray2, argType).getValue());
                }
            }
            catch (Exception exception) {
                throw new Error("xFunction internal error: unexpected exception: " + exception);
            }
            ++n5;
        }
        return object;
    }

    public Object createArray(int[] nArray) throws NullDereferenceException, IllegalDimensionException {
        ArgType argType = this.type.base;
        this.refresh();
        int n = ConvPrim.byteArrayToInt(this.value);
        int n2 = argType.getDistinctSize();
        int n3 = 1;
        int n4 = nArray.length;
        int[] nArray2 = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            if (nArray[n5] <= 0) {
                throw new IllegalDimensionException("Each dimension should be positive");
            }
            n3 *= nArray[n5];
            nArray2[n4 - n5 - 1] = nArray[n5];
            ++n5;
        }
        byte[] byArray = Pointer.derefToByteArray(n, n3 * n2);
        Class clazz = this.type.base.getArgClass();
        Class[] classArray = new Class[n4];
        int[] nArray3 = new int[n4];
        nArray3[0] = n2;
        classArray[0] = clazz;
        int n6 = 1;
        while (n6 < n4) {
            nArray3[n6] = nArray3[n6 - 1] * nArray2[n6 - 1];
            try {
                classArray[n6] = Array.newInstance(classArray[n6 - 1], 0).getClass();
            }
            catch (Exception exception) {
                throw new Error("xFunction internal error: unexpected exception: " + exception);
            }
            ++n6;
        }
        return this.createMultiArray(byArray, 0, nArray2, nArray3, n4 - 1, classArray, argType);
    }

    public Object createArray(int n) throws NullDereferenceException, IllegalDimensionException {
        return this.createArray(new int[]{n});
    }

    public static Pointer create(String string) throws IllegalSignatureException {
        ArgType argType;
        Pointer pointer = new Pointer();
        pointer.type = argType = ArgType.parseArgType(string);
        if (argType.type != 30) {
            throw new IllegalSignatureException("String does not specify a pointer");
        }
        byte[] byArray = new byte[argType.base.getSize()];
        Argument argument = null;
        argument = argType.base.type == 30 ? new Pointer(byArray, argType.base) : new Argument(byArray, argType.base);
        argument.lock();
        pointer.objArg = argument;
        pointer.value = ConvPrim.toByteArray(argument.pointer);
        pointer.lock();
        return pointer;
    }

    public static Pointer createPointerTo(int n) {
        return new Argument(n).createPointer();
    }

    public static Pointer createPointerTo(char c) {
        return new Argument(c).createPointer();
    }

    public static Pointer createPointerTo(short s) {
        return new Argument(s).createPointer();
    }

    public static Pointer createPointerTo(long l) {
        return new Argument(l).createPointer();
    }

    public static Pointer createPointerTo(float f) {
        return new Argument(f).createPointer();
    }

    public static Pointer createPointerTo(double d) {
        return new Argument(d).createPointer();
    }

    public static Pointer createPointerTo(Structure structure) throws IllegalStructureException {
        return new Argument(structure).createPointer();
    }

    public Pointer cast(String string) throws IllegalSignatureException {
        ArgType argType = ArgType.parseArgType(string);
        if (argType.type != 30) {
            throw new IllegalSignatureException("String does not specify a pointer");
        }
        Pointer pointer = new Pointer(this.value, argType);
        pointer.objArg = this.objArg;
        return pointer;
    }

    Pointer(byte[] byArray, ArgType argType) {
        super(byArray, argType);
    }

    static byte[] derefToByteArray(int n, int n2) throws NullDereferenceException {
        if (n == 0) {
            throw new NullDereferenceException();
        }
        byte[] byArray = new byte[n2];
        Pointer.setByteArray(byArray, n, n2);
        return byArray;
    }

    private static native void setByteArray(byte[] var0, int var1, int var2);

    protected void finalize() {
        super.finalize();
    }

    static {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        ArgType argType = null;
        try {
            argType = ArgType.getArgType("char", 1);
        }
        catch (IllegalSignatureException illegalSignatureException) {
            throw new Error("xFunction internal error: unexpected exception: " + illegalSignatureException);
        }
        NULL = new Pointer(byArray, argType);
        System.loadLibrary("xFunction");
    }
}

