/*
 * Decompiled with CFR 0.152.
 */
package com.excelsior.xFunction;

import com.excelsior.xFunction.CallbackLayout;
import com.excelsior.xFunction.IllegalCallbackException;
import com.excelsior.xFunction.ThreadCreator;

public abstract class Callback {
    private IllegalCallbackException lastException;
    private CallbackLayout layout;
    private int gateAddr = 0;

    public abstract String defineSignature();

    private static native int lockGate(Callback var0, int var1, int var2);

    private static native void freeGate(int var0);

    public final void free() {
        if (this.gateAddr == 0) {
            return;
        }
        Callback.freeGate(this.gateAddr);
        this.gateAddr = 0;
    }

    protected final int lockGate() {
        if (this.gateAddr != 0) {
            return this.gateAddr;
        }
        this.gateAddr = Callback.lockGate(this, this.layout.size, this.layout.isFloat);
        if (this.gateAddr == 0) {
            throw new Error("xFunction fatal error: allocating gate for the callback failed");
        }
        return this.gateAddr;
    }

    protected Callback() {
        try {
            this.layout = CallbackLayout.getLayout(this);
            this.lastException = null;
        }
        catch (IllegalCallbackException illegalCallbackException) {
            this.lastException = illegalCallbackException;
        }
    }

    protected void check() throws IllegalCallbackException {
        if (this.lastException != null) {
            throw this.lastException;
        }
    }

    private long invokeLong(byte[] byArray) {
        return this.layout.invokeLong(byArray);
    }

    private double invokeDouble(byte[] byArray) {
        return this.layout.invokeDouble(byArray);
    }

    private static native void nativesInit();

    static {
        System.loadLibrary("xFunction");
        Callback.nativesInit();
        new ThreadCreator().start();
    }
}

