/*
 * Decompiled with CFR 0.152.
 */
package com.excelsior.xFunction;

import com.excelsior.xFunction.Argument;
import com.excelsior.xFunction.Callback;
import com.excelsior.xFunction.ConvPrim;
import com.excelsior.xFunction.IllegalSignatureException;
import com.excelsior.xFunction.IllegalStringConversionException;
import com.excelsior.xFunction.IllegalStructureException;
import com.excelsior.xFunction.Pointer;
import com.excelsior.xFunction.Structure;
import com.excelsior.xFunction.StructureLayout;
import com.excelsior.xFunction.TypesDifferentException;
import com.excelsior.xFunction.xParser;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class ArgType {
    public static final int FICTION = 0;
    public static final int CHAR = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int CSTRING = 8;
    public static final int UNICODESTRING = 9;
    public static final int BSTR = 10;
    public static final int STRUCT = 20;
    public static final int CALLBACK = 21;
    public static final int POINTER = 30;
    public static final String[] ptName = new String[]{"void", "byte", "char", "short", "int", "long", "float", "double", "CSTRING", "UNICODESTRING", "BSTR"};
    private static final int lastPTNum = 10;
    protected static final Class voidClass = Void.TYPE;
    protected static final Class charClass = Character.TYPE;
    protected static final Class shortClass = Short.TYPE;
    protected static final Class intClass = Integer.TYPE;
    protected static final Class longClass = Long.TYPE;
    protected static final Class floatClass = Float.TYPE;
    protected static final Class doubleClass = Double.TYPE;
    protected static final Class stringClass;
    protected static final Class objectClass;
    protected static final Class pointerClass;
    protected static final Class structureClass;
    protected static final Class callbackClass;
    private static Map typeMap;
    protected int type;
    protected ArgType base;
    private boolean checked;
    protected String baseClassName;
    protected Class baseClass;
    private static ArgType fictionArgType;

    public static ArgType getFictionArgType() {
        return fictionArgType;
    }

    public static ArgType getPointerArgType(ArgType argType) {
        return new ArgType(argType);
    }

    public static ArgType parseArgType(String string) throws IllegalSignatureException {
        xParser xParser2 = xParser.getParser();
        xParser2.init(string);
        if (!xParser2.parseType() || xParser2.error) {
            throw new IllegalSignatureException("Can't parse signature record.", xParser2.errorInfo, string, xParser2.errorPos);
        }
        string = xParser2.baseType;
        int n = xParser2.pDepth;
        xParser.freeParser(xParser2);
        return ArgType.getArgType(string, n);
    }

    public static ArgType getArgType(String string) throws IllegalSignatureException {
        return ArgType.getArgType(string, 0);
    }

    public static ArgType getArgType(String string, int n) throws IllegalSignatureException {
        ArgType argType;
        int n2;
        ArgType argType2;
        boolean bl;
        ArrayList<ArgType> arrayList = (ArrayList<ArgType>)typeMap.get(string);
        boolean bl2 = bl = arrayList == null;
        if (bl) {
            arrayList = new ArrayList<ArgType>(2);
            argType2 = new ArgType(string);
            arrayList.add(argType2);
            n2 = 1;
        } else {
            argType2 = (ArgType)arrayList.get(0);
            n2 = arrayList.size();
        }
        if (n2 > n) {
            argType = (ArgType)arrayList.get(n);
        } else {
            argType = (ArgType)arrayList.get(n2 - 1);
            int n3 = n2;
            while (n3 <= n) {
                argType = new ArgType(argType);
                arrayList.add(argType);
                ++n3;
            }
            if (bl) {
                typeMap.put(string, arrayList);
            }
        }
        argType.checkArgType(n == 0);
        return argType;
    }

    private ArgType() {
        this.type = 0;
    }

    private ArgType(ArgType argType) {
        this.base = argType;
        this.type = 30;
        this.checked = false;
    }

    private ArgType(String string) throws IllegalSignatureException {
        this.checked = false;
        int n = 0;
        while (n <= 10) {
            if (ptName[n].equals(string)) break;
            ++n;
        }
        if (n < 2) {
            throw new IllegalSignatureException("Illegal type to make an Argument: " + ptName[n]);
        }
        this.baseClassName = string;
        if (n <= 10) {
            this.type = n;
        } else {
            Class clazz;
            try {
                this.baseClass = Class.forName(this.baseClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalSignatureException("Class '" + this.baseClassName + "' not found");
            }
            Class clazz2 = clazz = this.baseClass;
            while (!objectClass.equals(clazz2)) {
                clazz = clazz2;
                clazz2 = clazz2.getSuperclass();
            }
            if (clazz.equals(structureClass) && clazz != this.baseClass) {
                this.type = 20;
            } else if (clazz.equals(callbackClass) && clazz != this.baseClass) {
                this.type = 21;
            } else {
                throw new IllegalSignatureException("Class specified ('" + this.baseClassName + "') must be Structure or Callback subclass");
            }
        }
    }

    private void checkArgType(boolean bl) throws IllegalSignatureException {
        if (!this.checked) {
            if (bl) {
                if (this.type == 20) {
                    try {
                        StructureLayout.check(this.baseClass);
                    }
                    catch (IllegalStructureException illegalStructureException) {
                        this.markNotChecked();
                        throw new IllegalSignatureException(illegalStructureException.getMessage());
                    }
                }
            } else {
                ArgType argType = this.base;
                while (argType.type == 30) {
                    argType = argType.base;
                }
                if (argType.type == 20) {
                    StructureLayout.addDeferred(argType.baseClass);
                }
            }
            this.checked = true;
        }
    }

    private void markNotChecked() {
        List list = (List)typeMap.get(this.baseClassName);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ArgType argType = (ArgType)iterator.next();
            argType.checked = false;
        }
    }

    protected boolean isStringType() {
        return this.type == 8 || this.type == 9 || this.type == 10;
    }

    protected int convStrType(int n) {
        if (n == 8) {
            return 30;
        }
        if (n == 9) {
            return 20;
        }
        if (n == 10) {
            return 40;
        }
        throw new Error("xFunction internal error: unknown string type");
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArgType)) {
            return false;
        }
        ArgType argType = (ArgType)object;
        if (this.type != argType.type) {
            return false;
        }
        if (this.type == 30) {
            return this.base.equals(argType.base);
        }
        if (this.type == 20 || this.type == 21) {
            return this.baseClassName.equals(argType.baseClassName);
        }
        return true;
    }

    public boolean isCompatible(Argument argument) {
        ArgType argType = argument.type;
        if (argType.type != this.type) {
            return false;
        }
        switch (this.type) {
            case 30: {
                if (argument == Pointer.NULL) {
                    return true;
                }
                return this.base.equals(argType.base);
            }
            case 20: 
            case 21: {
                return this.baseClass.getName().equals(argType.baseClass.getName());
            }
        }
        return true;
    }

    protected int fillArr(Object object, Object object2, int n, int[] nArray, int n2) throws Exception {
        int n3 = nArray[n2];
        if (Array.getLength(object2) != n3) {
            throw new TypesDifferentException("Non-homogenous array");
        }
        if (n2 > 0) {
            int n4 = 0;
            while (n4 < n3) {
                n = this.fillArr(object, Array.get(object2, n4), n, nArray, n2 - 1);
                ++n4;
            }
            return n;
        }
        int n5 = 0;
        while (n5 < n3) {
            Array.set(object, n + n5, Array.get(object2, n5));
            ++n5;
        }
        return n + n3;
    }

    protected Object flattenArray(Class clazz, Object object, int n) throws TypesDifferentException {
        if (n == 1) {
            return object;
        }
        int[] nArray = new int[n];
        Object object2 = object;
        Object object3 = null;
        try {
            int n2 = 1;
            int n3 = 0;
            while (n3 < n) {
                int n4 = Array.getLength(object2);
                if (n4 < 1) {
                    throw new TypesDifferentException("Illegal array dimension: " + n4);
                }
                nArray[n - n3 - 1] = n4;
                n2 *= n4;
                object2 = Array.get(object2, 0);
                ++n3;
            }
            object3 = Array.newInstance(clazz, n2);
            this.fillArr(object3, object, 0, nArray, n - 1);
        }
        catch (Exception exception) {
            if (exception instanceof TypesDifferentException) {
                throw (TypesDifferentException)exception;
            }
            throw new Error("xFunction internal error: unexpected exception: " + exception);
        }
        return object3;
    }

    protected byte[] check_and_calc(Object object, List list) throws TypesDifferentException, IllegalStringConversionException {
        if (object == null) {
            throw new TypesDifferentException("null encountered, but some Object expected.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        switch (this.type) {
            case 4: {
                if (!(object instanceof Integer)) {
                    throw new TypesDifferentException("Integer expected");
                }
                return ConvPrim.toByteArray((Integer)object);
            }
            case 2: {
                if (!(object instanceof Character)) {
                    throw new TypesDifferentException("Character expected");
                }
                return ConvPrim.toByteArray(((Character)object).charValue() & 0xFF);
            }
            case 3: {
                if (!(object instanceof Short)) {
                    throw new TypesDifferentException("Short expected");
                }
                return ConvPrim.toByteArray(((Short)object).intValue());
            }
            case 5: {
                if (!(object instanceof Long)) {
                    throw new TypesDifferentException("Long expected");
                }
                return ConvPrim.toByteArray((Long)object);
            }
            case 6: {
                if (!(object instanceof Float)) {
                    throw new TypesDifferentException("Float expected");
                }
                return ConvPrim.toByteArray(((Float)object).floatValue());
            }
            case 7: {
                if (!(object instanceof Double)) {
                    throw new TypesDifferentException("Double expected");
                }
                return ConvPrim.toByteArray((Double)object);
            }
            case 20: {
                if (!this.baseClass.isInstance(object)) {
                    throw new TypesDifferentException(this.baseClassName + " expected");
                }
                Structure structure = (Structure)object;
                structure.prepareSafe();
                return structure.toByteArray(list);
            }
            case 21: {
                if (!this.baseClass.isInstance(object)) {
                    throw new TypesDifferentException(this.baseClassName + " expected");
                }
                int n = ((Callback)object).lockGate();
                return ConvPrim.toByteArray(n);
            }
            case 30: {
                if (object instanceof Pointer) {
                    return ((Pointer)object).value;
                }
                int n = 0;
                Class<?> clazz = object.getClass();
                while (clazz.isArray()) {
                    ++n;
                    clazz = clazz.getComponentType();
                }
                if (n == 0) {
                    throw new TypesDifferentException("Array expected");
                }
                Class<?> clazz2 = clazz;
                object = this.flattenArray(clazz2, object, n);
                if (clazz2.isPrimitive()) {
                    switch (this.base.type) {
                        case 4: {
                            if (!clazz2.getName().equals("int")) {
                                throw new TypesDifferentException("int[] expected");
                            }
                            int[] nArray = (int[])object;
                            if (nArray.length == 0) {
                                throw new TypesDifferentException("Zero dimension");
                            }
                            int n2 = 0;
                            while (n2 < nArray.length) {
                                byteArrayOutputStream.write(ConvPrim.toByteArray(nArray[n2]), 0, 4);
                                ++n2;
                            }
                            return byteArrayOutputStream.toByteArray();
                        }
                        case 2: {
                            if (!clazz2.getName().equals("char")) {
                                throw new TypesDifferentException("char[] expected");
                            }
                            char[] cArray = (char[])object;
                            if (cArray.length == 0) {
                                throw new TypesDifferentException("Zero dimension");
                            }
                            byte[] byArray = new byte[cArray.length];
                            int n3 = 0;
                            while (n3 < cArray.length) {
                                byArray[n3] = (byte)(cArray[n3] & 0xFF);
                                ++n3;
                            }
                            return byArray;
                        }
                        case 3: {
                            if (!clazz2.getName().equals("short")) {
                                throw new TypesDifferentException("short[] expected");
                            }
                            return ConvPrim.toByteArray((short[])object);
                        }
                        case 5: {
                            if (!clazz2.getName().equals("long")) {
                                throw new TypesDifferentException();
                            }
                            long[] lArray = (long[])object;
                            if (lArray.length == 0) {
                                throw new TypesDifferentException("Zero dimension");
                            }
                            int n4 = 0;
                            while (n4 < lArray.length) {
                                byteArrayOutputStream.write(ConvPrim.toByteArray(lArray[n4]), 0, 8);
                                ++n4;
                            }
                            return byteArrayOutputStream.toByteArray();
                        }
                        case 6: {
                            if (!clazz2.getName().equals("float")) {
                                throw new TypesDifferentException("float[] expected");
                            }
                            float[] fArray = (float[])object;
                            if (fArray.length == 0) {
                                throw new TypesDifferentException("Zero dimension");
                            }
                            int n5 = 0;
                            while (n5 < fArray.length) {
                                byteArrayOutputStream.write(ConvPrim.toByteArray(fArray[n5]), 0, 4);
                                ++n5;
                            }
                            return byteArrayOutputStream.toByteArray();
                        }
                        case 7: {
                            if (!clazz2.getName().equals("double")) {
                                throw new TypesDifferentException("double[] expected");
                            }
                            double[] dArray = (double[])object;
                            if (dArray.length == 0) {
                                throw new TypesDifferentException("Zero dimension");
                            }
                            int n6 = 0;
                            while (n6 < dArray.length) {
                                byteArrayOutputStream.write(ConvPrim.toByteArray(dArray[n6]), 0, 8);
                                ++n6;
                            }
                            return byteArrayOutputStream.toByteArray();
                        }
                    }
                    throw new TypesDifferentException("Wrong array type");
                }
                Object[] objectArray = (Object[])object;
                if (objectArray.length == 0) {
                    throw new TypesDifferentException("Zero dimension");
                }
                if (this.base.isStringType()) {
                    int n7 = this.convStrType(this.base.type);
                    int n8 = 0;
                    while (n8 < objectArray.length) {
                        if (!(objectArray[n8] instanceof String)) {
                            throw new TypesDifferentException("Array of String expected");
                        }
                        Argument argument = new Argument((String)objectArray[n8], n7);
                        list.add(argument);
                        byteArrayOutputStream.write(argument.value, 0, 4);
                        ++n8;
                    }
                } else {
                    int n9 = 0;
                    while (n9 < objectArray.length) {
                        if (objectArray[n9] == null) {
                            throw new TypesDifferentException("null encountered as element of array. All array elements must be initialized.");
                        }
                        ++n9;
                    }
                    byte[] byArray = this.base.check_and_calc(objectArray[0], list);
                    int n10 = byArray.length;
                    byteArrayOutputStream.write(byArray, 0, n10);
                    int n11 = 1;
                    while (n11 < objectArray.length) {
                        byArray = this.base.check_and_calc(objectArray[n11], list);
                        if (byArray.length != n10) {
                            throw new TypesDifferentException("Non-homogeneous array");
                        }
                        byteArrayOutputStream.write(byArray, 0, n10);
                        ++n11;
                    }
                }
                return byteArrayOutputStream.toByteArray();
            }
        }
        throw new Error("xFunction internal error: unknown case");
    }

    protected int getSizeAsRetVal() {
        switch (this.type) {
            case 5: 
            case 7: {
                return 8;
            }
            case 20: {
                return Structure.getSizeOfStructAsRetVal(this.baseClass);
            }
        }
        return 4;
    }

    protected int getSize() {
        switch (this.type) {
            case 5: 
            case 7: {
                return 8;
            }
            case 20: {
                return Structure.getSize(this.baseClass);
            }
        }
        return 4;
    }

    protected int getDistinctSize() {
        switch (this.type) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 5: 
            case 7: {
                return 8;
            }
            case 20: {
                return Structure.getSize(this.baseClass);
            }
        }
        return 4;
    }

    protected boolean isFloat() {
        return this.type == 6 || this.type == 7;
    }

    public Class getArgClass() {
        switch (this.type) {
            case 2: {
                return charClass;
            }
            case 3: {
                return shortClass;
            }
            case 4: {
                return intClass;
            }
            case 5: {
                return longClass;
            }
            case 6: {
                return floatClass;
            }
            case 7: {
                return doubleClass;
            }
            case 8: 
            case 9: 
            case 10: {
                return stringClass;
            }
            case 30: {
                return pointerClass;
            }
            case 20: 
            case 21: {
                return this.baseClass;
            }
        }
        throw new Error("xFunction internal error: unknown argument type");
    }

    protected int getBoundaryRequirement() {
        switch (this.type) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 5: 
            case 7: {
                return 8;
            }
            case 20: {
                return Structure.getBoundaryRequirement(this.baseClass);
            }
        }
        return 4;
    }

    static {
        typeMap = new Hashtable(16);
        try {
            stringClass = Class.forName("java.lang.String");
            pointerClass = Class.forName("com.excelsior.xFunction.Pointer");
            structureClass = Class.forName("com.excelsior.xFunction.Structure");
            callbackClass = Class.forName("com.excelsior.xFunction.Callback");
            objectClass = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("xFunction internal error: unexpected ClassNotFoundException occur: " + classNotFoundException);
        }
        fictionArgType = new ArgType();
    }
}

