/*
 * Decompiled with CFR 0.152.
 */
package flex.rds.server.servlet;

import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.rds.server.RdsCmdProcessor;
import flex.rds.server.RdsRequest;
import flex.rds.server.RdsResponse;
import flex.rds.server.servlet.RdsCmdProcessorCompositeServlet;
import flex.rds.server.servlet.internal.JavaDestinationReader;
import flex.rds.server.servlet.internal.JavaIntrospector;
import flex.rds.server.servlet.internal.JavaIntrospectorUtil;
import flex.rds.server.servlet.internal.LCDSIntrospectionException;
import flex.rds.server.util.RB;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FBServicesServlet
extends RdsCmdProcessorCompositeServlet {
    public static final String CMD_DISCOVER = "DISCOVER";
    public static final String CMD_INTROSPECT = "INTROSPECT";
    public static final String CHANNEL_INTROSPECT = "CHANNEL_INTROSPECT";
    private static final long serialVersionUID = 1L;
    private Logger logger;

    protected void doInit() throws ServletException {
        this.logger = Log.getLogger((String)"FBServices.Introspection");
        this.logger.info("LCDS java introspector servlet initializing");
        MessageBroker messageBroker = this.getMessageBroker();
        this.addCmdProcessor(CMD_INTROSPECT, new IntrospectOperator(messageBroker));
        this.addCmdProcessor(CMD_DISCOVER, new DiscoverOperator(messageBroker));
        this.addCmdProcessor(CHANNEL_INTROSPECT, new ChannelIntrospectOperator(messageBroker));
    }

    protected void processCmd(RdsRequest request, RdsResponse response) throws ServletException, IOException {
        String operation = request.getMetaString(0).toUpperCase();
        RdsCmdProcessor rcp = this.getCmdProcessor(operation);
        if (rcp == null) {
            response.setError(RB.getString((Object)this, "LCDSJavaIntrospectorServlet.UnsupportedOperation", (Object)operation));
            return;
        }
        FlexContext.setThreadLocalObjects(null, null, (MessageBroker)this.getMessageBroker(), (HttpServletRequest)request.getHttpServletRequest(), (HttpServletResponse)response.getHttpServletResponse(), (ServletConfig)this.getServletConfig());
        rcp.processCmd(request, response);
    }

    class ChannelIntrospectOperator
    extends RdsCmdProcessor {
        private MessageBroker messageBroker;

        public ChannelIntrospectOperator(MessageBroker messageBroker) {
            this.messageBroker = messageBroker;
        }

        public void processCmd(RdsRequest request, RdsResponse response) throws IOException, ServletException {
            String serviceId = request.getMetaString(1).trim();
            String introspectorContent = "";
            try {
                introspectorContent = JavaIntrospectorUtil.getDefaultChannels(this.messageBroker, serviceId);
            }
            catch (Exception e) {
                FBServicesServlet.this.logger.error(e.getMessage(), (Throwable)e);
                response.setError(e.getMessage(), e);
                return;
            }
            response.addMetaData(introspectorContent);
        }
    }

    class DiscoverOperator
    extends RdsCmdProcessor {
        private MessageBroker messageBroker;

        public DiscoverOperator(MessageBroker messageBroker) {
            this.messageBroker = messageBroker;
        }

        public void processCmd(RdsRequest request, RdsResponse response) throws IOException, ServletException {
            String xml = JavaDestinationReader.getDesinationsAsXMLString(this.messageBroker);
            response.addMetaData(xml);
        }
    }

    class IntrospectOperator
    extends RdsCmdProcessor {
        private MessageBroker messageBroker;

        public IntrospectOperator(MessageBroker messageBroker) {
            this.messageBroker = messageBroker;
        }

        public void processCmd(RdsRequest request, RdsResponse response) throws IOException, ServletException {
            String destinationId = request.getMetaString(1).trim();
            String introspectorContent = "";
            try {
                introspectorContent = new JavaIntrospector(this.messageBroker, destinationId).getClassDataAsXMLString();
            }
            catch (LCDSIntrospectionException e) {
                FBServicesServlet.this.logger.error(e.getMessage(), (Throwable)e);
                response.setError(e.getMessage(), e);
                return;
            }
            response.addMetaData(introspectorContent);
        }
    }
}

