/*
 * Decompiled with CFR 0.152.
 */
package flex.rds.server;

import flex.rds.server.MetaHeader;
import flex.rds.server.RdsHttpResponseFormatter;
import flex.rds.server.RdsResponse;
import flex.rds.server.util.RB;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

class RdsResponseImpl
implements RdsResponse {
    private HttpServletResponse _response;
    private final MetaHeader _meta = new MetaHeader("utf-8");
    private String _errorMessage;
    private boolean _errorOccurred;
    private Throwable _error;
    private int _errorCode = -1;

    RdsResponseImpl() {
    }

    final void init(HttpServletResponse resp) {
        this._response = resp;
    }

    final void finish() throws ServletException, IOException {
        try {
            RdsHttpResponseFormatter formatter = new RdsHttpResponseFormatter();
            if (this.errorOccurred()) {
                formatter.setError(this._errorCode, this._errorMessage, this._error);
            } else {
                Enumeration metadataEnum = this.enumerateMetaData();
                while (metadataEnum.hasMoreElements()) {
                    Object obj = metadataEnum.nextElement();
                    if (obj instanceof String) {
                        formatter.add((String)obj);
                        continue;
                    }
                    throw new IOException(RB.getString((Object)this, "RdsServlet.UnsupportedType", (Object)obj.getClass().getName()));
                }
            }
            byte[] bytes = formatter.getMessageBytes();
            this._response.setContentType("text/html");
            ServletOutputStream out = this._response.getOutputStream();
            out.write(bytes);
            this._response.flushBuffer();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    final void reset() {
        this._response = null;
        this._error = null;
        this._errorMessage = null;
        this._errorOccurred = false;
    }

    public final void addMetaData(String metaString) {
        this._meta.add(metaString);
    }

    public final String getMetaString(int index) {
        return this._meta.getString(index);
    }

    public final Enumeration enumerateMetaData() {
        return this._meta.enumerate();
    }

    public final HttpServletResponse getHttpServletResponse() {
        return this._response;
    }

    public final void setError(int errorCode, String message, Throwable th) {
        this._errorCode = errorCode;
        this._errorMessage = message;
        this._error = th;
        this._errorOccurred = true;
    }

    public final void setError(String message, Throwable th) {
        this.setError(-1, message, th);
    }

    public final void setError(Throwable th) {
        this.setError(-1, th.getMessage(), th);
    }

    public final void setError(String message) {
        this.setError(message, (Throwable)new ServletException(message));
    }

    Throwable getError() {
        return this._error;
    }

    boolean errorOccurred() {
        return this._errorOccurred;
    }
}

