/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;

public class ServerSettings {
    private static final int INVALID_CLUSTER_MESSAGE_ROUTING = 11121;
    private boolean allowSubtopics;
    private boolean broadcastRoutingMode = false;
    private boolean disallowWildcardSubtopics;
    private long messageTTL = -1L;
    private boolean isDurable = false;
    private int priority = -1;
    private String subtopicSeparator = ".";

    public boolean getAllowSubtopics() {
        return this.allowSubtopics;
    }

    public void setAllowSubtopics(boolean value) {
        this.allowSubtopics = value;
    }

    public boolean isBroadcastRoutingMode() {
        return this.broadcastRoutingMode;
    }

    public void setBroadcastRoutingMode(String routingMode) {
        if (routingMode.equalsIgnoreCase("broadcast")) {
            this.broadcastRoutingMode = true;
        } else if (routingMode.equalsIgnoreCase("server-to-server")) {
            this.broadcastRoutingMode = false;
        } else {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11121, new Object[]{routingMode});
            throw ce;
        }
    }

    public int getMaxCacheSize() {
        return 0;
    }

    public void setMaxCacheSize(int size) {
    }

    public long getMessageTTL() {
        return this.messageTTL;
    }

    public void setMessageTTL(long ttl) {
        this.messageTTL = ttl;
    }

    public boolean isDisallowWildcardSubtopics() {
        return this.disallowWildcardSubtopics;
    }

    public void setDisallowWildcardSubtopics(boolean value) {
        this.disallowWildcardSubtopics = value;
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public void setDurable(boolean durable) {
        this.isDurable = durable;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority = priority < 0 ? 0 : (priority > 9 ? 9 : priority);
    }

    public String getSubtopicSeparator() {
        return this.subtopicSeparator;
    }

    public void setSubtopicSeparator(String value) {
        this.subtopicSeparator = value;
    }
}

