/*
 * Decompiled with CFR 0.152.
 */
package linearFit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import po.Point;

public class Line {
    public static List<Point> buildLine(double[] arrX, double[] arrY, int length, int dimension, double scale) {
        ArrayList<Point> points = new ArrayList<Point>();
        if (arrX.length != arrY.length || arrX.length < 3) {
            return points;
        }
        double minValue = arrY[0];
        double maxValue = arrY[arrY.length - 1];
        double min = 0.0;
        double max = 0.0;
        double[] coefficient = Line.multiLine(arrX, arrY, length, dimension);
        double i = arrX[0];
        while (i <= arrX[arrX.length - 1]) {
            Point point = new Point();
            BigDecimal bg = new BigDecimal(i);
            double f1 = bg.setScale(2, 4).doubleValue();
            point.setX(f1);
            int j = 0;
            while (j < coefficient.length) {
                double temp = point.getY() + (double)((float)(coefficient[j] * Math.pow(point.getX(), j)));
                point.setY(temp);
                ++j;
            }
            if (point.getY() < minValue) {
                point.setY(minValue);
            }
            if (point.getY() > maxValue) {
                point.setY(maxValue);
            }
            if (point.getY() < min) {
                min = point.getY();
            }
            if (point.getY() > max) {
                max = point.getY();
            }
            points.add(point);
            i += scale;
        }
        Line.builder(points, min, max);
        return points;
    }

    private static void builder(List<Point> points, double min, double max) {
        Boolean b = false;
        int i = 0;
        while (i < points.size()) {
            if (b.booleanValue()) {
                points.get(i).setX(max);
            } else if (max == points.get(i).getY()) {
                b = true;
            }
            ++i;
        }
        i = points.size() - 1;
        while (i > -1) {
            if (!b.booleanValue()) {
                points.get(i).setY(min);
            } else if (min == points.get(i).getY()) {
                b = false;
            }
            --i;
        }
    }

    public static double[] multiLine(double[] arrX, double[] arrY, int length, int dimension) {
        int n = dimension + 1;
        double[][] Guass = new double[n][n + 1];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                Guass[i][j] = Line.sumArr(arrX, j + i, length);
                ++j;
            }
            Guass[i][j] = Line.sumArr(arrX, i, arrY, 1, length);
            ++i;
        }
        return Line.computGauss(Guass, n);
    }

    public static double sumArr(double[] arr, int n, int length) {
        double s = 0.0;
        int i = 0;
        while (i < length) {
            s = arr[i] != 0.0 || n != 0 ? (s += Math.pow(arr[i], n)) : (s += 1.0);
            ++i;
        }
        return s;
    }

    public static double sumArr(double[] arr1, int n1, double[] arr2, int n2, int length) {
        double s = 0.0;
        int i = 0;
        while (i < length) {
            s = !(arr1[i] == 0.0 && n1 == 0 || arr2[i] == 0.0 && n2 == 0) ? (s += Math.pow(arr1[i], n1) * Math.pow(arr2[i], n2)) : (s += 1.0);
            ++i;
        }
        return s;
    }

    public static double[] computGauss(double[][] Guass, int n) {
        double s;
        double[] x = new double[n];
        int i = 0;
        while (i < n) {
            x[i] = 0.0;
            ++i;
        }
        int j = 0;
        while (j < n) {
            int m;
            double max = 0.0;
            int k = j;
            i = j;
            while (i < n) {
                if (Math.abs(Guass[i][j]) > max) {
                    max = Guass[i][j];
                    k = i;
                }
                ++i;
            }
            if (k != j) {
                m = j;
                while (m < n + 1) {
                    double temp = Guass[j][m];
                    Guass[j][m] = Guass[k][m];
                    Guass[k][m] = temp;
                    ++m;
                }
            }
            if (0.0 == max) {
                return x;
            }
            i = j + 1;
            while (i < n) {
                s = Guass[i][j];
                m = j;
                while (m < n + 1) {
                    Guass[i][m] = Guass[i][m] - Guass[j][m] * s / Guass[j][j];
                    ++m;
                }
                ++i;
            }
            ++j;
        }
        i = n - 1;
        while (i >= 0) {
            s = 0.0;
            j = i + 1;
            while (j < n) {
                s += Guass[i][j] * x[j];
                ++j;
            }
            x[i] = (Guass[i][n] - s) / Guass[i][i];
            --i;
        }
        return x;
    }
}

