/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.core.impl;

import com.google.code.yanf4j.buffer.IoBuffer;
import com.google.code.yanf4j.core.CodecFactory;
import com.google.code.yanf4j.core.Dispatcher;
import com.google.code.yanf4j.core.Handler;
import com.google.code.yanf4j.core.Session;
import com.google.code.yanf4j.core.SessionConfig;
import com.google.code.yanf4j.core.WriteMessage;
import com.google.code.yanf4j.statistics.Statistics;
import com.google.code.yanf4j.util.LinkedTransferQueue;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession
implements Session {
    protected IoBuffer readBuffer;
    protected static final Logger log = LoggerFactory.getLogger(AbstractSession.class);
    protected final ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap();
    protected Queue<WriteMessage> writeQueue;
    protected volatile long sessionIdleTimeout;
    protected volatile long sessionTimeout;
    protected CodecFactory.Encoder encoder;
    protected CodecFactory.Decoder decoder;
    protected volatile boolean closed;
    protected Statistics statistics;
    protected Handler handler;
    protected boolean loopback;
    public AtomicLong lastOperationTimeStamp = new AtomicLong(0L);
    protected AtomicLong scheduleWritenBytes = new AtomicLong(0L);
    protected final Dispatcher dispatchMessageDispatcher;
    protected volatile boolean useBlockingWrite = false;
    protected volatile boolean useBlockingRead = true;
    protected volatile boolean handleReadWriteConcurrently = true;
    protected ReentrantLock writeLock = new ReentrantLock();
    protected AtomicReference<WriteMessage> currentMessage = new LinkedTransferQueue.PaddedAtomicReference<Object>(null);

    @Override
    public long getSessionIdleTimeout() {
        return this.sessionIdleTimeout;
    }

    @Override
    public void setSessionIdleTimeout(long sessionIdleTimeout) {
        this.sessionIdleTimeout = sessionIdleTimeout;
    }

    @Override
    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Queue<WriteMessage> getWriteQueue() {
        return this.writeQueue;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    public Dispatcher getDispatchMessageDispatcher() {
        return this.dispatchMessageDispatcher;
    }

    public ReentrantLock getWriteLock() {
        return this.writeLock;
    }

    public abstract void decode();

    public void updateTimeStamp() {
        this.lastOperationTimeStamp.set(System.currentTimeMillis());
    }

    @Override
    public long getLastOperationTimeStamp() {
        return this.lastOperationTimeStamp.get();
    }

    @Override
    public final boolean isHandleReadWriteConcurrently() {
        return this.handleReadWriteConcurrently;
    }

    @Override
    public final void setHandleReadWriteConcurrently(boolean handleReadWriteConcurrently) {
        this.handleReadWriteConcurrently = handleReadWriteConcurrently;
    }

    @Override
    public long getScheduleWritenBytes() {
        return this.scheduleWritenBytes.get();
    }

    @Override
    public CodecFactory.Encoder getEncoder() {
        return this.encoder;
    }

    @Override
    public void setEncoder(CodecFactory.Encoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public CodecFactory.Decoder getDecoder() {
        return this.decoder;
    }

    public IoBuffer getReadBuffer() {
        return this.readBuffer;
    }

    public void setReadBuffer(IoBuffer readBuffer) {
        this.readBuffer = readBuffer;
    }

    @Override
    public void setDecoder(CodecFactory.Decoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public final ByteOrder getReadBufferByteOrder() {
        if (this.readBuffer == null) {
            throw new IllegalStateException();
        }
        return this.readBuffer.order();
    }

    @Override
    public final void setReadBufferByteOrder(ByteOrder readBufferByteOrder) {
        if (this.readBuffer == null) {
            throw new NullPointerException("Null ReadBuffer");
        }
        this.readBuffer.order(readBufferByteOrder);
    }

    protected synchronized void onIdle() {
        try {
            if (this.isIdle()) {
                this.updateTimeStamp();
                this.handler.onSessionIdle(this);
            }
        }
        catch (Throwable e) {
            this.onException(e);
        }
    }

    protected void onConnected() {
        try {
            this.handler.onSessionConnected(this);
        }
        catch (Throwable e) {
            this.onException(e);
        }
    }

    public void onExpired() {
        try {
            if (this.isExpired()) {
                this.handler.onSessionExpired(this);
            }
        }
        catch (Throwable e) {
            this.onException(e);
        }
    }

    protected abstract WriteMessage wrapMessage(Object var1, Future<Boolean> var2);

    protected WriteMessage preprocessWriteMessage(WriteMessage writeMessage) {
        return writeMessage;
    }

    protected void dispatchReceivedMessage(final Object message) {
        if (this.dispatchMessageDispatcher == null) {
            long start = -1L;
            if (this.statistics != null && this.statistics.isStatistics()) {
                start = System.currentTimeMillis();
            }
            this.onMessage(message, this);
            if (start != -1L) {
                this.statistics.statisticsProcess(System.currentTimeMillis() - start);
            }
        } else {
            this.dispatchMessageDispatcher.dispatch(new Runnable(){

                public void run() {
                    long start = -1L;
                    if (AbstractSession.this.statistics != null && AbstractSession.this.statistics.isStatistics()) {
                        start = System.currentTimeMillis();
                    }
                    AbstractSession.this.onMessage(message, AbstractSession.this);
                    if (start != -1L) {
                        AbstractSession.this.statistics.statisticsProcess(System.currentTimeMillis() - start);
                    }
                }
            });
        }
    }

    private void onMessage(Object message, Session session) {
        try {
            this.handler.onMessageReceived(session, message);
        }
        catch (Throwable e) {
            this.onException(e);
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    public final void setClosed(boolean closed) {
        this.closed = closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            if (this.isClosed()) {
                return;
            }
            this.setClosed(true);
        }
        try {
            this.closeChannel();
            this.clearAttributes();
            log.debug("session closed");
        }
        catch (IOException e) {
            this.onException(e);
            log.error("Close session error", (Throwable)e);
        }
        finally {
            this.onClosed();
        }
    }

    protected abstract void closeChannel() throws IOException;

    public void onException(Throwable e) {
        this.handler.onExceptionCaught(this, e);
    }

    protected void onClosed() {
        try {
            this.handler.onSessionClosed(this);
        }
        catch (Throwable e) {
            this.onException(e);
        }
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object setAttributeIfAbsent(String key, Object value) {
        return this.attributes.putIfAbsent(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public synchronized void start() {
        log.debug("session started");
        this.onStarted();
        this.start0();
    }

    protected abstract void start0();

    protected void onStarted() {
        try {
            this.handler.onSessionStarted(this);
        }
        catch (Throwable e) {
            this.onException(e);
        }
    }

    @Override
    public void write(Object packet) {
        if (this.closed) {
            return;
        }
        WriteMessage message = this.wrapMessage(packet, null);
        this.scheduleWritenBytes.addAndGet(message.getWriteBuffer().remaining());
        this.writeFromUserCode(message);
    }

    public abstract void writeFromUserCode(WriteMessage var1);

    @Override
    public final boolean isLoopbackConnection() {
        return this.loopback;
    }

    @Override
    public boolean isUseBlockingWrite() {
        return this.useBlockingWrite;
    }

    @Override
    public void setUseBlockingWrite(boolean useBlockingWrite) {
        this.useBlockingWrite = useBlockingWrite;
    }

    @Override
    public boolean isUseBlockingRead() {
        return this.useBlockingRead;
    }

    @Override
    public void setUseBlockingRead(boolean useBlockingRead) {
        this.useBlockingRead = useBlockingRead;
    }

    public void clearWriteQueue() {
        this.writeQueue.clear();
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public boolean isIdle() {
        long lastOpTimestamp = this.getLastOperationTimeStamp();
        return lastOpTimestamp > 0L && System.currentTimeMillis() - lastOpTimestamp > this.sessionIdleTimeout;
    }

    public AbstractSession(SessionConfig sessionConfig) {
        this.lastOperationTimeStamp.set(System.currentTimeMillis());
        this.statistics = sessionConfig.statistics;
        this.handler = sessionConfig.handler;
        this.writeQueue = sessionConfig.queue;
        this.encoder = sessionConfig.codecFactory.getEncoder();
        this.decoder = sessionConfig.codecFactory.getDecoder();
        this.dispatchMessageDispatcher = sessionConfig.dispatchMessageDispatcher;
        this.handleReadWriteConcurrently = sessionConfig.handleReadWriteConcurrently;
        this.sessionTimeout = sessionConfig.sessionTimeout;
        this.sessionIdleTimeout = sessionConfig.sessionIdelTimeout;
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long transferFrom(long position, long count, FileChannel source) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void onCreated() {
        try {
            this.handler.onSessionCreated(this);
        }
        catch (Throwable e) {
            this.onException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FailFuture
    implements Future<Boolean> {
        FailFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean get() throws InterruptedException, ExecutionException {
            return Boolean.FALSE;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return Boolean.FALSE;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

