/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.yb;

import cn.gyee.appsoft.jrt.yb.DNAPointConfig;
import cn.gyee.appsoft.jrt.yb.DNAPointVal;
import cn.gyee.appsoft.jrt.yb.DNAVal;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;

public class ApiWriteEntry {
    int MAX_PACKET_SIZE = 8192;
    private DatagramPacket _packet;
    private ByteBuffer _data;
    private Socket _socket;
    private boolean _isConnected = false;
    private boolean _ackPacket;
    private String _ip;
    private int _port;

    static byte[] toLH(int n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return b;
    }

    static byte[] toHH(int n) {
        byte[] b = new byte[4];
        b[3] = (byte)(n & 0xFF);
        b[2] = (byte)(n >> 8 & 0xFF);
        b[1] = (byte)(n >> 16 & 0xFF);
        b[0] = (byte)(n >> 24 & 0xFF);
        return b;
    }

    static byte[] toLH(short n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return b;
    }

    static byte[] toHH(short n) {
        byte[] b = new byte[2];
        b[1] = (byte)(n & 0xFF);
        b[0] = (byte)(n >> 8 & 0xFF);
        return b;
    }

    static byte[] getBytes(double data) {
        long intBits = Double.doubleToLongBits(data);
        return ApiWriteEntry.getBytes(intBits);
    }

    static byte[] getBytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
        return bytes;
    }

    static final String padRight(String str, int len) {
        char[] chars = new char[len];
        int i = 0;
        while (i < chars.length) {
            chars[i] = '\u0000';
            ++i;
        }
        char[] strChars = str.toCharArray();
        len = strChars.length < len ? strChars.length : --len;
        System.arraycopy(strChars, 0, chars, 0, len);
        return new String(chars);
    }

    public ApiWriteEntry(boolean ackPacket) throws SocketException {
        this._ackPacket = ackPacket;
        this._data = ByteBuffer.allocate(this.MAX_PACKET_SIZE);
        this._packet = new DatagramPacket(this._data.array(), this._data.capacity());
    }

    public void disconnect() throws IOException {
        if (this._socket != null && this._socket.isConnected()) {
            this._socket.close();
        }
    }

    public synchronized boolean connect(String ip, int port) throws IOException {
        this._isConnected = false;
        if (this._socket != null && this._socket.isConnected()) {
            this._socket.close();
        }
        this._socket = new Socket(InetAddress.getByName(ip), port);
        this._socket.setSoTimeout(10000);
        this._isConnected = true;
        this._ip = ip;
        this._port = port;
        return this._isConnected;
    }

    private synchronized boolean reConnect() {
        try {
            this._isConnected = false;
            if (this._socket != null && this._socket.isConnected()) {
                this._socket.close();
            }
            this._socket = new Socket(InetAddress.getByName(this._ip), this._port);
            this._socket.setSoTimeout(10000);
            this._isConnected = true;
            return this._isConnected;
        }
        catch (Exception e) {
            this._socket = null;
            this._isConnected = false;
            return this._isConnected;
        }
    }

    void sendAndReceive(Socket socket) throws IOException {
        this._packet.setLength(this._data.position());
        this._packet.setSocketAddress(socket.getRemoteSocketAddress());
        socket.getOutputStream().write(this._data.array(), 0, this._data.position());
        this._packet.setLength(this._data.capacity());
        if (this._ackPacket) {
            socket.getInputStream().read(this._data.array());
        }
    }

    public synchronized int writeSinglePoint(String point, DNAVal ... vals) {
        if (this._socket == null && !this.reConnect()) {
            return -1;
        }
        try {
            int size = vals.length;
            int maxPointsPerCall = 160;
            int loops = size % maxPointsPerCall == 0 ? size / maxPointsPerCall : size / maxPointsPerCall + 1;
            int index = 0;
            do {
                int remains = size - index * maxPointsPerCall;
                int start = index * maxPointsPerCall;
                int count = remains >= maxPointsPerCall ? maxPointsPerCall : remains;
                int end = start + count;
                this._data.clear();
                this._data.put(new byte[]{-2, -2});
                this._data.put(ApiWriteEntry.toLH(count * 16 + 12 + 9));
                this._data.put(ApiWriteEntry.toLH((short)2));
                this._data.put(ApiWriteEntry.toLH((short)count));
                this._data.put(ApiWriteEntry.padRight(point, 9).getBytes());
                while (start < end) {
                    this._data.put(ApiWriteEntry.toLH(vals[start].Time));
                    this._data.put(ApiWriteEntry.toLH((short)0));
                    this._data.put(ApiWriteEntry.toLH(vals[start].Status));
                    this._data.put(ApiWriteEntry.getBytes(vals[start].DValue));
                    ++start;
                }
                this._data.put(new byte[]{-17, -17});
                this.sendAndReceive(this._socket);
                ++index;
            } while (--loops > 0);
            return 0;
        }
        catch (Exception ed) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this._socket = null;
            System.out.println("deleteConfigRec error : " + ed.getMessage());
            return -1;
        }
    }

    public synchronized int writeSingleLongPoint(String point, DNAVal ... vals) {
        if (this._socket == null && !this.reConnect()) {
            return -1;
        }
        try {
            int size = vals.length;
            int maxPointsPerCall = 500;
            int loops = size % maxPointsPerCall == 0 ? size / maxPointsPerCall : size / maxPointsPerCall + 1;
            int index = 0;
            do {
                int remains = size - index * maxPointsPerCall;
                int start = index * maxPointsPerCall;
                int count = remains >= maxPointsPerCall ? maxPointsPerCall : remains;
                int end = start + count;
                this._data.clear();
                this._data.put(new byte[]{-2, -2});
                this._data.put(ApiWriteEntry.toLH(count * 16 + 12 + 61));
                this._data.put(ApiWriteEntry.toLH((short)7));
                this._data.put(ApiWriteEntry.toLH((short)count));
                this._data.put(ApiWriteEntry.padRight(point, 61).getBytes());
                while (start < end) {
                    this._data.put(ApiWriteEntry.toLH(vals[start].Time));
                    this._data.put(ApiWriteEntry.toLH((short)0));
                    this._data.put(ApiWriteEntry.toLH(vals[start].Status));
                    this._data.put(ApiWriteEntry.getBytes(vals[start].DValue));
                    ++start;
                }
                this._data.put(new byte[]{-17, -17});
                this.sendAndReceive(this._socket);
                ++index;
            } while (--loops > 0);
            return 0;
        }
        catch (Exception ed) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this._socket = null;
            System.out.println("writeSinglePoint error : " + ed.getMessage());
            return -1;
        }
    }

    public synchronized int writeMultiLongPoint(DNAPointVal ... vals) {
        if (this._socket == null && !this.reConnect()) {
            return -1;
        }
        try {
            int size = vals.length;
            int maxPointsPerCall = 100;
            int loops = size % maxPointsPerCall == 0 ? size / maxPointsPerCall : size / maxPointsPerCall + 1;
            int index = 0;
            do {
                int remains = size - index * maxPointsPerCall;
                int start = index * maxPointsPerCall;
                int count = remains >= maxPointsPerCall ? maxPointsPerCall : remains;
                int end = start + count;
                this._data.clear();
                this._data.put(new byte[]{-2, -2});
                this._data.put(ApiWriteEntry.toLH(count * 77 + 12));
                this._data.put(ApiWriteEntry.toLH((short)6));
                this._data.put(ApiWriteEntry.toLH((short)count));
                while (start < end) {
                    this._data.put(ApiWriteEntry.toLH(vals[start].Val.Time));
                    this._data.put(ApiWriteEntry.toLH((short)0));
                    this._data.put(ApiWriteEntry.padRight(vals[start].Name, 61).getBytes());
                    this._data.put(ApiWriteEntry.toLH(vals[start].Val.Status));
                    this._data.put(ApiWriteEntry.getBytes(vals[start].Val.DValue));
                    ++start;
                }
                this._data.put(new byte[]{-17, -17});
                this.sendAndReceive(this._socket);
                ++index;
            } while (--loops > 0);
            return 0;
        }
        catch (Exception ed) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this._socket = null;
            System.out.println("writeMultiPoint error : " + ed.getMessage());
            return -1;
        }
    }

    public synchronized int writeMultiPoint(DNAPointVal ... vals) {
        if (this._socket == null && !this.reConnect()) {
            return -1;
        }
        try {
            int size = vals.length;
            int maxPointsPerCall = 160;
            int loops = size % maxPointsPerCall == 0 ? size / maxPointsPerCall : size / maxPointsPerCall + 1;
            int index = 0;
            do {
                int remains = size - index * maxPointsPerCall;
                int start = index * maxPointsPerCall;
                int count = remains >= maxPointsPerCall ? maxPointsPerCall : remains;
                int end = start + count;
                this._data.clear();
                this._data.put(new byte[]{-2, -2});
                this._data.put(ApiWriteEntry.toLH(count * 25 + 12));
                this._data.put(ApiWriteEntry.toLH((short)1));
                this._data.put(ApiWriteEntry.toLH((short)count));
                while (start < end) {
                    this._data.put(ApiWriteEntry.toLH(vals[start].Val.Time));
                    this._data.put(ApiWriteEntry.toLH((short)0));
                    this._data.put(ApiWriteEntry.padRight(vals[start].Name, 9).getBytes());
                    this._data.put(ApiWriteEntry.toLH(vals[start].Val.Status));
                    this._data.put(ApiWriteEntry.getBytes(vals[start].Val.DValue));
                    ++start;
                }
                this._data.put(new byte[]{-17, -17});
                this.sendAndReceive(this._socket);
                ++index;
            } while (--loops > 0);
            return 0;
        }
        catch (Exception ed) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this._socket = null;
            System.out.println("deleteConfigRec error : " + ed.getMessage());
            return -1;
        }
    }

    public synchronized int deleteConfigRec(String longid) {
        if (this._socket == null && !this.reConnect()) {
            return -1;
        }
        try {
            this._data.clear();
            this._data.put(new byte[]{-2, -2});
            this._data.put(ApiWriteEntry.toLH(73));
            this._data.put(ApiWriteEntry.toLH((short)14));
            this._data.put(ApiWriteEntry.toLH((short)1));
            this._data.put(ApiWriteEntry.padRight(longid.toUpperCase(), 61).getBytes());
            this._data.put(new byte[]{-17, -17});
            this.sendAndReceive(this._socket);
            return 0;
        }
        catch (Exception ed) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this._socket = null;
            System.out.println("deleteConfigRec error : " + ed.getMessage());
            return -1;
        }
    }

    public synchronized int SendConfigRec(DNAPointConfig ... recs) {
        if (this._socket == null && !this.reConnect()) {
            return -1;
        }
        try {
            DNAPointConfig[] dNAPointConfigArray = recs;
            int n = recs.length;
            int n2 = 0;
            while (n2 < n) {
                DNAPointConfig rec = dNAPointConfigArray[n2];
                this._data.clear();
                this._data.put(new byte[]{-2, -2});
                this._data.put(ApiWriteEntry.toLH(619));
                this._data.put(ApiWriteEntry.toLH((short)5));
                this._data.put(ApiWriteEntry.toLH((short)1));
                this._data.put(ApiWriteEntry.padRight(rec.shortID, 9).getBytes());
                this._data.put(ApiWriteEntry.padRight(rec.longID, 61).getBytes());
                this._data.put(ApiWriteEntry.padRight(rec.desc, 25).getBytes());
                this._data.put(ApiWriteEntry.padRight(rec.units, 9).getBytes());
                this._data.put(ApiWriteEntry.padRight(rec.szPointType, 3).getBytes());
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.padRight("", 17).getBytes());
                this._data.put(ApiWriteEntry.padRight("", 17).getBytes());
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.getBytes(0.0));
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.getBytes(0.0));
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.getBytes(0.0));
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.getBytes(0.0));
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.getBytes(0.0));
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.getBytes(0.0));
                this._data.put(ApiWriteEntry.toLH(1));
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.toLH(0));
                this._data.put(ApiWriteEntry.toLH(9999));
                this._data.put(ApiWriteEntry.getBytes(rec.dHistoryDeadBand));
                this._data.put(ApiWriteEntry.toLH(1));
                this._data.put(ApiWriteEntry.padRight(rec.longID, 129).getBytes());
                this._data.put(ApiWriteEntry.padRight(rec.desc, 225).getBytes());
                this._data.put(new byte[]{-17, -17});
                this.sendAndReceive(this._socket);
                ++n2;
            }
            return 0;
        }
        catch (Exception ed) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this._socket = null;
            System.out.println("SendConfigRec error : " + ed.getMessage());
            return -1;
        }
    }

    public static void main(String[] args) {
        try {
            ApiWriteEntry writer = new ApiWriteEntry(false);
            writer.connect("12.0.1.30", 10035);
            DNAPointVal[] vals = new DNAPointVal[10];
            int i = 0;
            while (i < vals.length) {
                vals[i] = new DNAPointVal();
                vals[i].Name = "HNJ0000" + (i + 1);
                vals[i].Val = new DNAVal();
                vals[i].Val.DValue = 88888.0;
                vals[i].Val.Status = (short)3;
                vals[i].Val.Time = 1395379411 + i;
                ++i;
            }
            writer.writeMultiPoint(vals);
            writer.disconnect();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

