/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.yb;

import cn.gyee.appsoft.jrt.common.EdnaApiHelper;
import cn.gyee.appsoft.jrt.yb.Crc16;
import cn.gyee.appsoft.jrt.yb.DNAPointConfig;
import cn.gyee.appsoft.jrt.yb.DNAPointVal;
import cn.gyee.appsoft.jrt.yb.DNAVal;
import cn.gyee.appsoft.jrt.yb.RealTimeServiceInfo;
import cn.gyee.appsoft.jrt.yb.ServiceInfo;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiEntry {
    double ERROR_VALUE = -1.7E308;
    int MAX_PACKET_SIZE = 8192;
    private DatagramPacket _packet;
    private ByteBuffer _data = ByteBuffer.allocate(this.MAX_PACKET_SIZE);
    private Crc16 _crc;
    private DatagramSocket _socket = new DatagramSocket();
    private static Map<String, RealTimeServiceInfo> _servMap = new HashMap<String, RealTimeServiceInfo>();
    private static Map<String, String> _shortidToLongidMaps = new HashMap<String, String>();
    private static Map<String, String> _longidToShortidTagMaps = new HashMap<String, String>();
    private boolean _isConnected = false;
    private SimpleDateFormat _format;
    public static int HIST_AVG = 1;
    public static int HIST_SNAP = 2;
    public static int HIST_MIN = 3;
    public static int HIST_MAX = 4;
    public int _timeout = 10000;

    public ApiEntry(String ip, int port) throws SocketException, UnknownHostException {
        this._socket.setSoTimeout(10000);
        this._packet = new DatagramPacket(this._data.array(), this._data.capacity());
        this._crc = new Crc16();
        this._format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!this.connect(ip, port)) {
            throw new SocketException("Connect to " + ip + " : " + port + " failed");
        }
    }

    public ApiEntry(String ip, int port, int timeout) throws SocketException, UnknownHostException {
        this(ip, port);
        this._timeout = timeout;
    }

    private synchronized boolean connect(String ip, int port) throws UnknownHostException {
        this._isConnected = false;
        if (this._socket.isConnected()) {
            this._socket.close();
        }
        this._socket.connect(InetAddress.getByName(ip), port);
        this._isConnected = true;
        return this._isConnected;
    }

    static byte[] toLH(int n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return b;
    }

    static byte[] toHH(int n) {
        byte[] b = new byte[4];
        b[3] = (byte)(n & 0xFF);
        b[2] = (byte)(n >> 8 & 0xFF);
        b[1] = (byte)(n >> 16 & 0xFF);
        b[0] = (byte)(n >> 24 & 0xFF);
        return b;
    }

    static byte[] toLH(short n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return b;
    }

    static byte[] toHH(short n) {
        byte[] b = new byte[2];
        b[1] = (byte)(n & 0xFF);
        b[0] = (byte)(n >> 8 & 0xFF);
        return b;
    }

    static final String padRight(String str, int len) {
        char[] chars = new char[len];
        int i = 0;
        while (i < chars.length) {
            chars[i] = '\u0000';
            ++i;
        }
        char[] strChars = str.toCharArray();
        if (strChars.length < len) {
            len = strChars.length;
        }
        System.arraycopy(strChars, 0, chars, 0, len);
        return new String(chars);
    }

    static final String padSpaceRight(String str, int len) {
        char[] chars = new char[len];
        int i = 0;
        while (i < chars.length) {
            chars[i] = 32;
            ++i;
        }
        char[] strChars = str.toCharArray();
        if (strChars.length < len) {
            len = strChars.length;
        }
        System.arraycopy(strChars, 0, chars, 0, len);
        return new String(chars);
    }

    static int toHHInt(byte[] data, int offset) {
        int s = 0;
        int end = offset + 3;
        int i = 0;
        while (i < 3) {
            s = data[end - i] >= 0 ? (s += data[end - i]) : s + 256 + data[end - i];
            s *= 256;
            ++i;
        }
        s = data[offset] >= 0 ? (s += data[offset]) : s + 256 + data[offset];
        return s;
    }

    static int lBytesToInt(byte[] b) {
        int s = 0;
        int i = 0;
        while (i < 3) {
            s = b[3 - i] >= 0 ? (s += b[3 - i]) : s + 256 + b[3 - i];
            s *= 256;
            ++i;
        }
        s = b[0] >= 0 ? (s += b[0]) : s + 256 + b[0];
        return s;
    }

    static short toHHShort(byte[] data, int offset) {
        int s = 0;
        s = data[offset + 1] >= 0 ? (s += data[offset + 1]) : s + 256 + data[offset + 1];
        s *= 256;
        s = data[offset] >= 0 ? (s += data[offset]) : s + 256 + data[offset];
        short result = (short)s;
        return result;
    }

    static void printHex(byte[] data, int length) {
        int i = 0;
        while (i < length) {
            System.out.printf("%x ", data[i]);
            ++i;
        }
    }

    static byte[] int2byte(int res) {
        byte[] targets = new byte[]{(byte)(res & 0xFF), (byte)(res >> 8 & 0xFF), (byte)(res >> 16 & 0xFF), (byte)(res >>> 24)};
        return targets;
    }

    private ServiceInfo loadServiceInfo(String site, String service) throws Exception {
        ServiceInfo info = null;
        try {
            this._data.clear();
            this._data.put(ApiEntry.toLH((short)512));
            this._data.put(ApiEntry.toLH((short)1));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put(ApiEntry.padRight(site, 8).getBytes());
            this._data.put(ApiEntry.padRight(service, 8).getBytes());
            int i = 0;
            while (i < 47) {
                this._data.put(ApiEntry.padRight("", 8).getBytes());
                this._data.put(ApiEntry.padRight("", 8).getBytes());
                ++i;
            }
            this.sendAndReceive(this._socket);
            byte[] data = this._data.array();
            short ret = ApiEntry.toHHShort(data, 4);
            if (ret == 0) {
                String ip = String.format("%d.%d.%d.%d", data[44] & 0xFF, data[45] & 0xFF, data[46] & 0xFF, data[47] & 0xFF);
                int port = Integer.valueOf(String.format("%x%x", data[42], data[43]), 16);
                if (!ip.equals("0.0.0.0") && port != 0) {
                    info = new ServiceInfo(service, ip, port);
                } else {
                    System.out.println("Service : " + service + " not running. ");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Get service : " + service + " failed . msg : " + e.getMessage());
            throw new Exception("Get service : " + service + " failed . msg : " + e.getMessage());
        }
        return info;
    }

    void sendAndReceive(DatagramSocket socket) throws IOException {
        int crc16 = this._crc.getCrc16(this._data.array(), this._data.position());
        this._data.put(ApiEntry.toLH(crc16), 0, 2);
        this._packet.setSocketAddress(socket.getRemoteSocketAddress());
        int position = this._data.position();
        int i = 0;
        int timeout = this._timeout;
        while (true) {
            try {
                socket.setSoTimeout(timeout);
                this._packet.setLength(position);
                socket.send(this._packet);
                this._packet.setLength(this._data.capacity());
                socket.receive(this._packet);
                return;
            }
            catch (Exception e) {
                System.out.println("socket send receive error : " + e.getMessage());
                timeout /= 2;
                if (++i <= 3) continue;
                throw new IOException(" socket receive timeout.");
            }
            break;
        }
    }

    private String findHistoryName(ServiceInfo realTime) throws Exception {
        String name = null;
        DatagramSocket socket = null;
        try {
            try {
                socket = new DatagramSocket();
                socket.setSoTimeout(500);
                socket.connect(InetAddress.getByName(realTime.get_ip()), realTime.get_port());
                this._data.clear();
                this._data.put(ApiEntry.toLH((short)7));
                this._data.put(ApiEntry.toLH((short)1));
                this._data.put(ApiEntry.toLH((short)0));
                this._data.put(ApiEntry.toLH((short)0));
                this.sendAndReceive(socket);
                byte[] data = this._data.array();
                short ret = ApiEntry.toHHShort(data, 4);
                if (ret == 0) {
                    name = new String(data, 224, 64, "gb2312").replace('\u0000', ' ').trim();
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(realTime.get_name()) + " loadHistoryName failed . msg : " + e.getMessage());
                throw new Exception(String.valueOf(realTime.get_name()) + " loadHistoryName failed . msg : " + e.getMessage());
            }
        }
        finally {
            if (socket != null && socket.isConnected()) {
                socket.close();
            }
        }
        return name;
    }

    private String findCmcfgName(ServiceInfo realTime) throws Exception {
        String name = null;
        DatagramSocket socket = null;
        try {
            try {
                socket = new DatagramSocket();
                socket.setSoTimeout(500);
                socket.connect(InetAddress.getByName(realTime.get_ip()), realTime.get_port());
                this._data.clear();
                this._data.put(ApiEntry.toLH((short)7));
                this._data.put(ApiEntry.toLH((short)1));
                this._data.put(ApiEntry.toLH((short)0));
                this._data.put(ApiEntry.toLH((short)0));
                this.sendAndReceive(socket);
                byte[] data = this._data.array();
                short ret = ApiEntry.toHHShort(data, 4);
                if (ret == 0) {
                    name = new String(data, 296, 64, "gb2312").replace('\u0000', ' ').trim();
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(realTime.get_name()) + " findCmcfgName failed . msg : " + e.getMessage());
                throw new Exception(String.valueOf(realTime.get_name()) + " findCmcfgName failed . msg : " + e.getMessage());
            }
        }
        finally {
            if (socket != null && socket.isConnected()) {
                socket.close();
            }
        }
        return name;
    }

    public int parseDateStringToUTC(String date) throws ParseException {
        return (int)(this._format.parse(date).getTime() / 1000L);
    }

    public synchronized boolean isConnected() {
        return this._isConnected;
    }

    private RealTimeServiceInfo findRealTimeServiceInfoByName(String tagName) throws Exception {
        String[] info = tagName.split("\\.");
        if (info.length == 3) {
            info[0] = info[0].trim();
            info[1] = info[1].trim();
            info[2] = info[2].trim();
            if (info[0].length() > 8 || info[1].length() > 8) {
                System.out.println("Error service name length,the length must less than 9");
                return null;
            }
            String serviceName = (String.valueOf(info[0]) + "." + info[1]).toLowerCase();
            if (!_servMap.containsKey(serviceName)) {
                RealTimeServiceInfo result = this.loadRealtimeServiceInfo(info[0], info[1]);
                if (result != null) {
                    if (!_servMap.containsKey(serviceName)) {
                        _servMap.put(serviceName, result);
                    }
                } else {
                    return null;
                }
            }
            return _servMap.get(serviceName);
        }
        return null;
    }

    private synchronized RealTimeServiceInfo loadRealtimeServiceInfo(String site, String service) throws Exception {
        ServiceInfo realTime;
        RealTimeServiceInfo info = null;
        if (this.isConnected() && (realTime = this.loadServiceInfo(site, service)) != null) {
            String historyName = this.findHistoryName(realTime);
            String cmcfgName = this.findCmcfgName(realTime);
            if (historyName != null && !historyName.equals("") && cmcfgName != null && !cmcfgName.equals("")) {
                String[] detail = historyName.split("\\.");
                ServiceInfo history = this.loadServiceInfo(detail[0], detail[1]);
                detail = cmcfgName.split("\\.");
                ServiceInfo cmcfg = this.loadServiceInfo(detail[0], detail[1]);
                if (history != null && cmcfg != null) {
                    info = new RealTimeServiceInfo(realTime, history, cmcfg);
                }
            }
        }
        return info;
    }

    private synchronized String switchToShortid(RealTimeServiceInfo info, String tagName) throws Exception {
        String key = tagName.toLowerCase();
        if (_shortidToLongidMaps.containsKey(key)) {
            return _shortidToLongidMaps.get(key);
        }
        if (info == null) {
            return tagName;
        }
        String[] detail = tagName.split("\\.");
        if (detail.length == 3 && detail[2].length() < 9) {
            return tagName;
        }
        StringBuilder longid = new StringBuilder(100);
        int i = 2;
        while (i < detail.length) {
            if (i == 2) {
                longid.append(detail[i]);
            } else {
                longid.append("." + detail[i]);
            }
            ++i;
        }
        ServiceInfo cmcfg = info.get_cmcfgServ();
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(2000);
            socket.connect(InetAddress.getByName(cmcfg.get_ip()), cmcfg.get_port());
            this._data.clear();
            this._data.put(ApiEntry.toLH((short)1000));
            this._data.put(ApiEntry.toLH((short)1));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put("C7".getBytes());
            this._data.put(ApiEntry.padSpaceRight(longid.toString().toUpperCase(), 60).getBytes());
            this._data.put(ApiEntry.padRight("", 8).getBytes());
            this._data.put(ApiEntry.padRight("", 8).getBytes());
            this._data.put(ApiEntry.padRight("", 8).getBytes());
            this._data.put(ApiEntry.padRight("", 10).getBytes());
            this._data.put(ApiEntry.padRight("", 4).getBytes());
            this.sendAndReceive(socket);
            byte[] data = this._data.array();
            short ret = ApiEntry.toHHShort(data, 4);
            if (ret == 0) {
                short count = ApiEntry.toHHShort(data, 2);
                byte[] keys = new byte[35];
                System.arraycopy(data, 96, keys, 0, 10);
                keys[10] = 0;
                if (count > 0) {
                    this._data.clear();
                    this._data.put(ApiEntry.toLH((short)1001));
                    this._data.put(ApiEntry.toLH((short)1));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(keys);
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.padRight("", 4).getBytes());
                    this._data.put(ApiEntry.toLH((short)0));
                    this.sendAndReceive(socket);
                    data = this._data.array();
                    ret = ApiEntry.toHHShort(data, 4);
                    if (ret == 0) {
                        String shortid = String.valueOf(detail[0]) + "." + detail[1] + "." + new String(data, 133, 8, "gb2312").replace('\u0000', ' ').trim();
                        _shortidToLongidMaps.put(key, shortid);
                        String string = shortid;
                        return string;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(tagName) + " switchToShortid failed . msg : " + e.getMessage());
            throw new Exception(String.valueOf(tagName) + " switchToShortid failed . msg : " + e.getMessage());
        }
        finally {
            if (socket != null && socket.isConnected()) {
                socket.close();
            }
        }
        return tagName;
    }

    private synchronized String switchToLongid(RealTimeServiceInfo info, String tagName) throws Exception {
        String key = tagName.toLowerCase();
        if (_longidToShortidTagMaps.containsKey(key)) {
            return _longidToShortidTagMaps.get(key);
        }
        if (info == null) {
            return tagName;
        }
        String[] detail = tagName.split("\\.");
        if (detail.length == 3 && detail[2].length() > 8) {
            return tagName;
        }
        StringBuilder shortid = new StringBuilder(100);
        int i = 2;
        while (i < detail.length) {
            if (i == 2) {
                shortid.append(detail[i]);
            } else {
                shortid.append("." + detail[i]);
            }
            ++i;
        }
        ServiceInfo cmcfg = info.get_cmcfgServ();
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(2000);
            socket.connect(InetAddress.getByName(cmcfg.get_ip()), cmcfg.get_port());
            this._data.clear();
            this._data.put(ApiEntry.toLH((short)1000));
            this._data.put(ApiEntry.toLH((short)1));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put("C4".getBytes());
            this._data.put(ApiEntry.padSpaceRight(detail[0], 8).getBytes());
            this._data.put(ApiEntry.padSpaceRight(detail[1], 8).getBytes());
            this._data.put(ApiEntry.padSpaceRight(shortid.toString().toUpperCase(), 8).getBytes());
            this._data.put(ApiEntry.padSpaceRight("", 4).getBytes());
            this._data.put(ApiEntry.padSpaceRight("", 8).getBytes());
            this._data.put((byte)1);
            this._data.put(ApiEntry.padSpaceRight("", 10).getBytes());
            this.sendAndReceive(socket);
            byte[] data = this._data.array();
            short ret = ApiEntry.toHHShort(data, 4);
            if (ret == 0) {
                short count = ApiEntry.toHHShort(data, 2);
                byte[] keys = new byte[35];
                System.arraycopy(data, 49, keys, 0, 10);
                keys[10] = 0;
                if (count > 0) {
                    this._data.clear();
                    this._data.put(ApiEntry.toLH((short)1001));
                    this._data.put(ApiEntry.toLH((short)1));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(keys);
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.padRight("", 4).getBytes());
                    this._data.put(ApiEntry.toLH((short)0));
                    this.sendAndReceive(socket);
                    data = this._data.array();
                    ret = ApiEntry.toHHShort(data, 4);
                    if (ret == 0) {
                        String longid = String.valueOf(detail[0]) + "." + detail[1] + "." + new String(data, 141, 60, "gb2312").replace('\u0000', ' ').trim();
                        _longidToShortidTagMaps.put(key, longid);
                        String string = longid;
                        return string;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(tagName) + " switchToLongid failed . msg : " + e.getMessage());
            throw new Exception(String.valueOf(tagName) + " switchToLongid failed . msg : " + e.getMessage());
        }
        finally {
            if (socket != null && socket.isConnected()) {
                socket.close();
            }
        }
        return tagName;
    }

    private DNAVal getRealtimeTagValue(ServiceInfo info, String tagName) throws Exception {
        DNAVal val = null;
        DatagramSocket socket = null;
        try {
            try {
                String value;
                socket = new DatagramSocket();
                socket.setSoTimeout(500);
                socket.connect(InetAddress.getByName(info.get_ip()), info.get_port());
                this._data.clear();
                this._data.put(ApiEntry.toLH((short)3));
                this._data.put(ApiEntry.toLH((short)1));
                this._data.put(ApiEntry.toLH((short)0));
                this._data.put(ApiEntry.toLH((short)0));
                this._data.put(ApiEntry.padRight(tagName.split("\\.")[2].trim(), 8).getBytes());
                int i = 0;
                while (i < 31) {
                    this._data.put(ApiEntry.padRight("", 8).getBytes());
                    ++i;
                }
                this.sendAndReceive(socket);
                byte[] data = this._data.array();
                short ret = ApiEntry.toHHShort(data, 4);
                if (ret == 0 && !(value = new String(data, 48, 16, "gb2312").replace('\u0000', ' ').trim()).equals("")) {
                    val = new DNAVal();
                    val.Status = ApiEntry.toHHShort(data, 10);
                    val.DValue = Double.parseDouble(value);
                    val.Time = ApiEntry.toHHInt(data, 12);
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(tagName) + " getRealtimeTagValue failed . msg : " + e.getMessage());
                throw new Exception(String.valueOf(tagName) + " getRealtimeTagValue failed . msg : " + e.getMessage());
            }
        }
        finally {
            if (socket != null && socket.isConnected()) {
                socket.close();
            }
        }
        return val;
    }

    private Map<String, DNAVal> getRealtimeTagValues(ServiceInfo info, List<String> tagNames, Map<String, String> maps) throws Exception {
        HashMap<String, DNAVal> result = new HashMap<String, DNAVal>();
        DatagramSocket socket = null;
        try {
            try {
                socket = new DatagramSocket();
                socket.setSoTimeout(500);
                socket.connect(InetAddress.getByName(info.get_ip()), info.get_port());
                int size = tagNames.size();
                int maxPointsPerCall = 32;
                int loops = size % maxPointsPerCall == 0 ? size / maxPointsPerCall : size / maxPointsPerCall + 1;
                int index = 0;
                do {
                    int remains = size - index * maxPointsPerCall;
                    int start = index * maxPointsPerCall;
                    int count = remains >= maxPointsPerCall ? maxPointsPerCall : remains;
                    int end = start + count;
                    this._data.clear();
                    this._data.put(ApiEntry.toLH((short)3));
                    this._data.put(ApiEntry.toLH((short)count));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.toLH((short)0));
                    while (start < end) {
                        this._data.put(ApiEntry.padRight(tagNames.get(start), 8).getBytes());
                        ++start;
                    }
                    this.sendAndReceive(socket);
                    byte[] data = this._data.array();
                    short ret = ApiEntry.toHHShort(data, 4);
                    int retCount = ApiEntry.toHHShort(data, 2);
                    if (ret == 0) {
                        int i = 0;
                        while (i < retCount) {
                            String value;
                            String shortID = new String(data, 8 + 64 * i + 8, 8, "gb2312").replace('\u0000', ' ').trim().toLowerCase();
                            if (maps.containsKey(shortID) && !(value = new String(data, 8 + 64 * i + 40, 16, "gb2312").replace('\u0000', ' ').trim()).equals("")) {
                                DNAVal val = new DNAVal();
                                val.Status = ApiEntry.toHHShort(data, 8 + 64 * i + 2);
                                val.DValue = Double.parseDouble(value);
                                val.Time = ApiEntry.toHHInt(data, 8 + 64 * i + 4);
                                result.put(maps.get(shortID), val);
                            }
                            ++i;
                        }
                    }
                    ++index;
                } while (--loops > 0);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(info.get_name()) + " getRealtimeTagValues Group failed . msg : " + e.getMessage());
                throw new Exception(String.valueOf(info.get_name()) + " getRealtimeTagValues Group failed . msg : " + e.getMessage());
            }
        }
        finally {
            if (socket != null && socket.isConnected()) {
                socket.close();
            }
        }
        return result;
    }

    private synchronized Map<String, DNAVal> queryHistoryRawValue(ServiceInfo info, String tagName, int tStart, int tEnd) throws Exception {
        HashMap<String, DNAVal> result;
        block14: {
            result = new HashMap<String, DNAVal>();
            DatagramSocket socket = null;
            try {
                try {
                    socket = new DatagramSocket();
                    socket.setSoTimeout(5000);
                    socket.connect(InetAddress.getByName(info.get_ip()), info.get_port());
                    this._data.clear();
                    this._data.put(ApiEntry.toLH((short)551));
                    this._data.put(ApiEntry.toLH((short)160));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.toLH((short)0));
                    String[] names = tagName.split("\\.");
                    this._data.put(ApiEntry.padRight(names[0].trim(), 8).getBytes());
                    this._data.put(ApiEntry.padRight(names[1].trim(), 8).getBytes());
                    this._data.put(ApiEntry.padRight(names[2].trim(), 8).getBytes());
                    this._data.put((byte)0);
                    this._data.put(ApiEntry.toLH(tStart - 1));
                    this._data.put(ApiEntry.toLH(tEnd + 1));
                    this.sendAndReceive(socket);
                    byte[] data = this._data.array();
                    short ret = ApiEntry.toHHShort(data, 4);
                    int offset = 15;
                    if (ret != 0) break block14;
                    int tTime = 0;
                    DNAVal val = null;
                    int length = ApiEntry.toHHShort(data, 2);
                    int i = 0;
                    while (i < length) {
                        String sVal = new String(data, offset + i * 24 + 6, 16, "gb2312").replace('\u0000', ' ').trim();
                        if (!sVal.isEmpty()) {
                            sVal = sVal.split(" ")[0];
                            tTime = ApiEntry.toHHInt(data, offset + i * 24);
                            val = new DNAVal();
                            val.DValue = Double.parseDouble(sVal);
                            val.Status = ApiEntry.toHHShort(data, offset + i * 24 + 4);
                            val.Time = ApiEntry.toHHInt(data, offset + i * 24);
                            if (tTime >= tStart && tTime <= tEnd) {
                                result.put(this._format.format(new Date((long)tTime * 1000L)), val);
                            }
                        }
                        ++i;
                    }
                    boolean bDone = data[14] == 1;
                    byte[] nBi = new byte[7];
                    while (!bDone) {
                        System.arraycopy(data, 8, nBi, 0, 7);
                        this._data.clear();
                        this._data.put(ApiEntry.toLH((short)552));
                        this._data.put(ApiEntry.toLH((short)160));
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(nBi);
                        this.sendAndReceive(socket);
                        data = this._data.array();
                        ret = ApiEntry.toHHShort(data, 4);
                        offset = 15;
                        if (ret == 0) {
                            tTime = 0;
                            length = ApiEntry.toHHShort(data, 2);
                            int i2 = 0;
                            while (i2 < length) {
                                String sVal = new String(data, offset + i2 * 24 + 6, 16, "gb2312").replace('\u0000', ' ').trim();
                                if (!sVal.isEmpty()) {
                                    sVal = sVal.split(" ")[0];
                                    tTime = ApiEntry.toHHInt(data, offset + i2 * 24);
                                    val = new DNAVal();
                                    val.DValue = Double.parseDouble(sVal);
                                    val.Status = ApiEntry.toHHShort(data, offset + i2 * 24 + 4);
                                    val.Time = ApiEntry.toHHInt(data, offset + i2 * 24);
                                    if (tTime >= tStart && tTime <= tEnd) {
                                        result.put(this._format.format(new Date((long)tTime * 1000L)), val);
                                    }
                                }
                                ++i2;
                            }
                            boolean bl = bDone = data[14] == 1;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(tagName) + " queryHistoryRawValue failed . msg : " + e.getMessage());
                    throw new Exception(String.valueOf(tagName) + " queryHistoryRawValue failed . msg : " + e.getMessage());
                }
            }
            finally {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
        }
        return result;
    }

    private synchronized List<DNAVal> queryHistoryRawListValue(ServiceInfo info, String tagName, int tStart, int tEnd) throws Exception {
        ArrayList<DNAVal> result;
        block14: {
            result = new ArrayList<DNAVal>();
            DatagramSocket socket = null;
            try {
                try {
                    socket = new DatagramSocket();
                    socket.setSoTimeout(5000);
                    socket.connect(InetAddress.getByName(info.get_ip()), info.get_port());
                    this._data.clear();
                    this._data.put(ApiEntry.toLH((short)551));
                    this._data.put(ApiEntry.toLH((short)160));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.toLH((short)0));
                    String[] names = tagName.split("\\.");
                    this._data.put(ApiEntry.padRight(names[0].trim(), 8).getBytes());
                    this._data.put(ApiEntry.padRight(names[1].trim(), 8).getBytes());
                    this._data.put(ApiEntry.padRight(names[2].trim(), 8).getBytes());
                    this._data.put((byte)0);
                    this._data.put(ApiEntry.toLH(tStart - 1));
                    this._data.put(ApiEntry.toLH(tEnd + 1));
                    this.sendAndReceive(socket);
                    byte[] data = this._data.array();
                    short ret = ApiEntry.toHHShort(data, 4);
                    int offset = 15;
                    if (ret != 0) break block14;
                    int tTime = 0;
                    DNAVal val = null;
                    int length = ApiEntry.toHHShort(data, 2);
                    int i = 0;
                    while (i < length) {
                        tTime = ApiEntry.toHHInt(data, offset + i * 24);
                        val = new DNAVal();
                        String sVal = new String(data, offset + i * 24 + 6, 16, "gb2312").replace('\u0000', ' ').trim();
                        if (!sVal.isEmpty()) {
                            val.DValue = Double.parseDouble(sVal);
                            val.Status = ApiEntry.toHHShort(data, offset + i * 24 + 4);
                            val.Time = ApiEntry.toHHInt(data, offset + i * 24);
                            if (tTime >= tStart && tTime <= tEnd) {
                                result.add(val);
                            }
                        }
                        ++i;
                    }
                    boolean bDone = data[14] == 1;
                    byte[] nBi = new byte[7];
                    while (!bDone) {
                        System.arraycopy(data, 8, nBi, 0, 7);
                        this._data.clear();
                        this._data.put(ApiEntry.toLH((short)552));
                        this._data.put(ApiEntry.toLH((short)160));
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(nBi);
                        this.sendAndReceive(socket);
                        data = this._data.array();
                        ret = ApiEntry.toHHShort(data, 4);
                        offset = 15;
                        if (ret == 0) {
                            tTime = 0;
                            length = ApiEntry.toHHShort(data, 2);
                            int i2 = 0;
                            while (i2 < length) {
                                tTime = ApiEntry.toHHInt(data, offset + i2 * 24);
                                val = new DNAVal();
                                String sVal = new String(data, offset + i2 * 24 + 6, 16, "gb2312").replace('\u0000', ' ').trim();
                                if (!sVal.isEmpty()) {
                                    val.DValue = Double.parseDouble(sVal);
                                    val.Status = ApiEntry.toHHShort(data, offset + i2 * 24 + 4);
                                    val.Time = ApiEntry.toHHInt(data, offset + i2 * 24);
                                    if (tTime >= tStart && tTime <= tEnd) {
                                        result.add(val);
                                    }
                                }
                                ++i2;
                            }
                            boolean bl = bDone = data[14] == 1;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    throw new Exception(String.valueOf(tagName) + " queryHistoryRawListValue failed . msg : " + e.getMessage());
                }
            }
            finally {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
        }
        return result;
    }

    public List<DNAVal> getHistoryTagRawValues(String tagName, int startUTC, int endUTC) throws Exception {
        List<DNAVal> result = new ArrayList<DNAVal>();
        RealTimeServiceInfo info = this.findRealTimeServiceInfoByName(tagName = tagName.toLowerCase());
        if (info != null) {
            result = this.queryHistoryRawListValue(info.get_histServ(), this.switchToShortid(info, tagName), startUTC, endUTC);
        }
        return result;
    }

    public Map<String, DNAVal> getHistoryTagRawValues(String tagName, String starttime, String endtime) throws Exception {
        Map<String, DNAVal> result = new HashMap<String, DNAVal>();
        RealTimeServiceInfo info = this.findRealTimeServiceInfoByName(tagName = tagName.toLowerCase());
        if (info != null) {
            try {
                result = this.queryHistoryRawValue(info.get_histServ(), this.switchToShortid(info, tagName), this.parseDateStringToUTC(starttime), this.parseDateStringToUTC(endtime));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public synchronized DNAVal getRealtimeTagValue(String tagName) throws Exception {
        RealTimeServiceInfo servInfo = this.findRealTimeServiceInfoByName(tagName);
        if (servInfo != null) {
            return this.getRealtimeTagValue(servInfo.get_rtServ(), this.switchToShortid(servInfo, tagName));
        }
        return null;
    }

    public Map<String, DNAVal> getRealtimeTagValues(String ... tagNames) throws Exception {
        RealTimeServiceInfo info;
        HashMap group = new HashMap();
        HashMap<String, String> maps = new HashMap<String, String>();
        int i = 0;
        while (i < tagNames.length) {
            tagNames[i] = tagNames[i].toLowerCase();
            info = this.findRealTimeServiceInfoByName(tagNames[i]);
            if (info != null) {
                String service = tagNames[i].split("\\.")[1];
                if (!group.containsKey(service)) {
                    group.put(service, new ArrayList());
                }
                String shortid = this.switchToShortid(info, tagNames[i]).split("\\.")[2].toLowerCase();
                maps.put(shortid, tagNames[i]);
                ((List)group.get(service)).add(shortid);
            }
            ++i;
        }
        HashMap<String, DNAVal> result = new HashMap<String, DNAVal>();
        for (Map.Entry setEntry : group.entrySet()) {
            info = this.findRealTimeServiceInfoByName((String)maps.get(((List)setEntry.getValue()).get(0)));
            result.putAll(this.getRealtimeTagValues(info.get_rtServ(), (List)setEntry.getValue(), maps));
        }
        return result;
    }

    public Map<String, DNAVal> getHistoryMatrixValues(int utcStart, int utcEnd, int type, String ... tagName) throws Exception {
        HashMap<String, DNAVal> result = new HashMap<String, DNAVal>();
        Map<String, DNAVal> data = null;
        RealTimeServiceInfo info = null;
        int i = 0;
        while (i < tagName.length) {
            tagName[i] = tagName[i].toLowerCase().trim();
            info = this.findRealTimeServiceInfoByName(tagName[i]);
            if (info != null && (data = this.queryHistoryValue(info.get_histServ(), this.switchToShortid(info, tagName[i]), utcStart, utcEnd, utcEnd - utcStart + 1, type)).size() != 0) {
                for (Map.Entry<String, DNAVal> entry : data.entrySet()) {
                    result.put(tagName[i], entry.getValue());
                }
            }
            ++i;
        }
        return result;
    }

    public int deletePointRec(String point, String starttime, String endtime) throws Exception {
        return this.deletePointRec(point, this.parseDateStringToUTC(starttime), this.parseDateStringToUTC(endtime));
    }

    public synchronized int deletePointRec(String point, int tStart, int tEnd) throws Exception {
        RealTimeServiceInfo servInfo = this.findRealTimeServiceInfoByName(point);
        if (servInfo != null) {
            DatagramSocket socket = null;
            point = this.switchToShortid(servInfo, point);
            try {
                socket = new DatagramSocket();
                socket.setSoTimeout(500);
                socket.connect(InetAddress.getByName(servInfo.get_histServ().get_ip()), servInfo.get_histServ().get_port());
                this._data.clear();
                this._data.put(ApiEntry.toLH((short)593));
                this._data.put(ApiEntry.toLH((short)1));
                this._data.put(ApiEntry.toLH((short)0));
                this._data.put(ApiEntry.toLH((short)0));
                String[] details = point.split("\\.");
                if (details.length != 3) {
                    System.out.println(String.valueOf(point) + " deletePointRec failed . msg : not a correct format.");
                    return -102;
                }
                this._data.put(ApiEntry.padRight(details[0], 8).getBytes());
                this._data.put(ApiEntry.padRight(details[1], 8).getBytes());
                this._data.put(ApiEntry.padRight(details[2], 8).getBytes());
                int i = 0;
                while (i < 39) {
                    this._data.put(ApiEntry.padRight("", 8).getBytes());
                    this._data.put(ApiEntry.padRight("", 8).getBytes());
                    this._data.put(ApiEntry.padRight("", 8).getBytes());
                    ++i;
                }
                this._data.put(ApiEntry.toLH(tStart));
                i = 0;
                while (i < 39) {
                    this._data.put(ApiEntry.toLH(0));
                    ++i;
                }
                this._data.put(ApiEntry.toLH(tEnd));
                i = 0;
                while (i < 39) {
                    this._data.put(ApiEntry.toLH(0));
                    ++i;
                }
                this._data.put(ApiEntry.toLH(1));
                this.sendAndReceive(socket);
                byte[] data = this._data.array();
                short ret = ApiEntry.toHHShort(data, 4);
                if (ret == 0) {
                    int n = ApiEntry.toHHInt(data, 968);
                    return n;
                }
                short s = ret;
                return s;
            }
            catch (Exception e) {
                System.out.println(String.valueOf(point) + " deletePointRec failed . msg : " + e.getMessage());
                throw new Exception(String.valueOf(point) + " deletePointRec failed . msg : " + e.getMessage());
            }
            finally {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
        }
        System.out.println(String.valueOf(point) + " findRealTimeServiceInfoByName failed.");
        return -100;
    }

    public int[] deletePointsRecs(String[] points, int[] tStart, int[] tEnd) throws Exception {
        int[] result = new int[points.length];
        int i = 0;
        while (i < points.length) {
            result[i] = this.deletePointRec(points[i], tStart[i], tEnd[i]);
            ++i;
        }
        return result;
    }

    public Map<String, DNAVal> getHistoryMatrixValues(String starttime, String endtime, int type, String ... tagName) throws Exception {
        HashMap<String, DNAVal> result = new HashMap<String, DNAVal>();
        try {
            int utcStart = this.parseDateStringToUTC(starttime);
            int utcEnd = this.parseDateStringToUTC(endtime);
            return this.getHistoryMatrixValues(utcStart, utcEnd, type, tagName);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return result;
        }
    }

    private synchronized Map<String, DNAVal> queryHistoryValue(ServiceInfo info, String tagName, int tStart, int tEnd, int period, int type) throws Exception {
        HashMap<String, DNAVal> result;
        block16: {
            result = new HashMap<String, DNAVal>();
            DatagramSocket socket = null;
            try {
                try {
                    socket = new DatagramSocket();
                    socket.setSoTimeout(5000);
                    socket.connect(InetAddress.getByName(info.get_ip()), info.get_port());
                    this._data.clear();
                    this._data.put(ApiEntry.toLH((short)550));
                    this._data.put(ApiEntry.toLH((short)160));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.toLH((short)0));
                    String[] names = tagName.split("\\.");
                    this._data.put(ApiEntry.padRight(names[0].trim(), 8).getBytes());
                    this._data.put(ApiEntry.padRight(names[1].trim(), 8).getBytes());
                    this._data.put(ApiEntry.padRight(names[2].trim(), 8).getBytes());
                    this._data.put((byte)0);
                    this._data.put((byte)type);
                    if (type != HIST_SNAP) {
                        this._data.put(ApiEntry.toLH(tStart));
                        this._data.put(ApiEntry.toLH(tEnd));
                    } else {
                        this._data.put(ApiEntry.toLH(tStart));
                        this._data.put(ApiEntry.toLH(tEnd + period));
                    }
                    this._data.put(ApiEntry.toLH(period));
                    this.sendAndReceive(socket);
                    byte[] data = this._data.array();
                    short ret = ApiEntry.toHHShort(data, 4);
                    int offset = 15;
                    if (ret != 0) break block16;
                    int tTime = 0;
                    DNAVal val = null;
                    int length = ApiEntry.toHHShort(data, 2);
                    int i = 0;
                    while (i < length) {
                        String sVal = new String(data, offset + i * 24 + 6, 16, "gb2312").replace('\u0000', ' ').trim();
                        if (!sVal.isEmpty()) {
                            sVal = sVal.split(" ")[0];
                            tTime = ApiEntry.toHHInt(data, offset + i * 24);
                            val = new DNAVal();
                            val.DValue = Double.parseDouble(sVal);
                            val.Status = ApiEntry.toHHShort(data, offset + i * 24 + 4);
                            val.Time = ApiEntry.toHHInt(data, offset + i * 24);
                            if (tTime >= tStart && tTime <= tEnd) {
                                result.put(this._format.format(new Date((long)tTime * 1000L)), val);
                            }
                        }
                        ++i;
                    }
                    boolean bDone = data[14] == 1;
                    byte[] nBi = new byte[7];
                    while (!bDone) {
                        System.arraycopy(data, 8, nBi, 0, 7);
                        this._data.clear();
                        this._data.put(ApiEntry.toLH((short)552));
                        this._data.put(ApiEntry.toLH((short)160));
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(nBi);
                        this.sendAndReceive(socket);
                        data = this._data.array();
                        ret = ApiEntry.toHHShort(data, 4);
                        offset = 15;
                        if (ret == 0) {
                            tTime = 0;
                            length = ApiEntry.toHHShort(data, 2);
                            int i2 = 0;
                            while (i2 < length) {
                                String sVal = new String(data, offset + i2 * 24 + 6, 16, "gb2312").replace('\u0000', ' ').trim();
                                if (!sVal.isEmpty()) {
                                    sVal = sVal.split(" ")[0];
                                    tTime = ApiEntry.toHHInt(data, offset + i2 * 24);
                                    val = new DNAVal();
                                    val.DValue = Double.parseDouble(sVal);
                                    val.Status = ApiEntry.toHHShort(data, offset + i2 * 24 + 4);
                                    val.Time = ApiEntry.toHHInt(data, offset + i2 * 24);
                                    if (tTime >= tStart && tTime <= tEnd) {
                                        result.put(this._format.format(new Date((long)tTime * 1000L)), val);
                                    }
                                }
                                ++i2;
                            }
                            boolean bl = bDone = data[14] == 1;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(String.valueOf(tagName) + " queryHistoryValue failed . msg : " + e.getMessage());
                    throw new Exception(String.valueOf(tagName) + " queryHistoryValue failed . msg : " + e.getMessage());
                }
            }
            finally {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
        }
        return result;
    }

    public Map<String, DNAVal> getHistoryTagValues(String tagName, String starttime, String endtime, long period, int type) throws Exception {
        Map<String, DNAVal> result = new HashMap<String, DNAVal>();
        RealTimeServiceInfo info = this.findRealTimeServiceInfoByName(tagName = tagName.toLowerCase());
        if (info != null) {
            try {
                result = this.queryHistoryValue(info.get_histServ(), this.switchToShortid(info, tagName), this.parseDateStringToUTC(starttime), this.parseDateStringToUTC(endtime), (int)period, type);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public synchronized int updateVals(String point, DNAVal ... vals) throws Exception {
        RealTimeServiceInfo servInfo = this.findRealTimeServiceInfoByName(point);
        if (servInfo != null) {
            point = this.switchToShortid(servInfo, point);
            DatagramSocket socket = null;
            try {
                socket = new DatagramSocket();
                socket.setSoTimeout(5000);
                socket.connect(InetAddress.getByName(servInfo.get_histServ().get_ip()), servInfo.get_histServ().get_port());
                int size = vals.length;
                int maxPointsPerCall = 160;
                int loops = size % maxPointsPerCall == 0 ? size / maxPointsPerCall : size / maxPointsPerCall + 1;
                int index = 0;
                do {
                    int remains = size - index * maxPointsPerCall;
                    int start = index * maxPointsPerCall;
                    int count = remains >= maxPointsPerCall ? maxPointsPerCall : remains;
                    int end = start + count;
                    this._data.clear();
                    this._data.put(ApiEntry.toLH((short)574));
                    this._data.put(ApiEntry.toLH((short)count));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.toLH((short)0));
                    String[] details = point.split("\\.");
                    if (details.length != 3) {
                        System.out.println(String.valueOf(point) + " updateVals failed . msg : not a correct format.");
                        return -102;
                    }
                    this._data.put(ApiEntry.padRight(details[0], 8).getBytes());
                    this._data.put(ApiEntry.padRight(details[1], 8).getBytes());
                    this._data.put(ApiEntry.padRight(details[2], 8).getBytes());
                    this._data.put((byte)4);
                    while (start < end) {
                        this._data.put(ApiEntry.toLH(vals[start].Time));
                        this._data.put(ApiEntry.toLH(vals[start].Status));
                        this._data.put(ApiEntry.padRight(String.valueOf(vals[start].DValue), 16).getBytes());
                        this._data.put(new byte[2]);
                        ++start;
                    }
                    this.sendAndReceive(socket);
                    byte[] data = this._data.array();
                    short ret = ApiEntry.toHHShort(data, 4);
                    ++index;
                    --loops;
                    if (ret == 0) continue;
                    throw new Exception(String.valueOf(point) + " update vals error ret :\u3000" + ret);
                } while (loops > 0);
                return 0;
            }
            catch (Exception e) {
                System.out.println(String.valueOf(point) + " updateVals failed . msg : " + e.getMessage());
                throw new Exception(String.valueOf(point) + " updateVals failed . msg : " + e.getMessage());
            }
            finally {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
        }
        System.out.println(String.valueOf(point) + " findRealTimeServiceInfoByName failed.");
        return -100;
    }

    public synchronized int updateVals(String point, List<DNAVal> vals) throws Exception {
        RealTimeServiceInfo servInfo = this.findRealTimeServiceInfoByName(point);
        if (servInfo != null) {
            point = this.switchToShortid(servInfo, point);
            DatagramSocket socket = null;
            try {
                socket = new DatagramSocket();
                socket.setSoTimeout(5000);
                socket.connect(InetAddress.getByName(servInfo.get_histServ().get_ip()), servInfo.get_histServ().get_port());
                int size = vals.size();
                int maxPointsPerCall = 160;
                int loops = size % maxPointsPerCall == 0 ? size / maxPointsPerCall : size / maxPointsPerCall + 1;
                int index = 0;
                do {
                    int remains = size - index * maxPointsPerCall;
                    int start = index * maxPointsPerCall;
                    int count = remains >= maxPointsPerCall ? maxPointsPerCall : remains;
                    int end = start + count;
                    this._data.clear();
                    this._data.put(ApiEntry.toLH((short)574));
                    this._data.put(ApiEntry.toLH((short)count));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.toLH((short)0));
                    String[] details = point.split("\\.");
                    if (details.length != 3) {
                        System.out.println(String.valueOf(point) + " updateVals failed . msg : not a correct format.");
                        return -102;
                    }
                    this._data.put(ApiEntry.padRight(details[0], 8).getBytes());
                    this._data.put(ApiEntry.padRight(details[1], 8).getBytes());
                    this._data.put(ApiEntry.padRight(details[2], 8).getBytes());
                    this._data.put((byte)4);
                    while (start < end) {
                        this._data.put(ApiEntry.toLH(vals.get((int)start).Time));
                        this._data.put(ApiEntry.toLH(vals.get((int)start).Status));
                        this._data.put(ApiEntry.padRight(String.valueOf(vals.get((int)start).DValue), 16).getBytes());
                        this._data.put(new byte[2]);
                        ++start;
                    }
                    this.sendAndReceive(socket);
                    byte[] data = this._data.array();
                    short ret = ApiEntry.toHHShort(data, 4);
                    ++index;
                    --loops;
                    if (ret == 0) continue;
                    throw new Exception(String.valueOf(point) + " update vals error ret :\u3000" + ret);
                } while (loops > 0);
                return 0;
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(point) + " updateVals failed . msg : " + e.getMessage());
            }
            finally {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
        }
        System.out.println(String.valueOf(point) + " findRealTimeServiceInfoByName failed.");
        return -100;
    }

    public synchronized List<String> getRTServs() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this._data.clear();
            this._data.put(ApiEntry.toLH((short)519));
            this._data.put(ApiEntry.toLH((short)40));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put(ApiEntry.toLH((short)0));
            this._data.put(ApiEntry.padRight("SSERVER", 8).getBytes());
            this.sendAndReceive(this._socket);
            byte[] data = this._data.array();
            short ret = ApiEntry.toHHShort(data, 4);
            if (ret == 0) {
                int count = ApiEntry.toHHShort(data, 2);
                int i = 0;
                while (i <= count) {
                    String serv = new String(data, 18 + 74 * i + 8, 8, "gb2312").replace('\u0000', ' ').trim();
                    if (!result.contains(serv) && !serv.equals("")) {
                        result.add(serv);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Get getRTServs failed . msg : " + e.getMessage());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized List<DNAPointVal> getServAllPoints(String serv) throws Exception {
        block15: {
            result = new ArrayList<DNAPointVal>();
            tagName = String.valueOf(serv) + ".a";
            socket = null;
            try {
                servInfo = this.findRealTimeServiceInfoByName(tagName);
                if (servInfo == null) break block15;
                socket = new DatagramSocket();
                socket.setSoTimeout(500);
                socket.connect(InetAddress.getByName(servInfo.get_rtServ().get_ip()), servInfo.get_rtServ().get_port());
                this._data.clear();
                this._data.put(ApiEntry.toLH((short)1));
                this._data.put(ApiEntry.toLH((short)32));
                this._data.put(ApiEntry.toLH((short)0));
                this._data.put(ApiEntry.toLH((short)0));
                tStart = 0;
                i = 0;
                if (true) ** GOTO lbl35
            }
            catch (Throwable var14_17) {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
                throw var14_17;
            }
            {
                catch (Exception e) {
                    System.out.println(String.valueOf(tagName) + " getServAllPoints failed . msg : " + e.getMessage());
                    throw new Exception(String.valueOf(tagName) + " getServAllPoints failed . msg : " + e.getMessage());
                }
            }
            do {
                this._data.put(ApiEntry.toLH(tStart));
                tStart = (short)(tStart + 1);
                ++i;
lbl35:
                // 2 sources

            } while (i < 32);
            this.sendAndReceive(socket);
            data = this._data.array();
            ret = ApiEntry.toHHShort(data, 4);
            if (ret != 0) break block15;
            count = ApiEntry.toHHShort(data, 2);
            name = "";
            i = 0;
            while (i < count) {
                sVal = new String(data, 8 + i * 64 + 40, 16, "gb2312").replace('\u0000', ' ').trim();
                pointVal = new DNAPointVal();
                pointVal.Val = new DNAVal();
                name = pointVal.Name = new String(data, 8 + i * 64 + 8, 8, "gb2312").replace('\u0000', ' ').trim();
                if (!sVal.equals("")) {
                    pointVal.Val.DValue = Double.parseDouble(sVal);
                    pointVal.Val.Time = ApiEntry.toHHInt(data, 8 + i * 64 + 4);
                    pointVal.Val.Status = ApiEntry.toHHShort(data, 8 + i * 64 + 2);
                    result.add(pointVal);
                }
                ++i;
            }
            if (!name.equals("")) ** GOTO lbl99
            var15_16 = result;
            if (socket != null && socket.isConnected()) {
                socket.close();
            }
            return var15_16;
lbl-1000:
            // 1 sources

            {
                this._data.clear();
                this._data.put(ApiEntry.toLH((short)1));
                this._data.put(ApiEntry.toLH((short)32));
                this._data.put(ApiEntry.toLH((short)0));
                this._data.put(ApiEntry.toLH((short)0));
                i = 0;
                while (i < 32) {
                    this._data.put(ApiEntry.toLH(tStart));
                    tStart = (short)(tStart + 1);
                    ++i;
                }
                this.sendAndReceive(socket);
                data = this._data.array();
                ret = ApiEntry.toHHShort(data, 4);
                if (ret != 0) continue;
                count = ApiEntry.toHHShort(data, 2);
                name = "";
                i = 0;
                while (i < count) {
                    sVal = new String(data, 8 + i * 64 + 40, 16, "gb2312").replace('\u0000', ' ').trim();
                    pointVal = new DNAPointVal();
                    pointVal.Val = new DNAVal();
                    name = pointVal.Name = new String(data, 8 + i * 64 + 8, 8, "gb2312").replace('\u0000', ' ').trim();
                    if (!sVal.equals("")) {
                        pointVal.Val.DValue = Double.parseDouble(sVal);
                        pointVal.Val.Time = ApiEntry.toHHInt(data, 8 + i * 64 + 4);
                        pointVal.Val.Status = ApiEntry.toHHShort(data, 8 + i * 64 + 2);
                        result.add(pointVal);
                    }
                    ++i;
                }
                if (name.equals("")) break;
lbl99:
                // 3 sources

                ** while (count == 32 && ret == 0)
            }
        }
        if (socket != null && socket.isConnected()) {
            socket.close();
        }
        return result;
    }

    public synchronized DNAPointConfig readPointConfig(String tagName) throws Exception {
        RealTimeServiceInfo info = this.findRealTimeServiceInfoByName(tagName);
        if (info != null) {
            String[] detail = (tagName = this.switchToShortid(info, tagName)).split("\\.");
            if (detail.length == 3 && detail[2].length() > 8) {
                return null;
            }
            StringBuilder shortid = new StringBuilder(100);
            int i = 2;
            while (i < detail.length) {
                if (i == 2) {
                    shortid.append(detail[i]);
                } else {
                    shortid.append("." + detail[i]);
                }
                ++i;
            }
            ServiceInfo cmcfg = info.get_cmcfgServ();
            DatagramSocket socket = null;
            try {
                socket = new DatagramSocket();
                socket.setSoTimeout(500);
                socket.connect(InetAddress.getByName(cmcfg.get_ip()), cmcfg.get_port());
                this._data.clear();
                this._data.put(ApiEntry.toLH((short)1000));
                this._data.put(ApiEntry.toLH((short)1));
                this._data.put(ApiEntry.toLH((short)0));
                this._data.put(ApiEntry.toLH((short)0));
                this._data.put(ApiEntry.toLH((short)0));
                this._data.put("C4".getBytes());
                this._data.put(ApiEntry.padSpaceRight(detail[0], 8).getBytes());
                this._data.put(ApiEntry.padSpaceRight(detail[1], 8).getBytes());
                this._data.put(ApiEntry.padSpaceRight(shortid.toString().toUpperCase(), 8).getBytes());
                this._data.put(ApiEntry.padSpaceRight("", 4).getBytes());
                this._data.put(ApiEntry.padSpaceRight("", 8).getBytes());
                this._data.put((byte)1);
                this._data.put(ApiEntry.padSpaceRight("", 10).getBytes());
                this.sendAndReceive(socket);
                byte[] data = this._data.array();
                short ret = ApiEntry.toHHShort(data, 4);
                if (ret == 0) {
                    short count = ApiEntry.toHHShort(data, 2);
                    byte[] keys = new byte[35];
                    System.arraycopy(data, 49, keys, 0, 10);
                    keys[10] = 0;
                    if (count > 0) {
                        this._data.clear();
                        this._data.put(ApiEntry.toLH((short)1001));
                        this._data.put(ApiEntry.toLH((short)1));
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(keys);
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(ApiEntry.padRight("", 4).getBytes());
                        this._data.put(ApiEntry.toLH((short)0));
                        this.sendAndReceive(socket);
                        data = this._data.array();
                        ret = ApiEntry.toHHShort(data, 4);
                        if (ret == 0) {
                            String longid = new String(data, 141, 60, "gb2312").replace('\u0000', ' ').trim();
                            String shortID = new String(data, 133, 8, "gb2312").replace('\u0000', ' ').trim();
                            DNAPointConfig config = new DNAPointConfig();
                            config.shortID = shortID;
                            config.longID = longid;
                            config.szPointType = new String(data, 209, 2, "gb2312").replace('\u0000', ' ').trim();
                            config.desc = new String(data, 211, 24, "gb2312").replace('\u0000', ' ').trim();
                            config.units = new String(data, 235, 8, "gb2312").replace('\u0000', ' ').trim();
                            DNAPointConfig dNAPointConfig = config;
                            return dNAPointConfig;
                        }
                    }
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(tagName) + " readPointConfig failed . msg : " + e.getMessage());
                throw new Exception(String.valueOf(tagName) + " readPointConfig failed . msg : " + e.getMessage());
            }
            finally {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
            return null;
        }
        return null;
    }

    public synchronized String longidFromShortid(String tagName) throws Exception {
        RealTimeServiceInfo info = this.findRealTimeServiceInfoByName(tagName);
        if (info != null) {
            tagName = this.switchToLongid(info, tagName);
            return tagName;
        }
        return null;
    }

    public synchronized String shortidFromLongid(String tagName) throws Exception {
        RealTimeServiceInfo info = this.findRealTimeServiceInfoByName(tagName);
        if (info != null) {
            tagName = this.switchToShortid(info, tagName);
            return tagName;
        }
        return null;
    }

    public static String[] getPointName(int nCount) {
        String[] tags = new String[nCount];
        int i = 0;
        while (i < nCount) {
            tags[i] = String.format("SIS.KLUNIV.KL%06d", i + 1);
            ++i;
        }
        return tags;
    }

    public Map<String, DNAVal> getHistorySnapMatrixValues(int utc, String ... tagName) throws Exception {
        HashMap<String, DNAVal> result = new HashMap<String, DNAVal>();
        DNAVal data = null;
        RealTimeServiceInfo info = null;
        int i = 0;
        while (i < tagName.length) {
            tagName[i] = tagName[i].toLowerCase().trim();
            info = this.findRealTimeServiceInfoByName(tagName[i]);
            if (info != null) {
                data = this.queryHistorySnapValue(info.get_histServ(), this.switchToShortid(info, tagName[i]), utc);
                result.put(tagName[i], data);
            }
            ++i;
        }
        return result;
    }

    private synchronized DNAVal queryHistorySnapValue(ServiceInfo info, String tagName, int time) throws Exception {
        DNAVal result;
        block14: {
            result = null;
            DatagramSocket socket = null;
            try {
                try {
                    socket = new DatagramSocket();
                    socket.setSoTimeout(5000);
                    socket.connect(InetAddress.getByName(info.get_ip()), info.get_port());
                    this._data.clear();
                    this._data.put(ApiEntry.toLH((short)551));
                    this._data.put(ApiEntry.toLH((short)160));
                    this._data.put(ApiEntry.toLH((short)0));
                    this._data.put(ApiEntry.toLH((short)0));
                    String[] names = tagName.split("\\.");
                    this._data.put(ApiEntry.padRight(names[0].trim(), 8).getBytes());
                    this._data.put(ApiEntry.padRight(names[1].trim(), 8).getBytes());
                    this._data.put(ApiEntry.padRight(names[2].trim(), 8).getBytes());
                    this._data.put((byte)0);
                    this._data.put(ApiEntry.toLH(time - 1));
                    this._data.put(ApiEntry.toLH(time + 1));
                    this.sendAndReceive(socket);
                    byte[] data = this._data.array();
                    short ret = ApiEntry.toHHShort(data, 4);
                    int offset = 15;
                    if (ret != 0) break block14;
                    int tTime = 0;
                    DNAVal val = null;
                    int length = ApiEntry.toHHShort(data, 2);
                    int i = 0;
                    while (i < length) {
                        String sVal = new String(data, offset + i * 24 + 6, 16, "gb2312").replace('\u0000', ' ').trim();
                        if (!sVal.isEmpty()) {
                            tTime = ApiEntry.toHHInt(data, offset + i * 24);
                            val = new DNAVal();
                            val.DValue = Double.parseDouble(sVal);
                            val.Status = ApiEntry.toHHShort(data, offset + i * 24 + 4);
                            val.Time = ApiEntry.toHHInt(data, offset + i * 24);
                            if (tTime <= time) {
                                result = val;
                            }
                        }
                        ++i;
                    }
                    boolean bDone = data[14] == 1;
                    byte[] nBi = new byte[7];
                    while (!bDone) {
                        System.arraycopy(data, 8, nBi, 0, 7);
                        this._data.clear();
                        this._data.put(ApiEntry.toLH((short)552));
                        this._data.put(ApiEntry.toLH((short)160));
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(ApiEntry.toLH((short)0));
                        this._data.put(nBi);
                        this.sendAndReceive(socket);
                        data = this._data.array();
                        ret = ApiEntry.toHHShort(data, 4);
                        offset = 15;
                        if (ret == 0) {
                            tTime = 0;
                            length = ApiEntry.toHHShort(data, 2);
                            int i2 = 0;
                            while (i2 < length) {
                                String sVal = new String(data, offset + i2 * 24 + 6, 16, "gb2312").replace('\u0000', ' ').trim();
                                if (!sVal.isEmpty()) {
                                    tTime = ApiEntry.toHHInt(data, offset + i2 * 24);
                                    val = new DNAVal();
                                    val.DValue = Double.parseDouble(sVal);
                                    val.Status = ApiEntry.toHHShort(data, offset + i2 * 24 + 4);
                                    val.Time = ApiEntry.toHHInt(data, offset + i2 * 24);
                                    if (tTime <= time) {
                                        result = val;
                                    }
                                }
                                ++i2;
                            }
                            boolean bl = bDone = data[14] == 1;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(tagName) + " queryHistoryRawValue failed . msg : " + e.getMessage());
                    throw new Exception(String.valueOf(tagName) + " queryHistoryRawValue failed . msg : " + e.getMessage());
                }
            }
            finally {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            ApiEntry entry = new ApiEntry("12.0.1.30", 6321);
            Map<String, DNAVal> vals = entry.getHistorySnapMatrixValues(EdnaApiHelper.parseDateStringToUTC("2014-08-18 10:00:00"), "SIS.FGLUNIV.HRZBZXYG");
            for (Map.Entry<String, DNAVal> setEntry : vals.entrySet()) {
                System.out.println(String.valueOf(setEntry.getKey()) + " : " + setEntry.getValue().DValue + " - " + setEntry.getValue().Time + " - " + setEntry.getValue().Status);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

