/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.test;

import cn.gyee.appsoft.jrt.common.EdnaApiHelper;
import cn.gyee.appsoft.jrt.exception.JRealTimeException;
import cn.gyee.appsoft.jrt.model.PointData;
import cn.gyee.appsoft.jrt.model.PointInfo;
import cn.gyee.appsoft.jrt.service.EdnaSocketApiService;
import cn.gyee.appsoft.jrt.service.IOperatorRealTime;
import cn.gyee.appsoft.jrt.yb.ApiEntry;
import cn.gyee.appsoft.jrt.yb.DNAVal;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class JSocketTest {
    private static IOperatorRealTime operator;

    public static void createOperator() throws JRealTimeException {
        operator = new EdnaSocketApiService();
    }

    public static void addPoint() throws JRealTimeException {
        ArrayList<PointInfo> pis = new ArrayList<PointInfo>();
        int i = 10;
        while (i < 100) {
            PointInfo pi = new PointInfo("LdS000" + i, "LDS000" + i, "desc", "kw", "AI", "EXT000" + i, "extdesc");
            pis.add(pi);
            ++i;
        }
        operator.createPoint("192.168.1.111", "8989", pis);
    }

    public static void getRTPointValue() throws JRealTimeException {
        PointData pd = operator.getRealTimeData("SIS.CALCUNIV.GLJ00639");
        if (pd != null) {
            System.out.println("UTC\u65f6\u95f4: ===" + pd.getUtcTime());
            System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
            System.out.println("\u503c: ===" + pd.getValue());
            System.out.println("\u72b6\u6001: ===" + pd.getStatus());
        }
    }

    public static void getRTallPointValue() throws JRealTimeException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("SIS.KLUNIV.KL000001");
        list.add("SIS.KLUNIV.KL000759");
        List<PointData> pds = operator.getRealTimeData(list);
        if (!pds.isEmpty()) {
            for (PointData pd : pds) {
                System.out.println("\u503c: ===" + pd.getValue() + pd.getPointId());
            }
        }
    }

    public static void getHisSnap() throws Exception {
        while (true) {
            long startTime = System.currentTimeMillis();
            List<PointData> pds = operator.getHistorySnapData("sis.calcuniv.hnj00009", "2014-06-27 00:00:00", "2014-06-29 00:00:00", 900);
            for (PointData pd : pds) {
                System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
                System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
                System.out.println("\u503c: ===" + pd.getValue());
                System.out.println("\u72b6\u6001: ===" + pd.getStatus());
                System.out.println("=================================================");
            }
            System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + pds.size() + "|||" + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
            Thread.sleep(5000L);
        }
    }

    public static void getHisRaw() throws JRealTimeException {
        List<PointData> pds = operator.getHistoryRawData("SIS.KLUNIV.KL000001", "2014-04-22 18:26:50", "2014-04-22 18:26:55");
        Collections.sort(pds);
        for (PointData pd : pds) {
            System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
            System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
            System.out.println("\u503c: ===" + pd.getValue());
            System.out.println("\u72b6\u6001: ===" + pd.getStatus());
            System.out.println("=================================================");
        }
    }

    public static void getMatrixHisSnap() throws JRealTimeException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("SIS.KLUNIV.KL000001");
        list.add("SIS.KLUNIV.KL000002");
        List<PointData> pds = operator.getHistoryMatrixSnapData(list, "2014-04-22 09:54:34");
        if (!pds.isEmpty()) {
            for (PointData pd : pds) {
                System.out.println("\u503c: ===" + pd.getValue());
            }
        }
    }

    public static void testYinbu() throws Exception {
        try {
            ApiEntry entry = new ApiEntry("12.0.1.30", 6321);
            DNAVal[] vals = new DNAVal[10];
            int i = 0;
            while (i < vals.length) {
                vals[i] = new DNAVal();
                vals[i].Time = i + 1;
                vals[i].DValue = i;
                vals[i].Status = (short)3;
                ++i;
            }
            entry.updateVals("SIS.KLUNIV.KL000001", vals);
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writePoint_more() throws JRealTimeException, ParseException, InterruptedException {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        int i = 1;
        while (i < 2) {
            PointData pd = new PointData("WLJ00158", 88888.0, 0, 0, (short)3);
            pds.add(pd);
            ++i;
        }
        int n = 1;
        do {
            operator.writePoint("12.0.1.30", "10035", pds);
            Thread.sleep(500L);
        } while (++n != 500);
    }

    public static void writePoint() throws JRealTimeException, ParseException, InterruptedException {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:ss:mm");
        String d = format.format(date);
        PointData pd = new PointData("SSRSHFS", 88888.0, EdnaApiHelper.parseDateStringToUTC(d), 0, (short)3);
        operator.writePoint("12.0.1.30", "10035", pd);
    }

    public static void updatePoint() throws Exception {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        PointData pd = new PointData();
        pd.setPointId("SIS.KLDQUNIV.KLSC1198");
        pd.setUtcTime(EdnaApiHelper.parseDateStringToUTC("2014-03-01 00:00:00"));
        pd.setStatus(Short.parseShort("3"));
        pd.setValue(888888.0);
        pds.add(pd);
        int num = operator.putHistoryData("SIS.KLDQUNIV.KLSC1198", pds);
        System.out.println(num);
    }

    public static void updatehistoryPoint() throws Exception {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        PointData pd = null;
        pd = new PointData();
        pd.setPointId("SIS.JGDQUNIV.JGSM0001");
        pd.setUtcTime(EdnaApiHelper.parseDateStringToUTC("2014-02-01 00:00:00"));
        pd.setValue(2338.5748);
        pd.setStatus(Short.parseShort("3"));
        pds.add(pd);
        pds.add(pd);
        operator.putHistoryData("SIS.JGDQUNIV.JGSM0001", pds);
    }

    public static void DbTest() throws Exception {
        String beginTime = "2014-06-16 00:16:00";
        String endTime = "2014-06-17 00:00:00";
        PointData pd = operator.getMaxHistoryData("SIS.CALCUNIV.KLJ00462", beginTime, endTime);
        System.out.println(pd.getValue() + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
    }

    public static void main(String[] args) throws Exception {
        JSocketTest.createOperator();
    }
}

