/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.service;

import cn.gyee.appsoft.framework.commons.util.StringUtils;
import cn.gyee.appsoft.jrt.common.EdnaApiHelper;
import cn.gyee.appsoft.jrt.common.PointDataRDUtils;
import cn.gyee.appsoft.jrt.model.PointData;
import cn.gyee.appsoft.jrt.model.PointInfo;
import cn.gyee.appsoft.jrt.service.IOperatorRealTime;
import com.ybsoftware.ApiEntry;
import com.ybsoftware.DNAPointVal;
import com.ybsoftware.DNAStatVal;
import com.ybsoftware.DNAVal;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EdnaSocketApiService
implements IOperatorRealTime {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String address = "172.16.115.31";
    private Integer port = 10010;

    private ApiEntry getApiEntry() {
        ApiEntry entry = null;
        try {
            entry = new ApiEntry(this.address, this.port.intValue());
            entry.login("ybsystem", "ybSoftwareEdos20130607");
        }
        catch (Exception e) {
            this.logger.error((Object)"EN:ApiEntry constructed method faild!CN:ApiEntry \u6784\u9020\u65b9\u6cd5\u5b9e\u4f8b\u5316\u65f6\u51fa\u73b0\u9519\u8bef!", (Throwable)e);
        }
        return entry;
    }

    @Override
    public void addPointMemory(String fullPointName, int refInterval) {
    }

    @Override
    public PointData getRealTimeData(String fullPointName) {
        DNAVal[] dnaVals;
        PointData pd;
        block5: {
            pd = null;
            ApiEntry entry = null;
            entry = this.getApiEntry();
            String[] tagNames = new String[]{fullPointName};
            dnaVals = entry.getRealtimeTagValues(tagNames);
            if (dnaVals != null && dnaVals.length >= 1) break block5;
            this.logger.warn((Object)(String.valueOf(fullPointName) + "\u6ca1\u6709\u76f8\u5173\u4fe1\u606f!"));
            return null;
        }
        try {
            DNAVal dnaVal = dnaVals[0];
            pd = new PointData();
            pd.setValue(dnaVal.DValue);
            pd.setUtcTime(dnaVal.Time);
            pd.setStatus(dnaVal.Status);
            pd.setPointId(fullPointName);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getRealTimeData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)(" edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        return pd;
    }

    @Override
    public List<PointData> getRealTimeData(List<String> fullPointNames) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        ApiEntry entry = null;
        try {
            entry = this.getApiEntry();
            String[] tagNames = fullPointNames.toArray(new String[fullPointNames.size()]);
            DNAVal[] vs = entry.getRealtimeTagValues(tagNames);
            if (vs != null && vs.length == tagNames.length) {
                int count = 0;
                DNAVal[] dNAValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAVal dnaVal = dNAValArray[n2];
                    PointData pd = new PointData();
                    pd.setValue(dnaVal.DValue);
                    pd.setUtcTime(dnaVal.Time);
                    pd.setStatus(dnaVal.Status);
                    pd.setPointId(tagNames[count++]);
                    pds.add(pd);
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getRealTimeData-List\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)(fullPointNames + "edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTIDs:" + fullPointNames));
        }
        return pds;
    }

    @Override
    public List<PointData> getHistoryRawData(String fullPointName, String beginTime, String endTime) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            DNAVal[] vs = apiEntry.getHistRaw(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime));
            if (vs != null) {
                DNAVal[] dNAValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAVal dnaVal = dNAValArray[n2];
                    PointData pd = new PointData();
                    pd.setValue(dnaVal.DValue);
                    pd.setUtcTime(dnaVal.Time);
                    pd.setStatus(dnaVal.Status);
                    pd.setPointId(fullPointName);
                    pds.add(pd);
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getHistoryRawData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public List<PointData> getHistorySnapData(String fullPointName, String beginTime, String endTime, int period) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            DNAVal[] vs = apiEntry.getHistSnap(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            if (vs != null) {
                DNAVal[] dNAValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAVal dnaVal = dNAValArray[n2];
                    PointData pd = new PointData();
                    pd.setValue(dnaVal.DValue);
                    pd.setUtcTime(dnaVal.Time);
                    pd.setStatus(dnaVal.Status);
                    pd.setPointId(fullPointName);
                    pds.add(pd);
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getHistorySnapData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public PointData getHistorySnapData(String fullPointName, String hisTime) {
        PointData pd = null;
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            DNAVal[] vs = apiEntry.getHistSnap(fullPointName, EdnaApiHelper.parseDateStringToUTC(hisTime), EdnaApiHelper.parseDateStringToUTC(hisTime), 1);
            if (vs != null) {
                DNAVal[] dNAValArray = vs;
                if (vs.length != 0) {
                    DNAVal dnaVal = dNAValArray[0];
                    pd = new PointData();
                    pd.setValue(dnaVal.DValue);
                    pd.setUtcTime(dnaVal.Time);
                    pd.setStatus(dnaVal.Status);
                    pd.setPointId(fullPointName);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getHistorySnapData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        return pd;
    }

    @Override
    public List<PointData> getHistoryMatrixSnapData(List<String> fullPointName, String hisTime) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            String[] tagNames = fullPointName.toArray(new String[fullPointName.size()]);
            DNAVal[] vs = apiEntry.getHistMatrix(tagNames, EdnaApiHelper.parseDateStringToUTC(hisTime));
            if (vs != null && vs.length == tagNames.length) {
                int count = 0;
                DNAVal[] dNAValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAVal dnaVal = dNAValArray[n2];
                    PointData pd = new PointData();
                    pd.setValue(dnaVal.DValue);
                    pd.setUtcTime(dnaVal.Time);
                    pd.setStatus(dnaVal.Status);
                    pd.setPointId(tagNames[count++]);
                    pds.add(pd);
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getHistoryMatrixSnapData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public List<PointData> getAvgHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            DNAStatVal[] vs = apiEntry.getHistStat(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            if (vs != null) {
                DNAStatVal[] dNAStatValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAStatVal dnaVal = dNAStatValArray[n2];
                    PointData pd = new PointData();
                    pd.setValue(dnaVal.avg.DValue);
                    pd.setUtcTime(dnaVal.avg.Time);
                    pd.setStatus(dnaVal.avg.Status);
                    pd.setPointId(fullPointName);
                    pds.add(pd);
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getAvgHistoryData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public PointData getAvgHistoryData(String fullPointName, String beginTime, String endTime) {
        List<PointData> pds = this.getAvgHistoryData(fullPointName, beginTime, endTime, EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue());
        PointData pd = null;
        if (!pds.isEmpty()) {
            pd = pds.get(0);
        }
        return pd;
    }

    @Override
    public List<PointData> getMaxHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            DNAStatVal[] vs = apiEntry.getHistStat(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            if (vs != null) {
                DNAStatVal[] dNAStatValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAStatVal dnaVal = dNAStatValArray[n2];
                    PointData pd = new PointData();
                    pd.setValue(dnaVal.max.DValue);
                    pd.setUtcTime(dnaVal.max.Time);
                    pd.setStatus(dnaVal.max.Status);
                    pd.setPointId(fullPointName);
                    pds.add(pd);
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getMaxHistoryData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public PointData getMaxHistoryData(String fullPointName, String beginTime, String endTime) {
        List<PointData> pds = this.getMaxHistoryData(fullPointName, beginTime, endTime, EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue());
        PointData pd = null;
        if (!pds.isEmpty()) {
            pd = pds.get(0);
        }
        return pd;
    }

    @Override
    public List<PointData> getMinHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            DNAStatVal[] vs = apiEntry.getHistStat(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            if (vs != null) {
                DNAStatVal[] dNAStatValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAStatVal dnaVal = dNAStatValArray[n2];
                    PointData pd = new PointData();
                    pd.setValue(dnaVal.min.DValue);
                    pd.setUtcTime(dnaVal.min.Time);
                    pd.setStatus(dnaVal.min.Status);
                    pd.setPointId(fullPointName);
                    pds.add(pd);
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getMinHistoryData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public PointData getMinHistoryData(String fullPointName, String beginTime, String endTime) {
        List<PointData> pds = this.getMinHistoryData(fullPointName, beginTime, endTime, EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue());
        PointData pd = null;
        if (!pds.isEmpty()) {
            pd = pds.get(0);
        }
        return pd;
    }

    @Override
    public List<String> getRealTimeServices() {
        return null;
    }

    @Override
    public String getLongId(String fullPointName) {
        return null;
    }

    @Override
    public void createPoint(String serviceIp, String servicePort, List<PointInfo> pis) {
    }

    @Override
    public void createPoint(String serviceIp, String servicePort, PointInfo pi) {
    }

    @Override
    public void writePoint(String serviceIp, String servicePort, List<PointData> pds) {
        if (pds != null && !pds.isEmpty()) {
            ApiEntry entry = null;
            try {
                entry = this.getApiEntry();
                DNAPointVal[] recs = new DNAPointVal[pds.size()];
                PointData pd = null;
                Iterator<PointData> it = pds.iterator();
                int i = 0;
                while (it.hasNext()) {
                    pd = it.next();
                    DNAPointVal v = new DNAPointVal();
                    v.Name = pd.getPointId();
                    v.Val.Time = pd.getUtcTime();
                    v.Val.Status = (short)3;
                    v.Val.DValue = pd.getValue();
                    recs[i] = v;
                    ++i;
                }
                entry.sendMultiPoint(recs);
            }
            catch (SocketException e) {
                e.printStackTrace();
                this.logger.error((Object)("\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
            }
            catch (IOException ie) {
                this.logger.error((Object)("IO\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + ie.getMessage()));
            }
            catch (Exception ex) {
                this.logger.error((Object)("edos\u5199\u5165\u672a\u77e5\u5f02\u5e38!" + ex.getMessage()));
            }
        }
    }

    @Override
    public void writePoint(String serviceIp, String servicePort, PointData pd) {
        ApiEntry entry = null;
        try {
            entry = this.getApiEntry();
            DNAVal[] vs = new DNAVal[1];
            DNAVal v = new DNAVal();
            v.Time = pd.getUtcTime();
            v.Status = (short)3;
            v.DValue = pd.getValue();
            vs[0] = v;
            entry.sendSinglePoint(pd.getPointId(), vs);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (IOException ie) {
            this.logger.error((Object)("IO\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + ie.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u5199\u5165\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + pd.getPointId()));
        }
    }

    @Override
    public Integer putHistoryData(String fullPointName, List<PointData> pds) {
        ApiEntry entry = null;
        try {
            if (pds != null && !pds.isEmpty()) {
                entry = this.getApiEntry();
                DNAVal[] vs = new DNAVal[pds.size()];
                int count = 0;
                for (PointData pd : pds) {
                    DNAVal v = new DNAVal();
                    v.Time = pd.getUtcTime();
                    v.Status = (short)3;
                    v.DValue = pd.getValue();
                    vs[count++] = v;
                }
                entry.updatePointData(fullPointName, vs);
                return 1;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (IOException ie) {
            this.logger.error((Object)("IO\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + ie.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u66f4\u65b0\u64cd\u4f5c\u672a\u77e5\u5f02\u5e38!" + ex.getMessage()));
        }
        return 0;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Log getLogger() {
        return this.logger;
    }

    @Override
    public List<PointData> getHistorySnapDataNotLeft(String fullPointName, String beginTime, String endTime, int period) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            DNAVal[] vs = apiEntry.getHistSnapRaw(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            if (vs != null) {
                DNAVal[] dNAValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAVal dnaVal = dNAValArray[n2];
                    PointData pd = new PointData();
                    pd.setValue(dnaVal.DValue);
                    pd.setUtcTime(dnaVal.Time);
                    pd.setStatus(dnaVal.Status);
                    pd.setPointId(fullPointName);
                    pds.add(pd);
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getHistorySnapData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public List<PointData> getAvgHistoryDataNotLeft(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            DNAStatVal[] vs = apiEntry.getHistStatNoFillTime(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            if (vs != null) {
                Date date = StringUtils.toDate((String)beginTime, (String)"yyyy-MM-dd HH:mm:ss");
                int beginTimeInt = (int)(date.getTime() / 1000L);
                DNAStatVal[] dNAStatValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAStatVal dnaVal = dNAStatValArray[n2];
                    if (dnaVal.avg.Time >= beginTimeInt) {
                        PointData pd = new PointData();
                        pd.setValue(dnaVal.avg.DValue);
                        pd.setUtcTime(dnaVal.avg.Time);
                        pd.setStatus(dnaVal.avg.Status);
                        pd.setPointId(fullPointName);
                        pds.add(pd);
                    }
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getAvgHistoryData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        pds = PointDataRDUtils.rd(pds);
        Collections.sort(pds);
        return pds;
    }

    @Override
    public List<PointData> getMaxHistoryDataNotLeft(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            DNAStatVal[] vs = apiEntry.getHistStatNoFillTime(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            if (vs != null) {
                Date date = StringUtils.toDate((String)beginTime, (String)"yyyy-MM-dd HH:mm:ss");
                int beginTimeInt = (int)(date.getTime() / 1000L);
                DNAStatVal[] dNAStatValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAStatVal dnaVal = dNAStatValArray[n2];
                    if (dnaVal.avg.Time >= beginTimeInt) {
                        PointData pd = new PointData();
                        pd.setValue(dnaVal.max.DValue);
                        pd.setUtcTime(dnaVal.max.Time);
                        pd.setStatus(dnaVal.max.Status);
                        pd.setPointId(fullPointName);
                        pds.add(pd);
                    }
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getMaxHistoryData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        pds = PointDataRDUtils.rd(pds);
        Collections.sort(pds);
        return pds;
    }

    @Override
    public List<PointData> getMinHistoryDataNotLeft(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = this.getApiEntry();
            DNAStatVal[] vs = apiEntry.getHistStatNoFillTime(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            if (vs != null) {
                Date date = StringUtils.toDate((String)beginTime, (String)"yyyy-MM-dd HH:mm:ss");
                int beginTimeInt = (int)(date.getTime() / 1000L);
                DNAStatVal[] dNAStatValArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    DNAStatVal dnaVal = dNAStatValArray[n2];
                    if (dnaVal.avg.Time >= beginTimeInt) {
                        PointData pd = new PointData();
                        pd.setValue(dnaVal.min.DValue);
                        pd.setUtcTime(dnaVal.min.Time);
                        pd.setStatus(dnaVal.min.Status);
                        pd.setPointId(fullPointName);
                        pds.add(pd);
                    }
                    ++n2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getMinHistoryData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("edos\u672a\u77e5\u5f02\u5e38!" + ex.getMessage() + " RTID:" + fullPointName));
        }
        pds = PointDataRDUtils.rd(pds);
        Collections.sort(pds);
        return pds;
    }
}

