/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.common;

import cn.gyee.appsoft.jrt.model.PointData;
import cn.gyee.appsoft.jrt.model.PointInfo;
import cn.gyee.appsoft.jrt.yb.DNAPointConfig;
import cn.gyee.appsoft.jrt.yb.DNAPointVal;
import cn.gyee.appsoft.jrt.yb.DNAVal;
import com.instep.jedna.data.AddConfigRec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class EdnaApiHelper {
    public static final String CACHE_FILENAME = "szCacheFileName";
    public static final String CACHE_FILENAME_DIR = "szCacheDriveDir";
    public static final Short usStatus = 3;

    public static PointData buildPointData(String pointId, Double value, Integer utcTime) {
        return new PointData(pointId, value, utcTime, 0, (short)3);
    }

    public static PointData buildPointData(String pointId, Double value) {
        PointData pd = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Integer utcTime = EdnaApiHelper.parseDateStringToUTC(format.format(new Date()));
            pd = new PointData(pointId, value, utcTime, 0, (short)3);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return pd;
    }

    public static PointData buildPointData(String date, String pointId, Double value) {
        PointData pd = null;
        try {
            Integer utcTime = EdnaApiHelper.parseDateStringToUTC(date);
            pd = new PointData(pointId, value, utcTime, 0, (short)3);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return pd;
    }

    public static PointData convertPointData(cn.gyee.appsoft.jrt.instep.PointData pointData) {
        PointData pd = new PointData();
        pd.setValue(pointData.getDValue());
        pd.setUtcTime(pointData.getUtcTime());
        pd.setMsTime(pointData.getMsTime());
        pd.setStatus(pointData.getStatus());
        return pd;
    }

    public static PointData convertPointData(DNAVal dnaVal, String pointId) {
        PointData pd = null;
        if (dnaVal != null) {
            pd = new PointData();
            pd.setValue(dnaVal.DValue);
            pd.setUtcTime(dnaVal.Time);
            pd.setStatus(dnaVal.Status);
            pd.setPointId(pointId);
        }
        return pd;
    }

    public static List<PointData> convertPointDatas(Map<String, DNAVal> map) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        PointData pd = null;
        if (!map.isEmpty()) {
            for (Map.Entry<String, DNAVal> entry : map.entrySet()) {
                pd = EdnaApiHelper.convertPointData(entry.getValue(), entry.getKey());
                pds.add(pd);
            }
        }
        return pds;
    }

    public static PointData convertHistoryPointData(DNAVal dnaVal, String pointId) {
        PointData pd = null;
        if (dnaVal != null) {
            pd = new PointData();
            pd.setValue(dnaVal.DValue);
            pd.setUtcTime(dnaVal.Time);
            pd.setStatus(dnaVal.Status);
            pd.setPointId(pointId);
        }
        return pd;
    }

    public static List<PointData> convertHistoryPointDatas(Map<String, DNAVal> map, String fullPointName) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        PointData pd = null;
        if (!map.isEmpty()) {
            for (Map.Entry<String, DNAVal> entry : map.entrySet()) {
                pd = EdnaApiHelper.convertHistoryPointData(entry.getValue(), fullPointName);
                pds.add(pd);
            }
        }
        return pds;
    }

    public static DNAPointConfig[] convertPointInfo(List<PointInfo> pis) {
        ArrayList<DNAPointConfig> configs = new ArrayList<DNAPointConfig>();
        DNAPointConfig config = null;
        if (!pis.isEmpty()) {
            int i = 0;
            while (i < pis.size()) {
                PointInfo info = pis.get(i);
                config = new DNAPointConfig();
                config.setDesc(info.getDesc());
                config.setdHistoryDeadBand(info.getHistoryDeadBand());
                config.setLongID(info.getLongId());
                config.setShortID(info.getPointId());
                config.setSzPointType(info.getPointType());
                config.setUnits(info.getUnits());
                configs.add(config);
                ++i;
            }
        }
        return configs.toArray(new DNAPointConfig[0]);
    }

    public static DNAPointVal[] convertPointData(List<PointData> pds) {
        DNAPointVal[] vals = new DNAPointVal[]{};
        if (!pds.isEmpty()) {
            vals = new DNAPointVal[pds.size()];
            int i = 0;
            while (i < vals.length) {
                PointData pd = pds.get(i);
                vals[i] = new DNAPointVal();
                vals[i].Name = pd.getPointId();
                vals[i].Val = new DNAVal();
                vals[i].Val.DValue = pd.getValue();
                vals[i].Val.Status = pd.getStatus();
                vals[i].Val.Time = pd.getUtcTime();
                ++i;
            }
        }
        return vals;
    }

    public static DNAPointVal convertPointData(PointData pd) {
        DNAPointVal dnaPoints = new DNAPointVal();
        dnaPoints.Name = pd.getPointId();
        dnaPoints.Val = new DNAVal();
        dnaPoints.Val.DValue = pd.getValue();
        dnaPoints.Val.Status = pd.getStatus();
        dnaPoints.Val.Time = pd.getUtcTime();
        return dnaPoints;
    }

    public static AddConfigRec convertPointCfg(PointInfo pi) {
        AddConfigRec point = new AddConfigRec(pi.getPointId(), pi.getLongId(), pi.getDesc(), pi.getUnits(), pi.getPointType(), pi.getIsReportAlarm().booleanValue(), pi.getAlermPriority().intValue(), pi.getDigitalAlarm(), pi.getDigitalNorm(), pi.getHighoorEnabled().booleanValue(), pi.getHighoorValue().doubleValue(), pi.getHighAlarmEnabled().booleanValue(), pi.getHighAlarmValue().doubleValue(), pi.getHighWarningEnabled().booleanValue(), pi.getHighWarningValue().doubleValue(), pi.getLowWarningEnabled().booleanValue(), pi.getLowWarningValue().doubleValue(), pi.getLowAlarmEnabled().booleanValue(), pi.getLowAlarmValue().doubleValue(), pi.getLowoorEnabled().booleanValue(), pi.getLowoorValue().doubleValue(), pi.getReportHistory().booleanValue(), pi.getReportForceHistory().booleanValue(), pi.getForcePeriod().intValue(), pi.getMinimumPeriod().intValue(), pi.getHistoryExpireDays().intValue(), pi.getHistoryDeadBand().doubleValue(), pi.getPtSecGroup().intValue(), pi.getExtendedId(), pi.getExtendedDesc());
        point.setHistoryDeadBand(pi.getHistoryDeadBand().doubleValue());
        point.setHistoryExpireDays(pi.getHistoryExpireDays().intValue());
        point.setForcePeriod(pi.getForcePeriod().intValue());
        point.setReportHistory(pi.getReportHistory().booleanValue());
        point.setReportForceHistory(pi.getReportForceHistory().booleanValue());
        return point;
    }

    public static int parseDateStringToUTC(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (date != null && !"".equals(date)) {
            return (int)(format.parse(date).getTime() / 1000L);
        }
        return (int)(format.parse(date).getTime() / 1000L);
    }

    public static Long secondsDiff(Date d1, Date d2) {
        return (long)Math.floor(Math.abs(d1.getTime() - d2.getTime()) / 1000L);
    }

    public static Date toDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Failed to parse the String [%s] to Date.", date), e);
        }
    }

    public static String parseUTCLongToDate(long date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dt = new Date(date * 1000L);
        return format.format(dt);
    }

    public static void main(String[] args) {
    }
}

