/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.web.views.components.grid;

import cn.gyee.appsoft.framework.core.web.views.Aggregatable;
import cn.gyee.appsoft.framework.core.web.views.FunctionField;
import cn.gyee.appsoft.framework.core.web.views.GridFunction;
import cn.gyee.appsoft.framework.core.web.views.components.JeeComponent;
import cn.gyee.appsoft.framework.core.web.views.components.grid.Grid;
import cn.gyee.appsoft.framework.core.web.views.components.grid.GridColumn;
import cn.gyee.appsoft.framework.core.web.views.components.grid.Group;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridColumns
extends JeeComponent {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object lastItem;
    private Map<String, Object> lastValues;
    private Grid grid;

    public GridColumns(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack, req, res);
    }

    @Override
    public boolean usesBody() {
        return true;
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
    }

    public Grid getGrid() {
        if (this.grid == null) {
            this.logger.info((Object)"\u4ece\u5f53\u524dGridColumns\u4e2d\u83b7\u53d6Grid\u6a21\u578b\u6570\u636e\u4e3anull, \u53ef\u80fd\u672a\u88ab\u8d4b\u503c, \u672a\u5148\u6267\u884cstartTag\u6807\u8bb0...");
        }
        return this.grid;
    }

    @Override
    public boolean startTag(Writer writer) throws JspException {
        this.setGrid((Grid)this.findAncestor(Grid.class));
        boolean hasNext = this.grid.iterateRow();
        if (this.grid.getSelectField() != null) {
            this.grid.appendHeaderData(this.mergeTemplate("chth.ftl", this.grid, this.grid.getStack()));
            if (hasNext) {
                this.grid.appendColumnData(this.mergeTemplate("chtd.ftl", this.grid, this.grid.getStack()));
            }
        }
        this.lastValues = new HashMap<String, Object>();
        return super.startTag(writer);
    }

    @Override
    public boolean afterTag(Writer writer) throws JspException {
        boolean result = super.afterTag(writer);
        this.lastItem = this.grid.getCurrItem();
        if (this.lastItem != null) {
            try {
                for (Group gm : this.grid.getGroups()) {
                    for (GridColumn cell : gm.getColumns()) {
                        if (cell.getData("suffix") != null) {
                            cell.setSuffix(this.getStack().findString(cell.getData("suffix").toString()));
                        }
                        if (cell.getData("prefix") == null) continue;
                        cell.setSuffix(this.getStack().findString(cell.getData("prefix").toString()));
                    }
                    for (FunctionField ff : gm.getFunctionFields()) {
                        if (ff.getDistinct() != null) {
                            Object distinctValue = this.getStack().findValue(ff.getDistinct());
                            if (distinctValue != null && distinctValue.equals(ff.getLastDistinctValue())) {
                                ff.setLastDistinctValue(distinctValue);
                                continue;
                            }
                            ff.setLastDistinctValue(distinctValue);
                        }
                        if (ff.getGridColumn() instanceof Aggregatable) {
                            Aggregatable aggr = (Aggregatable)((Object)ff.getGridColumn());
                            aggr.aggregate(this.getStack(), ff);
                            continue;
                        }
                        Object v = ff.getValue();
                        ff.setCount(ff.getCount() + 1);
                        Object pv = this.getStack().findValue(ff.getField());
                        if (ff.getFunc() == GridFunction.Count) {
                            ff.setValue(ff.getCount());
                            continue;
                        }
                        if (pv == null) continue;
                        if (ff.getFunc() == GridFunction.Avg || ff.getFunc() == GridFunction.Sum) {
                            if (!(pv instanceof Number)) {
                                pv = 0;
                            }
                            if (!(v instanceof Number)) {
                                v = 0;
                            }
                            v = ((Number)v).doubleValue() + ((Number)pv).doubleValue();
                            ff.setValue(v);
                            continue;
                        }
                        if (ff.getFunc() == GridFunction.Max) {
                            if (!(pv instanceof Comparable) || !(v instanceof Comparable) || ((Comparable)pv).compareTo(v) <= 0) continue;
                            ff.setValue(pv);
                            continue;
                        }
                        if (ff.getFunc() == GridFunction.Min) {
                            if (!(pv instanceof Comparable) || !(v instanceof Comparable) || ((Comparable)pv).compareTo(v) >= 0) continue;
                            ff.setValue(pv);
                            continue;
                        }
                        if (ff.getFunc() == GridFunction.First) {
                            if (ff.getCount() != 1) continue;
                            ff.setValue(pv);
                            continue;
                        }
                        if (ff.getFunc() != GridFunction.Last) continue;
                        ff.setValue(pv);
                    }
                    if (gm.getField() == null) continue;
                    this.lastValues.put(gm.getField(), this.grid.getStack().findValue(gm.getField()));
                }
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
        }
        boolean hasNext = this.grid.iterateRow();
        try {
            int i = 0;
            while (i < this.grid.getGroups().size()) {
                Group gm;
                boolean needOutputGroupRow = false;
                int j = i;
                while (j < this.grid.getGroups().size()) {
                    Group gm2 = this.grid.getGroups().get(j);
                    if (gm2.getField() != null && (!hasNext || this.lastItem != null) || !hasNext && gm2.getField() == null) {
                        Object val = null;
                        Object lastVal = null;
                        if (hasNext && gm2.getField() != null) {
                            val = this.grid.getStack().findValue(gm2.getField());
                        }
                        if (this.lastItem != null && gm2.getField() != null) {
                            lastVal = this.lastValues.get(gm2.getField());
                        }
                        if (!hasNext && (gm2.getField() == null || this.lastItem != null) || val != null && !val.equals(lastVal)) {
                            needOutputGroupRow = true;
                            break;
                        }
                    }
                    ++j;
                }
                if (needOutputGroupRow && !(gm = this.grid.getGroups().get(i)).getColumns().isEmpty()) {
                    this.grid.appendRowData("<tr>");
                    for (GridColumn cell : gm.getColumns()) {
                        if (cell.getAggrFunc() != null) {
                            for (FunctionField ff : gm.getFunctionFields()) {
                                if (cell == ff.getGridColumn()) {
                                    if (cell instanceof Aggregatable) {
                                        cell.setBody(((Aggregatable)((Object)cell)).output(this.getStack(), ff));
                                        ff.reset();
                                        break;
                                    }
                                    Object output = null;
                                    output = ff.getFunc() == GridFunction.Avg ? Double.valueOf(((Number)ff.getValue()).doubleValue() / (double)ff.getCount()) : ff.getValue();
                                    cell.setBody(output);
                                    ff.reset();
                                    break;
                                }
                                ff.reset();
                            }
                        }
                        String origField = cell.getField();
                        cell.setField(null);
                        this.grid.appendRowData(this.mergeTemplate("td.ftl", cell, null));
                        cell.setField(origField);
                    }
                    this.grid.appendRowData("</tr>");
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        if (hasNext) {
            if (this.grid.getSelectField() != null) {
                this.grid.appendColumnData(this.mergeTemplate("chtd.ftl", this.grid, this.grid.getStack()));
            }
            result = false;
        } else {
            result = true;
        }
        return result;
    }

    public Object getLastItem() {
        return this.lastItem;
    }

    public void setLastItem(Object lastItem) {
        this.lastItem = lastItem;
    }

    public Map<String, Object> getLastValues() {
        return this.lastValues;
    }

    public void setLastValues(Map<String, Object> lastValues) {
        this.lastValues = lastValues;
    }
}

