/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.web.views.components;

import com.opensymphony.xwork2.util.ValueStack;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.struts2.StrutsException;

public class JeeComponent {
    private static Configuration __freemarkerCfg;
    private static final String TEMPLATE_DIR = "template";
    public static final String COMPONENT_STACK = "__grid_component_stack";
    protected String id;
    protected ValueStack stack;
    protected HttpServletRequest req;
    protected HttpServletResponse res;

    public JeeComponent() {
    }

    public JeeComponent(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        this.stack = stack;
        this.req = req;
        this.res = res;
        this.getComponentStack().push(this);
    }

    public ValueStack getStack() {
        return this.stack;
    }

    public PageContext getPageContext() {
        return (PageContext)this.stack.getContext().get("com.opensymphony.xwork2.dispatcher.PageContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration getFreemarkerConfig() {
        if (__freemarkerCfg == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                __freemarkerCfg = new Configuration();
                __freemarkerCfg.setDefaultEncoding("utf-8");
                __freemarkerCfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(JeeComponent.class, TEMPLATE_DIR));
            }
        }
        return __freemarkerCfg;
    }

    public String mergeTemplate(String templateName, JeeComponent root, ValueStack stack) throws JspException {
        try {
            SimpleHash model = new SimpleHash();
            model.put("model", (Object)root);
            model.put("stack", (Object)stack);
            StringWriter out = new StringWriter();
            this.buildTemplateName(templateName).process((Object)model, (Writer)out);
            ((Writer)out).flush();
            return ((Object)out).toString();
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new JspException((Throwable)e);
        }
    }

    protected Template buildTemplateName(String templateName) throws JspException {
        try {
            return this.getFreemarkerConfig().getTemplate(templateName);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public boolean startTag(Writer writer) throws JspException {
        return true;
    }

    public boolean afterTag(Writer writer) throws JspException {
        return true;
    }

    public boolean endTag(Writer writer, String body) throws JspException {
        return this.end(writer, body, true);
    }

    protected boolean end(Writer writer, String body, boolean popComponentStack) {
        assert (body != null);
        try {
            writer.write(body);
        }
        catch (IOException e) {
            throw new StrutsException("IOError while writing the body: " + e.getMessage(), (Throwable)e);
        }
        if (popComponentStack) {
            this.popComponentStack();
        }
        return false;
    }

    protected void popComponentStack() {
        this.getComponentStack().pop();
    }

    public Stack getComponentStack() {
        Stack componentStack = (Stack)this.stack.getContext().get(COMPONENT_STACK);
        if (componentStack == null) {
            componentStack = new Stack();
            this.stack.getContext().put(COMPONENT_STACK, componentStack);
        }
        return componentStack;
    }

    public boolean usesBody() {
        return false;
    }

    public JeeComponent findAncestor(Class clazz) {
        Stack componentStack = this.getComponentStack();
        int currPosition = componentStack.search(this);
        if (currPosition >= 0) {
            int start;
            int i = start = componentStack.size() - currPosition - 1;
            while (i >= 0) {
                JeeComponent component = (JeeComponent)componentStack.get(i);
                if (clazz.isAssignableFrom(component.getClass()) && component != this) {
                    return component;
                }
                --i;
            }
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void println(JspWriter writer, String format, Object ... args) throws JspException {
        this.print(writer, format, args);
        this.print(writer, "\n", new Object[0]);
    }

    public void print(JspWriter writer, String format, Object ... args) throws JspException {
        try {
            writer.println(String.format(format, args));
        }
        catch (IOException e) {
            throw new StrutsException("IOError while writing to page: " + e.getMessage(), (Throwable)e);
        }
    }

    public void println(JspWriter writer, String htmls) throws JspException {
        try {
            writer.println(htmls);
        }
        catch (IOException e) {
            throw new StrutsException("IOError while writing to page: " + e.getMessage(), (Throwable)e);
        }
    }
}

