/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.web;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts2.ServletActionContext;

public class TokenInterceptor
extends MethodFilterInterceptor {
    private static final long serialVersionUID = 1L;
    public static final String TOKEN_FIELD_NAME = "gyee.token";
    public static final String INVALID_TOKEN_CODE = "invalid.token";

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        String tokenStr = request.getParameter(TOKEN_FIELD_NAME);
        if (tokenStr == null) {
            return this.handleValidToken(invocation);
        }
        Long tokenOnClient = Long.parseLong(tokenStr);
        HttpSession session = request.getSession(false);
        if (session == null) {
            return this.handleValidToken(invocation);
        }
        HashMap<String, Long> tokenMap = (HashMap<String, Long>)session.getAttribute(TOKEN_FIELD_NAME);
        String url = request.getRequestURI();
        if (tokenMap != null) {
            Long tokenOnServer = (Long)tokenMap.get(url);
            if (tokenOnServer != null && tokenOnClient <= tokenOnServer) {
                return this.handleInvalidToken(invocation);
            }
        } else {
            tokenMap = new HashMap<String, Long>();
            session.setAttribute(TOKEN_FIELD_NAME, tokenMap);
        }
        tokenMap.put(url, tokenOnClient);
        return this.handleValidToken(invocation);
    }

    protected String handleInvalidToken(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        String errorMessage = LocalizedTextUtil.findText(((Object)((Object)this)).getClass(), (String)"struts.messages.invalid.token", (Locale)invocation.getInvocationContext().getLocale(), (String)"The form has already been processed or no token was supplied, please try again.", (Object[])new Object[0]);
        if (action instanceof ValidationAware) {
            ((ValidationAware)action).addActionError(errorMessage);
        } else {
            this.log.warn(errorMessage, new String[0]);
        }
        return INVALID_TOKEN_CODE;
    }

    protected String handleValidToken(ActionInvocation invocation) throws Exception {
        return invocation.invoke();
    }
}

