/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.security;

import cn.gyee.appsoft.framework.core.security.AuthenticationException;
import cn.gyee.appsoft.framework.core.security.SecurityAuthentication;
import cn.gyee.appsoft.framework.core.security.User;
import cn.gyee.appsoft.framework.core.security.crypto.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.servlet.http.Cookie;
import org.apache.struts2.ServletActionContext;

public class SecurityAuthenticationControl {
    private static final String ALGORITHM = "DESede";

    public static void setAuthTicket(User user) throws Exception {
        SecurityAuthentication config = SecurityAuthentication.getInstance();
        Cookie coo = new Cookie(config.getAuthKey(), URLEncoder.encode(SecurityAuthenticationControl.genAuthTicket(user), "UTF-8"));
        if (config.getDomain() != null) {
            coo.setDomain(config.getDomain());
        }
        if (config.getPath() != null) {
            coo.setPath(config.getPath());
        } else if (ServletActionContext.getRequest() != null) {
            config.setPath(String.valueOf(ServletActionContext.getRequest().getContextPath()) + "/");
        }
        if (config.getExpired() != 0) {
            coo.setMaxAge(config.getExpired());
        }
        if (ServletActionContext.getResponse() != null) {
            ServletActionContext.getResponse().addCookie(coo);
        }
    }

    public static void removeAuthTicket() {
        if (ServletActionContext.getResponse() != null) {
            SecurityAuthentication config = SecurityAuthentication.getInstance();
            Cookie coo = new Cookie(config.getAuthKey(), "");
            if (config.getDomain() != null) {
                coo.setDomain(config.getDomain());
            }
            if (config.getPath() != null) {
                coo.setPath(config.getPath());
            }
            coo.setMaxAge(0);
            ServletActionContext.getResponse().addCookie(coo);
        }
    }

    public static String genAuthTicket(User user) throws Exception {
        SecurityAuthentication config = SecurityAuthentication.getInstance();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(out);
        oo.writeObject(user);
        String ticketContent = Base64.encode(SecurityAuthenticationControl.crypto(1, config.getKey().getBytes(), out.toByteArray()));
        return ticketContent;
    }

    public static User getAuthUser() throws Exception {
        SecurityAuthentication config = SecurityAuthentication.getInstance();
        Cookie[] cookies = ServletActionContext.getRequest().getCookies();
        String authInfo = null;
        int i = 0;
        while (cookies != null && i < cookies.length) {
            Cookie cookie = cookies[i];
            if (cookie.getName().equals(config.getAuthKey())) {
                authInfo = URLDecoder.decode(cookie.getValue(), "UTF-8");
                break;
            }
            ++i;
        }
        if (authInfo == null) {
            return null;
        }
        return SecurityAuthenticationControl.getAuthUser(authInfo);
    }

    public static User getAuthUser(String authInfo) throws Exception {
        SecurityAuthentication config = SecurityAuthentication.getInstance();
        if (authInfo == null || authInfo.length() == 0) {
            throw new AuthenticationException("Cannot find authenticate ticket.");
        }
        byte[] authData = Base64.decode(authInfo);
        if (authData.length == 0) {
            throw new AuthenticationException("Cannot find expected authenticate ticket.");
        }
        byte[] decodedData = SecurityAuthenticationControl.crypto(2, config.getKey().getBytes(), authData);
        ByteArrayInputStream bais = new ByteArrayInputStream(decodedData);
        ObjectInputStream ois = new ObjectInputStream(bais);
        User user = (User)ois.readObject();
        return user;
    }

    public static byte[] crypto(int mode, byte[] key, byte[] screteData) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        byte[] fixedKey = SecurityAuthenticationControl.fixKey(key, 24);
        DESedeKeySpec keySpec = new DESedeKeySpec(fixedKey);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(cipher.getAlgorithm());
        SecretKey secretKey = factory.generateSecret(keySpec);
        cipher.init(mode, secretKey);
        return cipher.doFinal(screteData);
    }

    private static byte[] fixKey(byte[] key, int dueLen) {
        if (key.length != dueLen) {
            byte[] r = new byte[dueLen];
            int i = 0;
            while (i < key.length && i < dueLen) {
                r[i] = key[i];
                ++i;
            }
            return r;
        }
        return key;
    }

    private static byte[] fromString(String str) {
        byte[] bytes = new byte[str.length() / 2];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
        return bytes;
    }
}

