/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.security;

import cn.gyee.appsoft.framework.core.SkipSessionInAction;
import cn.gyee.appsoft.framework.core.security.AuthenticationException;
import cn.gyee.appsoft.framework.core.security.PermissionHelper;
import cn.gyee.appsoft.framework.core.web.action.AuthorizedAction;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;

public class PermissionInterceptor
implements Interceptor {
    private static final long serialVersionUID = 1L;

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Set<String> currPermIdSet;
        if (!(invocation.getAction() instanceof AuthorizedAction)) {
            return invocation.invoke();
        }
        SkipSessionInAction noSessionAnn = invocation.getAction().getClass().getAnnotation(SkipSessionInAction.class);
        if (noSessionAnn != null) {
            String[] methods = noSessionAnn.methods();
            if (methods == null || methods.length == 0) {
                return invocation.invoke();
            }
            int i = 0;
            while (i < methods.length) {
                if (methods[i].equals(invocation.getProxy().getMethod())) {
                    return invocation.invoke();
                }
                ++i;
            }
        }
        PermissionHelper ph = PermissionHelper.getInstance();
        AuthorizedAction action = (AuthorizedAction)((Object)invocation.getAction());
        HttpServletRequest request = ServletActionContext.getRequest();
        StringBuilder path = new StringBuilder(request.getRequestURI().replace(request.getContextPath(), ""));
        if (request.getQueryString() != null) {
            path.append("?").append(request.getQueryString());
        }
        if ((currPermIdSet = ph.getPermByPath(path.toString())).size() > 0) {
            Set<String> permIdSet = ph.getUserPermissions(action.getUser().getId());
            boolean hasPermission = false;
            for (String permId : currPermIdSet) {
                if (!permIdSet.contains(permId)) continue;
                hasPermission = true;
                break;
            }
            if (!hasPermission) {
                throw new AuthenticationException();
            }
        }
        return invocation.invoke();
    }
}

