/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.security;

import cn.gyee.appsoft.framework.core.security.AuthenticationException;
import cn.gyee.appsoft.framework.core.security.ISecurityService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;

public class PermissionHelper
implements InitializingBean {
    public static final String CACHE_KEY_USER_GROUP = "userGroup";
    private static PermissionHelper _instance;
    private ISecurityService securityService;

    public static PermissionHelper getInstance() {
        return _instance;
    }

    public Set<String> getPermByPath(String path) {
        HashSet<String> set = new HashSet<String>(5);
        Map<String, String> map = this.securityService.findAllPerm();
        if (!map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!path.startsWith(entry.getValue())) continue;
                set.add(entry.getKey());
            }
        }
        return set;
    }

    public Set<String> getUserPermissions(String userId) {
        Set<String> permIds = null;
        try {
            permIds = this.securityService.obtainPermisions(userId);
        }
        catch (AuthenticationException e) {
            throw new AuthenticationException();
        }
        return permIds;
    }

    public void setSecurityService(ISecurityService securityService) {
        this.securityService = securityService;
    }

    public void afterPropertiesSet() throws Exception {
        _instance = this;
    }
}

