/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.security;

import cn.gyee.appsoft.framework.core.security.PrincipalHolder;
import cn.gyee.appsoft.framework.core.security.SecurityAuthenticationControl;
import cn.gyee.appsoft.framework.core.security.User;
import cn.gyee.appsoft.framework.core.web.action.AuthorizedAction;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class AuthenticationInterceptor
implements Interceptor {
    private static final long serialVersionUID = 1L;
    public static final String KS_AUTH_USER_KEY = "jeeweb.auth.user";
    private static final String LOGIN_RESULT = "login";
    private Log _log = LogFactory.getLog(this.getClass());

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest request;
        User user;
        block7: {
            if (!(invocation.getAction() instanceof AuthorizedAction)) {
                return invocation.invoke();
            }
            user = null;
            try {
                user = SecurityAuthenticationControl.getAuthUser();
                request = ServletActionContext.getRequest();
                if (user != null) break block7;
                String returnURL = request.getRequestURI().replace(request.getContextPath(), "");
                StringBuilder href = new StringBuilder();
                href.append(returnURL.indexOf("?") == -1 ? "?" : "&");
                request.setAttribute("returnURL", (Object)href.append("returnURL=").append(returnURL));
                return LOGIN_RESULT;
            }
            catch (Exception ex) {
                this._log.error((Object)"Cannot parse the client auth ticket data.", (Throwable)ex);
                return LOGIN_RESULT;
            }
        }
        ((AuthorizedAction)((Object)invocation.getAction())).setUser(user);
        request.setAttribute(KS_AUTH_USER_KEY, (Object)user);
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        PrincipalHolder.setUser(user);
        try {
            String string = invocation.invoke();
            return string;
        }
        finally {
            PrincipalHolder.setUser(null);
        }
    }
}

