/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.orm;

import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.util.StringHelper;

public class PrefixalNamingStrategy
extends EJB3NamingStrategy {
    private static final long serialVersionUID = 1L;
    public static final String CHAR_UNDERSCORE = "_";
    private String _tablePrefix = "";
    private String _columnPrefix = "";
    private boolean _underscores = false;
    public static final NamingStrategy INSTANCE = new PrefixalNamingStrategy();

    public void setTablePrefix(String tablePrefix) {
        if (StringHelper.isNotEmpty((String)tablePrefix)) {
            this._tablePrefix = tablePrefix;
        }
    }

    public void setColumnPrefix(String columnPrefix) {
        if (StringHelper.isNotEmpty((String)columnPrefix)) {
            this._columnPrefix = columnPrefix;
        }
    }

    public void setUnderscores(boolean underscores) {
        this._underscores = underscores;
    }

    public String classToTableName(String className) {
        return this.addPrefixes(StringHelper.unqualify((String)className), this._tablePrefix);
    }

    public String propertyToColumnName(String propertyName) {
        return this.addPrefixes(StringHelper.unqualify((String)propertyName), this._columnPrefix);
    }

    public String tableName(String tableName) {
        return this.addPrefixes(tableName, this._tablePrefix);
    }

    public String columnName(String columnName) {
        return this.addPrefixes(columnName, this._columnPrefix);
    }

    private String addPrefixes(String name, String prefix) {
        if (prefix == null || prefix.length() == 0 || name.indexOf(CHAR_UNDERSCORE) != -1) {
            return name;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix).append(CHAR_UNDERSCORE);
        if (this._underscores) {
            buffer.append(this.addUnderscores(name));
        } else {
            buffer.append(name);
        }
        return buffer.toString();
    }

    private String addUnderscores(String name) {
        StringBuilder buf = new StringBuilder(name.replace('.', '_'));
        int i = 1;
        while (i < buf.length() - 1) {
            if (Character.isLowerCase(buf.charAt(i - 1)) && Character.isUpperCase(buf.charAt(i)) && Character.isLowerCase(buf.charAt(i + 1))) {
                buf.insert(i++, '_');
            }
            ++i;
        }
        return buf.toString().toLowerCase();
    }
}

