/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.core.orm;

import cn.gyee.appsoft.framework.commons.util.ParamsHelper;
import cn.gyee.appsoft.framework.core.orm.BaseHibernateGenericDao;
import cn.gyee.appsoft.framework.core.orm.HibernateDaoTemplate;
import cn.gyee.appsoft.framework.core.orm.HibernateQbcCallback;
import cn.gyee.appsoft.framework.core.orm.PaginationList;
import cn.gyee.appsoft.framework.core.orm.QueryOrder;
import cn.gyee.appsoft.framework.core.orm.exception.EntityNotFoundException;
import cn.gyee.appsoft.framework.core.orm.exception.HibernateDaoException;
import cn.gyee.appsoft.framework.core.orm.exception.HibernateDaoExceptionTranslator;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.orm.hibernate3.HibernateCallback;

public class GenericHibernateDao<T>
implements BaseHibernateGenericDao<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final HibernateDaoExceptionTranslator jdbcExceptionTranslator = new HibernateDaoExceptionTranslator();
    protected DataFieldMaxValueIncrementer idGenarater;
    protected final HibernateDaoTemplate proxy = new HibernateDaoTemplate();

    public void setSessionFactory(SessionFactory factory) {
        this.proxy.setSessionFactory(factory);
        this.proxy.setJdbcExceptionTranslator(jdbcExceptionTranslator);
    }

    protected void setAllowCreate(boolean allowCreate) {
        this.proxy.setAllowCreate(allowCreate);
    }

    protected boolean isAllowCreate() {
        return this.proxy.isAllowCreate();
    }

    protected void setAlwaysUseNewSession(boolean alwaysUseNewSession) {
        this.proxy.setAlwaysUseNewSession(alwaysUseNewSession);
    }

    protected boolean isAlwaysUseNewSession() {
        return this.proxy.isAlwaysUseNewSession();
    }

    protected void setCacheQueries(boolean cacheQueries) {
        this.proxy.setCacheQueries(cacheQueries);
    }

    protected boolean isCacheQueries() {
        return this.proxy.isCacheQueries();
    }

    protected void setQueryCacheRegion(String queryCacheRegion) {
        this.proxy.setQueryCacheRegion(queryCacheRegion);
    }

    protected String getQueryCacheRegion() {
        return this.proxy.getQueryCacheRegion();
    }

    protected void setFetchSize(int fetchSize) {
        this.proxy.setFetchSize(fetchSize);
    }

    protected int getFetchSize() {
        return this.proxy.getFetchSize();
    }

    protected static Type getGenericAncestralType(Type t) {
        if (!(t instanceof Class)) {
            return null;
        }
        Class clazz = (Class)t;
        Type superClass = clazz.getGenericSuperclass();
        if (superClass instanceof ParameterizedType) {
            return superClass;
        }
        if (superClass instanceof Class) {
            return GenericHibernateDao.getGenericAncestralType(superClass);
        }
        return null;
    }

    protected final Class getEntityClass() {
        Type clazz = GenericHibernateDao.getGenericAncestralType(this.getClass());
        if (clazz instanceof ParameterizedType) {
            return (Class)((ParameterizedType)clazz).getActualTypeArguments()[0];
        }
        throw new HibernateDaoException("This method can only be invoked for parameterized dao class.");
    }

    @Override
    public void delete(T t) {
        if (t == null) {
            return;
        }
        this.proxy.delete(t);
    }

    @Override
    public void delete(final Serializable pk) {
        final ClassMetadata meta = this.proxy.getSessionFactory().getClassMetadata(this.getEntityClass());
        this.proxy.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object obj = session.get(meta.getEntityName(), pk);
                if (obj != null) {
                    session.delete(obj);
                }
                return null;
            }
        });
    }

    @Override
    public void save(T entity) {
        this.proxy.saveOrUpdate(entity);
    }

    @Override
    public T get(Serializable id) {
        return (T)this.proxy.get(this.getEntityClass(), id);
    }

    public void update(T entity) {
        this.proxy.update(entity);
    }

    public <U> U get(Serializable id, Class<U> clazz) {
        return (U)this.proxy.get(clazz, id);
    }

    public <U> void save(U entity, Class<U> clazz) {
        this.proxy.saveOrUpdate(entity);
    }

    public <U> void delete(U entity, Class<U> clazz) {
        if (entity != null) {
            this.proxy.delete(entity);
        }
    }

    public T retrieve(Serializable id) {
        Class entityClass = this.getEntityClass();
        Object obj = this.proxy.get(entityClass, id);
        if (obj == null) {
            throw new EntityNotFoundException(id, entityClass);
        }
        return (T)obj;
    }

    public boolean exists(final Serializable pk) {
        final ClassMetadata meta = this.proxy.getSessionFactory().getClassMetadata(this.getEntityClass());
        return (Long)this.proxy.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                String hql = String.format("select count(*) from %s where %s = :pk", meta.getEntityName(), meta.getIdentifierPropertyName());
                Query queryObject = session.createQuery(hql);
                queryObject.setParameter("pk", (Object)pk);
                return (Long)queryObject.uniqueResult();
            }
        }) > 0L;
    }

    public void deleteAll(Collection<T> entities) {
        this.proxy.deleteAll(entities);
    }

    public List<T> findByProperties(Map<String, ?> criteria, QueryOrder ... orders) {
        return this.proxy.findByProperties(this.getEntityClass(), criteria, orders);
    }

    public PaginationList<T> findByProperties(Map<String, ?> criteria, int offset, int maxResults, QueryOrder ... orders) {
        return this.proxy.findByProperties(this.getEntityClass(), criteria, offset, maxResults, orders);
    }

    @Override
    public List<T> findAll() {
        return this.findAll(new QueryOrder[0]);
    }

    public List<T> findAll(QueryOrder ... orders) {
        return this.findByProperties(null, orders);
    }

    public PaginationList<T> findAll(int offset, int maxResults, QueryOrder ... orders) {
        return this.findByProperties(null, offset, maxResults, orders);
    }

    public List<T> findByIdList(Collection<Serializable> idValues, QueryOrder ... orders) {
        return this.proxy.findByIdList(this.getEntityClass(), idValues, orders);
    }

    public List<T> findByIdList(Serializable[] idValues, QueryOrder ... orders) {
        return this.proxy.findByIdList(this.getEntityClass(), idValues, orders);
    }

    public List<T> findByProperty(String propertyName, Object propertyValue, QueryOrder ... orders) {
        return this.findByProperties(ParamsHelper.build(propertyName, propertyValue), orders);
    }

    public PaginationList<T> findByProperty(String propertyName, Object propertyValue, int offset, int maxResults, QueryOrder ... orders) {
        return this.findByProperties(ParamsHelper.build(propertyName, propertyValue), offset, maxResults, orders);
    }

    private Criteria prepareCriteria(Session session, T t, boolean excludeEmptyProperties, boolean likeMatch, QueryOrder ... orders) {
        Criteria c = session.createCriteria(t.getClass());
        Example example = Example.create(t);
        QueryOrder[] queryOrderArray = orders;
        int n = orders.length;
        int n2 = 0;
        while (n2 < n) {
            QueryOrder order = queryOrderArray[n2];
            order.appendHibernateOrder(c);
            ++n2;
        }
        if (excludeEmptyProperties) {
            example.excludeZeroes();
        }
        if (likeMatch) {
            example.enableLike();
        }
        c.add((Criterion)example);
        this.proxy.prepareCriteria(c);
        return c;
    }

    protected List<T> findByExample(final T t, final QueryOrder ... orders) {
        return (List)this.proxy.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return GenericHibernateDao.this.prepareCriteria(session, t, true, false, orders).list();
            }
        });
    }

    protected T uniqueByExample(final T t, final QueryOrder ... orders) {
        return (T)this.proxy.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return GenericHibernateDao.this.prepareCriteria(session, t, true, false, orders).setFirstResult(0).setMaxResults(1).uniqueResult();
            }
        });
    }

    protected PaginationList<T> findByExample(T t, int offset, int maxResults, QueryOrder ... orders) {
        return this.proxy.findByExample(t, offset, maxResults, orders);
    }

    public T uniqueByProperty(String propertyName, Object value, QueryOrder ... orders) {
        return this.uniqueByProperties(ParamsHelper.build(propertyName, value), orders);
    }

    public T uniqueByProperties(Map<String, ?> criteria, QueryOrder ... orders) {
        return (T)this.proxy.uniqueByProperties(this.getEntityClass(), criteria, orders);
    }

    public List find(String hql, Object ... parameters) {
        return this.proxy.find(null, hql, parameters);
    }

    public Object unique(String hql, Object ... parameters) {
        return this.proxy.unique(null, hql, parameters);
    }

    public PaginationList findExtends(String hql, int offset, int maxResults, Object ... parameters) {
        return this.proxy.findExtends(null, hql, offset, maxResults, parameters);
    }

    public Object unique(String hql, Map<String, ?> parameters) {
        return this.proxy.unique(null, hql, parameters);
    }

    public List find(String hql, Map<String, ?> parameters) {
        return this.proxy.find(null, hql, parameters);
    }

    public PaginationList find(String hql, Map<String, ?> parameters, int offset, int maxResults) {
        if (parameters == null) {
            return this.findExtends(hql, offset, maxResults, new Object[0]);
        }
        return this.find(null, hql, parameters, offset, maxResults);
    }

    public List find(Class clazz, String hql, Map<String, ?> parameters) {
        return this.proxy.find(clazz, hql, parameters);
    }

    public PaginationList find(Class clazz, String hql, Map<String, ?> parameters, int offset, int maxResults) {
        return this.proxy.find(clazz, hql, parameters, offset, maxResults);
    }

    protected List findByNamedQuery(String queryName, Object ... parameters) {
        return this.proxy.findByNamedQuery(queryName, parameters);
    }

    protected List findByNamedQuery(String queryName, Map<String, ?> parameters) {
        String[] names = new String[parameters.size()];
        Object[] values = new Object[names.length];
        int i = 0;
        Iterator<String> ite = parameters.keySet().iterator();
        while (ite.hasNext()) {
            names[i] = ite.next();
            values[i] = parameters.get(names[i]);
            ++i;
        }
        return this.proxy.findByNamedQueryAndNamedParam(queryName, names, values);
    }

    public List findByNativeSQL(String sql) {
        return this.proxy.findByNativeSQL(null, sql, new Object[0]);
    }

    public List findByNativeSQL(Class clazz, String sql, Object ... params) {
        return this.proxy.findByNativeSQL(clazz, sql, params);
    }

    public List findByNativeSQL(String sql, Map<String, ?> parameters) {
        return this.proxy.findByNativeSQL(null, sql, parameters);
    }

    public PaginationList findByNativeSQL(String sql, int offset, int maxResults) {
        return this.findByNativeSQL(sql, null, offset, maxResults);
    }

    public PaginationList findByNativeSQL(String sql, Map<String, ?> parameters, int offset, int maxResults) {
        return this.proxy.findByNativeSQL(null, sql, parameters, offset, maxResults);
    }

    public Object uniqueByNativeSQL(String sql, Object ... parameters) {
        return this.proxy.uniqueByNativeSQL(null, sql, parameters);
    }

    public Object uniqueByNativeSQL(String sql, Map<String, ?> parameters) {
        return this.proxy.uniqueByNativeSQL(null, sql, parameters);
    }

    public int bulkUpdate(String dmlHQL, Object ... parameters) {
        return this.proxy.bulkUpdate(dmlHQL, parameters);
    }

    public int bulkUpdate(String dmlHQL, Map<String, ?> parameters) {
        return this.proxy.bulkUpdate(dmlHQL, parameters);
    }

    public int executeNativeSql(String sql, Object ... parameters) {
        return this.proxy.executeNativeSql(sql, parameters);
    }

    protected Object findByCriteria(final Class clazz, final HibernateQbcCallback callback) {
        return this.proxy.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria c = session.createCriteria(clazz);
                GenericHibernateDao.this.proxy.prepareCriteria(c);
                return callback.doQuery(c);
            }
        });
    }

    public long count(Map<String, ?> properties) {
        return this.proxy.count(this.getEntityClass(), properties);
    }

    public Number sum(String propertyName, Map<String, ?> properties) {
        return this.proxy.sum(this.getEntityClass(), propertyName, properties);
    }

    public Object max(Class<?> clazz, String propertyName, Map<String, ?> properties) {
        return this.proxy.max(this.getEntityClass(), propertyName, properties);
    }

    public Object min(String propertyName, Map<String, ?> properties) {
        return this.proxy.min(this.getEntityClass(), propertyName, properties);
    }
}

