/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.commons.util;

import java.util.ArrayList;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtils {
    public static int HANZI_UNICODE_START = 19968;
    public static int HANZI_UNICODE_END = 40869;

    public static String getPinyinInitial(String name) {
        ArrayList<Character> cl = new ArrayList<Character>(name.length());
        HanyuPinyinOutputFormat f = new HanyuPinyinOutputFormat();
        f.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        f.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        f.setVCharType(HanyuPinyinVCharType.WITH_V);
        try {
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                if (c >= HANZI_UNICODE_START && c < HANZI_UNICODE_END) {
                    String[] py = PinyinHelper.toHanyuPinyinStringArray((char)name.charAt(i), (HanyuPinyinOutputFormat)f);
                    if (py != null) {
                        cl.add(Character.valueOf(py[0].charAt(0)));
                    }
                } else {
                    cl.add(Character.valueOf(Character.toUpperCase(c)));
                }
                ++i;
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination i) {
            // empty catch block
        }
        char[] ca = new char[cl.size()];
        int i = 0;
        while (i < ca.length) {
            ca[i] = ((Character)cl.get(i)).charValue();
            ++i;
        }
        return new String(ca);
    }

    public static String getPinyinComplete(String name) {
        StringBuilder result = new StringBuilder();
        HanyuPinyinOutputFormat f = new HanyuPinyinOutputFormat();
        f.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        f.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        f.setVCharType(HanyuPinyinVCharType.WITH_V);
        try {
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                if (c >= HANZI_UNICODE_START && c < HANZI_UNICODE_END) {
                    String[] py = PinyinHelper.toHanyuPinyinStringArray((char)name.charAt(i), (HanyuPinyinOutputFormat)f);
                    if (py != null) {
                        result.append(py[0]);
                    }
                } else {
                    result.append(c);
                }
                ++i;
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            // empty catch block
        }
        return result.toString();
    }
}

