/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MD5CodeUtil {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    protected static final String[] HEXDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    private MD5CodeUtil() {
    }

    public static final String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            resultSb.append(MD5CodeUtil.byteToHexString(b[i]));
            ++i;
        }
        return resultSb.toString();
    }

    public static final String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        return String.valueOf(hexDigits[n / 16]) + hexDigits[n % 16];
    }

    public static String encodeFile(String fileAbsolutePath) {
        String resultString = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            File file = new File(fileAbsolutePath);
            if (file.exists()) {
                FileInputStream in = new FileInputStream(file);
                byte[] fileBytes = new byte[(int)file.length()];
                in.read(fileBytes);
                resultString = MD5CodeUtil.byteArrayToHexString(md.digest(fileBytes));
                in.close();
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultString;
    }

    public static final byte[] encodeToBytes(String origin) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(new String(origin).getBytes());
        }
        catch (Exception e) {
            System.err.println("\u65e0\u6cd5\u83b7\u5f97MD5\u5b9e\u4f8b");
            e.printStackTrace();
            return null;
        }
    }

    public static final String encode(String origin) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return MD5CodeUtil.byteArrayToHexString(md.digest(new String(origin).getBytes()));
        }
        catch (Exception e) {
            System.err.println("\u65e0\u6cd5\u83b7\u5f97MD5\u5b9e\u4f8b");
            e.printStackTrace();
            return "";
        }
    }

    public static final byte[] encode(byte[] origin) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(origin);
        }
        catch (Exception e) {
            System.err.println("\u65e0\u6cd5\u83b7\u5f97MD5\u5b9e\u4f8b");
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static String md5(String x) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(x.getBytes("UTF8"));
            byte[] s = m.digest();
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < s.length) {
                result.append(Integer.toHexString(0xFF & s[i] | 0xFFFFFF00).substring(6));
                ++i;
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }
}

