/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.framework.commons.util;

import cn.gyee.appsoft.framework.core.orm.PaginationList;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class JsonUtils {
    private static ObjectMapper mapper = new ObjectMapper();
    public static final String SIMPLE_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    static {
        mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.getSerializationConfig().setDateFormat((DateFormat)df);
        mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public static ObjectMapper getMapperBinder() {
        return mapper;
    }

    public static String toJson(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object fromJson(String json, Class<?> clazz) {
        try {
            return mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String wrapListForGrid(List data, int page) {
        if (page <= 0) {
            page = 1;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("page", page);
        map.put("rows", data);
        if (data instanceof PaginationList) {
            map.put("total", ((PaginationList)data).getTotal());
        } else {
            map.put("total", data.size());
        }
        return JsonUtils.toJson(map);
    }

    public static String wrapListForExtGrid(List data, Integer start, Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("ROOT", data);
        map.put("start", start);
        map.put("limit", limit);
        if (data instanceof PaginationList) {
            map.put("TOTALCOUNT", ((PaginationList)data).getTotal());
        } else {
            map.put("TOTALCOUNT", data.size());
        }
        return JsonUtils.toJson(map);
    }
}

