/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.cache;

import cn.gyee.appsoft.cache.bean.Expire;
import cn.gyee.appsoft.cache.bean.MemCache;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.Counter;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;

public class MemClient {
    private MemcachedClient memcachedClient;

    public static int getExpireNumber(int num, Expire expire) {
        if (expire == Expire.FOREVER) {
            num = 0;
        } else if (expire == Expire.MINUTE) {
            num *= 60;
        } else if (expire == Expire.HOUR) {
            num *= 3600;
        } else if (expire == Expire.DAY) {
            num *= 86400;
        }
        return num;
    }

    public <T> T get(String key) throws TimeoutException, InterruptedException, MemcachedException {
        return (T)this.memcachedClient.get(key);
    }

    public long incr(String key) throws TimeoutException, InterruptedException, MemcachedException {
        return this.memcachedClient.incr(key, 1L);
    }

    public long decr(String key) throws TimeoutException, InterruptedException, MemcachedException {
        return this.memcachedClient.decr(key, 1L);
    }

    public long getCounter(String key) throws TimeoutException, InterruptedException, MemcachedException {
        Counter count = this.memcachedClient.getCounter(key, -1L);
        return count.get();
    }

    public boolean touch(String key, int num, Expire expire) throws TimeoutException, InterruptedException, MemcachedException {
        return this.memcachedClient.touch(key, MemClient.getExpireNumber(num, expire));
    }

    public boolean delete(String key) throws TimeoutException, InterruptedException, MemcachedException {
        return this.memcachedClient.delete(key);
    }

    public boolean set(String key, Object value) throws TimeoutException, InterruptedException, MemcachedException {
        return this.memcachedClient.set(key, 0, value);
    }

    public boolean add(String key, Object value) throws TimeoutException, InterruptedException, MemcachedException {
        return this.memcachedClient.add(key, 0, value);
    }

    public boolean replace(String key, Object value) throws TimeoutException, InterruptedException, MemcachedException {
        return this.memcachedClient.replace(key, 0, value);
    }

    public boolean set(MemCache<?> cache) throws TimeoutException, InterruptedException, MemcachedException {
        return this.memcachedClient.set(cache.getKey(), cache.getExpire(), cache.getValue());
    }

    public boolean add(MemCache<?> cache) throws TimeoutException, InterruptedException, MemcachedException {
        return this.memcachedClient.add(cache.getKey(), cache.getExpire(), cache.getValue());
    }

    public boolean replace(MemCache<?> cache) throws TimeoutException, InterruptedException, MemcachedException {
        return this.memcachedClient.replace(cache.getKey(), cache.getExpire(), cache.getValue());
    }

    public void shutdown() throws IOException {
        this.memcachedClient.shutdown();
    }

    public MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    public void setMemcachedClient(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }
}

