/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator.big;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.compile.InterpreterSourceBuilder;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.exception.EvalException;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.function.operator.big.BigAdd;
import com.greenpineyu.fel.parser.FelNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class BigSub
extends StableFunction {
    @Override
    public Object call(FelNode felNode, FelContext felContext) {
        List<FelNode> list = felNode.getChildren();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object object = TolerantFunction.eval(felContext, list.get(0));
        Object object2 = null;
        if (list.size() == 1) {
            object2 = object;
            object = 0;
        } else {
            object2 = TolerantFunction.eval(felContext, list.get(1));
        }
        try {
            if (BigAdd.isFloat(object) || BigAdd.isFloat(object2)) {
                BigDecimal bigDecimal = NumberUtil.toBigDecimal(object);
                BigDecimal bigDecimal2 = NumberUtil.toBigDecimal(object2);
                return bigDecimal.subtract(bigDecimal2);
            }
            if (BigAdd.isInt(object) && BigAdd.isInt(object2)) {
                BigInteger bigInteger = NumberUtil.toBigInteger(object);
                BigInteger bigInteger2 = NumberUtil.toBigInteger(object2);
                return bigInteger.subtract(bigInteger2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new EvalException("\u6267\u884c\u51cf\u6cd5\u5931\u8d25[" + object + "-" + object2 + "]", numberFormatException);
        }
        throw new EvalException("\u6267\u884c\u51cf\u6cd5\u5931\u8d25[" + object + "-" + object2 + "]");
    }

    @Override
    public String getName() {
        return "-";
    }

    @Override
    public SourceBuilder toMethod(FelNode felNode, FelContext felContext) {
        return InterpreterSourceBuilder.getInstance();
    }

    public static void main(String[] stringArray) {
    }
}

