/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ReflectUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.function.operator.NotEqual;
import com.greenpineyu.fel.parser.FelNode;
import java.math.BigDecimal;
import java.util.List;

public class Equal
extends StableFunction {
    @Override
    public String getName() {
        return "==";
    }

    @Override
    public Object call(FelNode felNode, FelContext felContext) {
        List<FelNode> list = felNode.getChildren();
        if (list != null && list.size() == 2) {
            Object object = TolerantFunction.eval(felContext, list.get(0));
            Object object2 = TolerantFunction.eval(felContext, list.get(1));
            return this.compare(object, object2);
        }
        throw new NullPointerException("\u4f20\u5165\u53c2\u6570\u6570\u7ec4\u4e3a\u7a7a\u6216\u8005\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e!");
    }

    boolean compare(Object object, Object object2) {
        return this.equals(object, object2);
    }

    public boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass().equals(object2.getClass())) {
            return object.equals(object2);
        }
        if (object instanceof Number && object2 instanceof Number) {
            return this.compareNumber(object, object2);
        }
        return object.equals(object2);
    }

    protected boolean compareNumber(Object object, Object object2) {
        if (object instanceof BigDecimal || object2 instanceof BigDecimal) {
            return NumberUtil.toBigDecimal(object).compareTo(NumberUtil.toBigDecimal(object2)) == 0;
        }
        if (NumberUtil.isFloatingPointNumber(object) || NumberUtil.isFloatingPointNumber(object2)) {
            return NumberUtil.toDouble(object) == NumberUtil.toDouble(object2);
        }
        return NumberUtil.toLong(object) == NumberUtil.toLong(object2);
    }

    @Override
    public SourceBuilder toMethod(FelNode felNode, FelContext felContext) {
        String string = this.getName();
        return this.toMethod(felNode, felContext, string);
    }

    private FelMethod toMethod(FelNode felNode, FelContext felContext, String string) {
        StringBuilder stringBuilder = Equal.buildRelationExpr(felNode, felContext, string);
        if (stringBuilder.length() == 0) {
            String string2 = Equal.getChildCode(felNode, felContext, 0);
            String string3 = Equal.getChildCode(felNode, felContext, 1);
            String string4 = this.toMethod(string2, string3);
            stringBuilder.append(string4);
        }
        return new FelMethod(Boolean.class, stringBuilder.toString());
    }

    String toMethod(String string, String string2) {
        return "ObjectUtils.equals(" + string + "," + string2 + ")";
    }

    public static String getChildCode(FelNode felNode, FelContext felContext, int n) {
        List<FelNode> list = felNode.getChildren();
        FelNode felNode2 = list.get(n);
        SourceBuilder sourceBuilder = felNode2.toMethod(felContext);
        String string = "(" + sourceBuilder.source(felContext, felNode2) + ")";
        return string;
    }

    private static StringBuilder buildRelationExpr(FelNode felNode, FelContext felContext, String string) {
        List<FelNode> list = felNode.getChildren();
        FelNode felNode2 = list.get(0);
        FelNode felNode3 = list.get(1);
        SourceBuilder sourceBuilder = felNode2.toMethod(felContext);
        SourceBuilder sourceBuilder2 = felNode3.toMethod(felContext);
        Class<?> clazz = sourceBuilder.returnType(felContext, felNode2);
        Class<?> clazz2 = sourceBuilder2.returnType(felContext, felNode3);
        String string2 = "(" + sourceBuilder.source(felContext, felNode2) + ")";
        String string3 = "(" + sourceBuilder2.source(felContext, felNode3) + ")";
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = new NotEqual().getName().equals(string);
        if (ReflectUtil.isPrimitiveOrWrapNumber(clazz) && ReflectUtil.isPrimitiveOrWrapNumber(clazz2)) {
            if (bl) {
                stringBuilder.append("!");
            }
            return stringBuilder.append("NumberUtil.equals(" + string2 + "," + string3 + ")");
        }
        if (bl) {
            stringBuilder.append("!");
        }
        return stringBuilder.append("ObjectUtils.equals(" + string2 + "," + string3 + ")");
    }
}

