/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function;

import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.compile.VarBuffer;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.CommonFunction;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.function.operator.Dot;
import com.greenpineyu.fel.parser.FelNode;
import java.lang.reflect.Method;
import java.util.List;

public class JavaMethod
implements Function {
    private String name;
    private Object obj;
    private Method method;

    public JavaMethod(String string, Method method, Object object) {
        this.name = string;
        this.method = method;
        this.obj = object;
    }

    @Override
    public Object call(FelNode felNode, FelContext felContext) {
        Object[] objectArray = CommonFunction.evalArgs(felNode, felContext);
        return Dot.invoke(this.obj, this.method, objectArray);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SourceBuilder toMethod(FelNode felNode, FelContext felContext) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getClassOrObjCode();
        stringBuilder.append(string);
        stringBuilder.append(".");
        String string2 = this.method.getName();
        stringBuilder.append(string2);
        StringBuilder stringBuilder2 = this.getParamsCode(felNode, felContext);
        stringBuilder.append("(").append((CharSequence)stringBuilder2).append(")");
        FelMethod felMethod = new FelMethod(this.method.getReturnType(), stringBuilder.toString());
        return felMethod;
    }

    private String getClassOrObjCode() {
        if (this.obj == null) {
            Class<?> clazz = this.method.getDeclaringClass();
            return clazz.getCanonicalName();
        }
        String string = VarBuffer.push(this.obj);
        return string;
    }

    private StringBuilder getParamsCode(FelNode felNode, FelContext felContext) {
        StringBuilder stringBuilder = new StringBuilder();
        List<FelNode> list = felNode.getChildren();
        boolean bl = list != null && !list.isEmpty();
        Class<?>[] classArray = this.method.getParameterTypes();
        if (bl) {
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz = classArray[i];
                FelNode felNode2 = list.get(i);
                String string = Dot.getParamCode(clazz, felNode2, felContext);
                stringBuilder.append(string);
                if (i >= classArray.length - 1) continue;
                stringBuilder.append(",");
            }
        }
        return stringBuilder;
    }

    public static void main(String[] stringArray) throws SecurityException, NoSuchMethodException {
    }
}

