/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.compile;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.FelEngineImpl;
import com.greenpineyu.fel.common.Callable;
import com.greenpineyu.fel.common.ReflectUtil;
import com.greenpineyu.fel.common.StringUtils;
import com.greenpineyu.fel.compile.ConstExpSrc;
import com.greenpineyu.fel.compile.JavaSource;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.compile.SourceGenerator;
import com.greenpineyu.fel.compile.VarBuffer;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.optimizer.ConstExpOpti;
import com.greenpineyu.fel.optimizer.ConstOpti;
import com.greenpineyu.fel.optimizer.Optimizer;
import com.greenpineyu.fel.parser.AbstFelNode;
import com.greenpineyu.fel.parser.ConstNode;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.parser.VarAstNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceGeneratorImpl
implements SourceGenerator {
    private List<Optimizer> opt = new ArrayList<Optimizer>();
    private static String template;
    private static int count;
    private Map<String, StringKeyValue> localvars = new HashMap<String, StringKeyValue>();
    static final String PACKAGE;
    public static final Callable<Boolean, FelNode> varsFilter;

    public SourceGeneratorImpl() {
        this.initOpti();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaSource getSource(FelContext felContext, FelNode felNode) {
        String string = "";
        String string2 = this.getClassName();
        Object object = this;
        synchronized (object) {
            felNode = this.optimize(felContext, felNode);
            if (felNode instanceof ConstNode) {
                ConstNode constNode = (ConstNode)felNode;
                return new ConstExpSrc(constNode.interpret(null, null));
            }
            SourceBuilder sourceBuilder = felNode.toMethod(felContext);
            String string3 = sourceBuilder.source(felContext, felNode);
            string = this.buildsource(string3, string2);
            this.localvars.clear();
        }
        object = new JavaSource();
        ((JavaSource)object).setSimpleName(string2);
        ((JavaSource)object).setSource(string);
        ((JavaSource)object).setPackageName(PACKAGE);
        return object;
    }

    private String buildsource(String string, String string2) {
        String string3 = StringUtils.replace(template, "${classname}", string2);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = VarBuffer.pop();
        if (string4 != null) {
            stringBuilder.append(string4).append("\r\n");
            string4 = VarBuffer.pop();
        }
        while (string4 != null) {
            stringBuilder.append("    ").append(string4).append("\r\n");
            string4 = VarBuffer.pop();
        }
        string3 = StringUtils.replace(string3, "${attrs}", stringBuilder.toString());
        string3 = StringUtils.replace(string3, "${localVars}", this.getLocalVarsCode());
        string3 = StringUtils.replace(string3, "${expression}", string);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getClassName() {
        String string = null;
        Class<SourceGeneratorImpl> clazz = SourceGeneratorImpl.class;
        synchronized (SourceGeneratorImpl.class) {
            string = "Fel_" + count++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return string;
        }
    }

    private String getLocalVarsCode() {
        StringBuilder stringBuilder = new StringBuilder();
        Collection<StringKeyValue> collection = this.localvars.values();
        boolean bl = true;
        for (StringKeyValue stringKeyValue : collection) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("        ");
            }
            stringBuilder.append(stringKeyValue.value).append("\r\n");
        }
        this.removeLastEnter(stringBuilder);
        return stringBuilder.toString();
    }

    private void removeLastEnter(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
    }

    private FelNode optimize(FelContext felContext, FelNode felNode) {
        for (Optimizer optimizer : this.opt) {
            felNode = optimizer.call(felContext, felNode);
        }
        return felNode;
    }

    private void initOpti() {
        ConstOpti constOpti = new ConstOpti();
        this.addOpti(constOpti);
        ConstExpOpti constExpOpti = new ConstExpOpti();
        this.addOpti(constExpOpti);
        Optimizer optimizer = this.getVarOpti();
        this.addOpti(optimizer);
    }

    private Optimizer getVarOpti() {
        Optimizer optimizer = new Optimizer(){

            @Override
            public FelNode call(FelContext felContext, FelNode felNode) {
                List<FelNode> list = AbstFelNode.getNodes(felNode, varsFilter);
                HashMap<Object, ArrayList<FelNode>> hashMap = new HashMap<Object, ArrayList<FelNode>>();
                for (FelNode object2 : list) {
                    String string = object2.getText();
                    ArrayList<FelNode> arrayList = (ArrayList<FelNode>)hashMap.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<FelNode>();
                        hashMap.put(string, arrayList);
                    }
                    arrayList.add(object2);
                }
                for (List list2 : hashMap.values()) {
                    if (list2.size() <= 1) continue;
                    for (ArrayList<FelNode> arrayList : list2) {
                        arrayList.setSourcebuilder(this.getVarSrcBuilder(arrayList.toMethod(felContext)));
                    }
                }
                return felNode;
            }

            private void setVarSourceBuilder(FelContext felContext, FelNode felNode) {
                if (felNode instanceof VarAstNode) {
                    felNode.setSourcebuilder(this.getVarSrcBuilder(felNode.toMethod(felContext)));
                } else {
                    List<FelNode> list = felNode.getChildren();
                    if (list != null && !list.isEmpty()) {
                        for (FelNode felNode2 : list) {
                            this.setVarSourceBuilder(felContext, felNode2);
                        }
                    }
                }
            }

            private SourceBuilder getVarSrcBuilder(final SourceBuilder sourceBuilder) {
                return new SourceBuilder(){

                    @Override
                    public String source(FelContext felContext, FelNode felNode) {
                        Object object;
                        String string = felNode.getText();
                        if (SourceGeneratorImpl.this.localvars.containsKey(string)) {
                            StringKeyValue stringKeyValue = (StringKeyValue)SourceGeneratorImpl.this.localvars.get(string);
                            return stringKeyValue.key;
                        }
                        String string2 = string;
                        Class<?> clazz = this.returnType(felContext, felNode);
                        String string3 = "";
                        String string4 = clazz.getCanonicalName();
                        if (ReflectUtil.isPrimitiveOrWrapNumber(clazz)) {
                            object = ReflectUtil.toPrimitiveClass(clazz);
                            string4 = ((Class)object).getSimpleName();
                        } else if (Number.class.isAssignableFrom(clazz)) {
                            string4 = "double";
                        }
                        string3 = string4 + " " + string2 + " = " + sourceBuilder.source(felContext, felNode) + ";   //" + string;
                        object = new StringKeyValue(string2, string3);
                        SourceGeneratorImpl.this.localvars.put(string, object);
                        return string2;
                    }

                    @Override
                    public Class<?> returnType(FelContext felContext, FelNode felNode) {
                        return sourceBuilder.returnType(felContext, felNode);
                    }
                };
            }
        };
        return optimizer;
    }

    @Override
    public void addOpti(Optimizer optimizer) {
        this.opt.add(optimizer);
    }

    public static void main(String[] stringArray) {
        FelEngineImpl felEngineImpl = new FelEngineImpl();
        FelContext felContext = felEngineImpl.getContext();
        felContext.set("i", 100);
        felContext.set("pi", Float.valueOf(3.14f));
        String string = "pi*i*i*pi";
        Expression expression = felEngineImpl.compile(string, felContext, new Optimizer[0]);
        Object object = expression.eval(felContext);
        SourceGeneratorImpl.cost(felContext, expression);
        System.out.println(object);
    }

    private static void cost(FelContext felContext, Expression expression) {
        int n = 10000000;
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            expression.eval(felContext);
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l);
    }

    static {
        count = 0;
        String string = SourceGeneratorImpl.class.getName();
        PACKAGE = string.substring(0, string.lastIndexOf("."));
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = SourceGeneratorImpl.class.getResourceAsStream("java.template");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\r\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        template = stringBuilder.toString();
        varsFilter = new Callable<Boolean, FelNode>(){

            public Boolean call(FelNode ... felNodeArray) {
                FelNode felNode = felNodeArray[0];
                return VarAstNode.isVar(felNode);
            }
        };
    }

    class StringKeyValue {
        String key;
        String value;

        public StringKeyValue(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }
}

