/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.compile;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.compile.CompileService;
import com.greenpineyu.fel.compile.FelCompiler;
import com.greenpineyu.fel.compile.FelCompilerClassloader;
import com.greenpineyu.fel.compile.FelJavaFileObject;
import com.greenpineyu.fel.compile.JavaSource;
import com.greenpineyu.fel.exception.CompileException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class FelCompiler16<T>
implements FelCompiler {
    private final FelCompilerClassloader classLoader;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final List<String> options;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private final JavaFileManager javaFileManager;

    public FelCompiler16() {
        if (this.compiler == null) {
            throw new IllegalStateException("Cannot find the system Java compiler. Check that your class path includes tools.jar");
        }
        this.classLoader = new FelCompilerClassloader(this.getClass().getClassLoader());
        this.diagnostics = new DiagnosticCollector();
        StandardJavaFileManager standardJavaFileManager = this.compiler.getStandardFileManager(this.diagnostics, null, null);
        ClassLoader classLoader = this.classLoader.getParent();
        List<String> list = CompileService.getClassPath(classLoader);
        ArrayList<File> arrayList = new ArrayList<File>();
        if (list != null && !list.isEmpty()) {
            for (String string : list) {
                arrayList.add(new File(string));
            }
        }
        try {
            standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, arrayList);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.javaFileManager = new ForwardingJavaFileManager<JavaFileManager>((JavaFileManager)standardJavaFileManager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
                FelCompiler16.this.classLoader.add(string, fileObject);
                return (JavaFileObject)fileObject;
            }
        };
        this.options = new ArrayList<String>();
    }

    @Override
    public Expression compile(JavaSource javaSource) {
        Class<T> clazz = this.compileToClass(javaSource);
        try {
            return (Expression)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    public synchronized Class<T> compileToClass(JavaSource javaSource) {
        ArrayList<FelJavaFileObject> arrayList = new ArrayList<FelJavaFileObject>();
        String string = javaSource.getSimpleName();
        FelJavaFileObject felJavaFileObject = new FelJavaFileObject(string, javaSource.getSource());
        arrayList.add(felJavaFileObject);
        JavaCompiler.CompilationTask compilationTask = this.compiler.getTask(null, this.javaFileManager, this.diagnostics, this.options, null, arrayList);
        Boolean bl = compilationTask.call();
        if (bl == null || !bl.booleanValue()) {
            throw new CompileException(javaSource.getSource() + "\n" + this.diagnostics.getDiagnostics().toString());
        }
        try {
            return this.loadClass(javaSource.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public Class<T> loadClass(String string) throws ClassNotFoundException {
        return this.classLoader.loadClass(string);
    }

    static URI toUri(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

